/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.server.web;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.eclipse.emf.texo.component.ComponentProvider;
import org.eclipse.emf.texo.component.TexoComponent;
import org.eclipse.emf.texo.server.service.DeleteModelOperation;
import org.eclipse.emf.texo.server.service.RetrieveModelOperation;
import org.eclipse.emf.texo.server.service.ServiceContext;
import org.eclipse.emf.texo.server.service.ServiceUtils;
import org.eclipse.emf.texo.server.service.UpdateInsertModelOperation;
import org.eclipse.emf.texo.server.store.EntityManagerObjectStore;
import org.eclipse.emf.texo.server.store.EntityManagerProvider;

public abstract class WebServiceHandler
implements TexoComponent {
    private String uri = null;
    private ServiceContextResultProcessor serviceContextResultProcessor = (ServiceContextResultProcessor)ComponentProvider.getInstance().newInstance(ServiceContextResultProcessor.class);

    public void doDelete(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ServiceContext serviceContext = this.createServiceContext(req);
        try {
            DeleteModelOperation operation = (DeleteModelOperation)ComponentProvider.getInstance().newInstance(DeleteModelOperation.class);
            operation.setServiceContext(serviceContext);
            operation.execute();
            this.setResultInResponse(serviceContext, resp);
            operation.close();
        }
        finally {
            this.releaseEntityManager((EntityManager)serviceContext.getObjectStore().getDelegate());
        }
    }

    public void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ServiceContext serviceContext = this.createServiceContext(req);
        try {
            RetrieveModelOperation retrieveModelOperation = (RetrieveModelOperation)ComponentProvider.getInstance().newInstance(RetrieveModelOperation.class);
            retrieveModelOperation.setServiceContext(serviceContext);
            retrieveModelOperation.execute();
            this.setResultInResponse(serviceContext, resp);
            retrieveModelOperation.close();
        }
        finally {
            this.releaseEntityManager((EntityManager)serviceContext.getObjectStore().getDelegate());
        }
    }

    public void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        ServiceContext serviceContext = this.createServiceContext(req);
        if (serviceContext.isErrorOccured()) {
            this.setResultInResponse(serviceContext, resp);
            return;
        }
        try {
            UpdateInsertModelOperation operation = (UpdateInsertModelOperation)ComponentProvider.getInstance().newInstance(UpdateInsertModelOperation.class);
            operation.setServiceContext(serviceContext);
            operation.execute();
            this.setResultInResponse(serviceContext, resp);
            operation.close();
        }
        finally {
            this.releaseEntityManager((EntityManager)serviceContext.getObjectStore().getDelegate());
        }
    }

    public void doPut(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        this.doPost(req, resp);
    }

    protected ServiceContext createServiceContext(HttpServletRequest request) {
        String requestUrl = request.getRequestURL().toString();
        EntityManager entityManager = null;
        ServiceContext serviceContext = null;
        try {
            String objectStoreUri;
            serviceContext = this.createServiceContext();
            entityManager = this.createEntityManager();
            serviceContext.setRequestURI(requestUrl);
            serviceContext.setServiceRequestURI(request.getPathInfo());
            EntityManagerObjectStore emObjectStore = (EntityManagerObjectStore)((Object)ComponentProvider.getInstance().newInstance(EntityManagerObjectStore.class));
            emObjectStore.setEntityManager(entityManager);
            String string = objectStoreUri = this.getUri() == null ? request.getContextPath() : this.getUri();
            if (this.getUri() == null) {
                int contextIndex = requestUrl.indexOf(String.valueOf(request.getContextPath()) + "/");
                objectStoreUri = String.valueOf(requestUrl.substring(0, contextIndex)) + request.getContextPath() + request.getServletPath();
            } else {
                objectStoreUri = this.getUri();
            }
            emObjectStore.setUri(objectStoreUri);
            HashMap<String, Object> params = new HashMap<String, Object>();
            Enumeration enumeration = request.getParameterNames();
            while (enumeration.hasMoreElements()) {
                String name = (String)enumeration.nextElement();
                String[] vals = request.getParameterValues(name);
                if (vals.length == 1) {
                    params.put(name, vals[0]);
                    continue;
                }
                params.put(name, vals);
            }
            serviceContext.setObjectStore(emObjectStore);
            serviceContext.setRequestParameters(params);
            serviceContext.setRequestContent(ServiceUtils.toString((InputStream)request.getInputStream(), request.getCharacterEncoding()));
            return serviceContext;
        }
        catch (Throwable t) {
            if (entityManager != null) {
                this.releaseEntityManager(entityManager);
            }
            if (serviceContext != null) {
                serviceContext.createErrorResult(t);
                return serviceContext;
            }
            throw new IllegalStateException(t);
        }
    }

    protected void setResultInResponse(ServiceContext serviceContext, HttpServletResponse resp) throws IOException {
        this.serviceContextResultProcessor.startOfRequest();
        this.serviceContextResultProcessor.setServiceContext(serviceContext);
        String result = this.serviceContextResultProcessor.getResponseContent();
        resp.setContentType(this.serviceContextResultProcessor.getResponseContentType());
        resp.setStatus(this.serviceContextResultProcessor.getResponseCode());
        resp.getWriter().write(result);
        resp.getWriter().close();
        this.serviceContextResultProcessor.endOfRequest();
    }

    protected abstract ServiceContext createServiceContext();

    protected EntityManager createEntityManager() {
        return EntityManagerProvider.getInstance().createEntityManager();
    }

    protected void releaseEntityManager(EntityManager entityManager) {
        EntityManagerProvider.getInstance().releaseEntityManager(entityManager);
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public ServiceContextResultProcessor getServiceContextResultProcessor() {
        return this.serviceContextResultProcessor;
    }

    public void setServiceContextResultProcessor(ServiceContextResultProcessor serviceContextResultProcessor) {
        this.serviceContextResultProcessor = serviceContextResultProcessor;
    }

    public static class ServiceContextResultProcessor
    implements TexoComponent {
        private ServiceContext serviceContext;

        public String getResponseContent() {
            return this.serviceContext.getResponseContent();
        }

        public int getResponseCode() {
            return this.serviceContext.getResponseCode();
        }

        public String getResponseContentType() {
            return this.serviceContext.getResponseContentType();
        }

        public ServiceContext getServiceContext() {
            return this.serviceContext;
        }

        public void setServiceContext(ServiceContext serviceContext) {
            this.serviceContext = serviceContext;
        }

        public void startOfRequest() {
        }

        public void endOfRequest() {
        }
    }

    public static class XSLTServiceContextResultProcessor
    extends ServiceContextResultProcessor {
        private boolean errorOccured = false;
        private String templateClassPathLocation = null;
        private Map<String, Object> parameters = new HashMap<String, Object>();

        public String getResponseContent() {
            try {
                return this.applyTemplate(this.getServiceContext().getResponseContent(), this.getTemplateClassPathLocation());
            }
            catch (Exception e) {
                this.errorOccured = true;
                throw new IllegalStateException(e);
            }
        }

        public int getResponseCode() {
            if (this.errorOccured) {
                return 500;
            }
            return this.getServiceContext().getResponseCode();
        }

        public void addParameter(String name, Object value) {
            this.parameters.put(name, value);
        }

        private String applyTemplate(String xml, String template) {
            try {
                InputStream is = this.getClass().getResourceAsStream(template);
                TransformerFactory factory = TransformerFactory.newInstance();
                Transformer transformer = factory.newTransformer(new StreamSource(is));
                for (String key : this.parameters.keySet()) {
                    transformer.setParameter(key, this.parameters.get(key));
                }
                StringWriter sw = new StringWriter();
                StreamResult response = new StreamResult(sw);
                transformer.transform(new StreamSource(new StringReader(xml)), response);
                return sw.toString();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }

        public String getTemplateClassPathLocation() {
            return this.templateClassPathLocation;
        }

        public void setTemplateClassPathLocation(String templateClassPathLocation) {
            this.templateClassPathLocation = templateClassPathLocation;
        }
    }
}

