/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.server.model.response;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Lob;
import org.eclipse.emf.texo.server.model.response.ErrorType;
import org.eclipse.emf.texo.server.model.response.ResponseType;
import org.eclipse.emf.texo.server.model.response.ResultType;

public class DocumentRootMixedFeatureGroup {
    @Basic
    @Enumerated(value=EnumType.STRING)
    private Feature feature = null;
    @Basic(optional=true)
    @Lob
    private String text;
    @Basic(optional=true)
    @Lob
    private String cDATA;
    @Basic(optional=true)
    @Lob
    private String comment;
    private ErrorType error;
    private ResponseType response;
    private ResultType result;

    public static <T> List<T> createUnmodifiableValueList(List<DocumentRootMixedFeatureGroup> featureGroup, Feature filterByFeature) {
        ArrayList<Object> result = new ArrayList<Object>();
        for (DocumentRootMixedFeatureGroup group : featureGroup) {
            if (group.getFeature() != filterByFeature) continue;
            result.add(group.getValue());
        }
        return Collections.unmodifiableList(result);
    }

    public static <T> T getSingleFeatureMapValue(List<DocumentRootMixedFeatureGroup> featureGroup, Feature filterByFeature) {
        for (DocumentRootMixedFeatureGroup group : featureGroup) {
            if (group.getFeature() != filterByFeature) continue;
            return (T)group.getValue();
        }
        return null;
    }

    public static void setSingleFeatureMapValue(List<DocumentRootMixedFeatureGroup> featureGroup, Feature feature, Object value) {
        for (DocumentRootMixedFeatureGroup group : featureGroup) {
            if (group.getFeature() != feature) continue;
            group.setValue(feature, value);
            return;
        }
        DocumentRootMixedFeatureGroup entry = new DocumentRootMixedFeatureGroup();
        entry.setValue(feature, value);
        featureGroup.add(entry);
    }

    public static List<DocumentRootMixedFeatureGroup> createFeatureGroupList(Feature feature, List<?> values) {
        ArrayList<DocumentRootMixedFeatureGroup> result = new ArrayList<DocumentRootMixedFeatureGroup>();
        for (Object value : values) {
            DocumentRootMixedFeatureGroup group = new DocumentRootMixedFeatureGroup();
            group.setValue(feature, value);
            result.add(group);
        }
        return result;
    }

    public void setFeature(Feature feature) {
        this.feature = feature;
    }

    public Feature getFeature() {
        return this.feature;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String newText) {
        this.text = newText;
        this.setFeature(Feature.TEXT);
    }

    public String getCDATA() {
        return this.cDATA;
    }

    public void setCDATA(String newCDATA) {
        this.cDATA = newCDATA;
        this.setFeature(Feature.CDATA);
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String newComment) {
        this.comment = newComment;
        this.setFeature(Feature.COMMENT);
    }

    public ErrorType getError() {
        return this.error;
    }

    public void setError(ErrorType newError) {
        this.error = newError;
        this.setFeature(Feature.ERROR);
    }

    public ResponseType getResponse() {
        return this.response;
    }

    public void setResponse(ResponseType newResponse) {
        this.response = newResponse;
        this.setFeature(Feature.RESPONSE);
    }

    public ResultType getResult() {
        return this.result;
    }

    public void setResult(ResultType newResult) {
        this.result = newResult;
        this.setFeature(Feature.RESULT);
    }

    public Object getValue() {
        switch (this.getFeature()) {
            case TEXT: {
                return this.getText();
            }
            case CDATA: {
                return this.getCDATA();
            }
            case COMMENT: {
                return this.getComment();
            }
            case ERROR: {
                return this.getError();
            }
            case RESPONSE: {
                return this.getResponse();
            }
            case RESULT: {
                return this.getResult();
            }
        }
        throw new IllegalStateException("Feature kind " + (Object)((Object)this.getFeature()) + " is not supported for this object " + this);
    }

    public void setValue(Feature feature, Object value) {
        switch (feature) {
            case TEXT: {
                this.setText((String)value);
                break;
            }
            case CDATA: {
                this.setCDATA((String)value);
                break;
            }
            case COMMENT: {
                this.setComment((String)value);
                break;
            }
            case ERROR: {
                this.setError((ErrorType)value);
                break;
            }
            case RESPONSE: {
                this.setResponse((ResponseType)value);
                break;
            }
            case RESULT: {
                this.setResult((ResultType)value);
                break;
            }
            default: {
                throw new IllegalStateException("Feature kind " + (Object)((Object)this.getFeature()) + " is not supported for this object " + this);
            }
        }
    }

    public static enum Feature {
        TEXT,
        CDATA,
        COMMENT,
        ACTION,
        ERROR,
        RESPONSE,
        RESULT;

    }
}

