/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.server.service;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.texo.provider.IdProvider;
import org.eclipse.emf.texo.server.model.request.QueryType;
import org.eclipse.emf.texo.server.model.response.ResponseModelPackage;
import org.eclipse.emf.texo.server.model.response.ResultType;
import org.eclipse.emf.texo.server.service.ModelOperation;
import org.eclipse.emf.texo.server.service.ServiceUtils;
import org.eclipse.emf.texo.utils.ModelUtils;

public class DeleteModelOperation
extends ModelOperation {
    @Override
    protected void internalExecute() {
        List<Object> toDelete;
        String qryStr = (String)this.getServiceContext().getRequestParameters().get("query");
        QueryType queryType = this.getQueryType();
        if (queryType != null) {
            toDelete = this.getObjectStore().query(qryStr, this.getParameters(queryType), queryType.getFirstResult(), queryType.getMaxResults());
        } else if (this.getServiceContext().getRequestParameters().containsKey("id")) {
            URI uri = URI.createURI((String)((String)this.getServiceContext().getRequestParameters().get("id")));
            Object object = this.getObjectStore().fromUri(uri);
            toDelete = Collections.singletonList(object);
        } else {
            String[] segments = ServiceUtils.getSegments(this.getServiceContext().getServiceRequestURI());
            if (segments.length < 2) {
                toDelete = this.getServiceContext().getRequestData();
            } else if (segments.length == 2) {
                EClass eClass = ModelUtils.getEClassFromQualifiedName((String)segments[0]);
                String idString = segments[1];
                Object id = IdProvider.getInstance().convertIdStringToId(eClass, idString);
                Object object = this.getObjectStore().get(eClass, id);
                toDelete = Collections.singletonList(object);
            } else {
                throw new IllegalArgumentException("Service path " + this.getServiceContext().getServiceRequestURI() + " not supported, uri " + this.getServiceContext().getRequestURI());
            }
        }
        ResultType result = ResponseModelPackage.INSTANCE.getModelFactory().createResultType();
        for (Object e : toDelete) {
            this.getObjectStore().remove(e);
            result.getDeleted().add(e);
        }
        this.getServiceContext().setResultInResponse(result);
    }
}

