/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.server.service;

import java.util.Map;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.texo.component.ComponentProvider;
import org.eclipse.emf.texo.component.TexoComponent;
import org.eclipse.emf.texo.server.service.SenchaQueryBuilder;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class QueryBuilder
implements TexoComponent {
    private static final char ESCAPE_CHAR = '|';
    private static final String CLIENT_PARAM = "client";
    private String entityName;
    private JSONArray filterJSON;
    private JSONArray sortJSON;

    public static QueryBuilder getQueryBuilder(String entityName, EClass eClass, Map<String, Object> parameters) {
        QueryBuilder queryBuilder = "sencha".equals(parameters.get(CLIENT_PARAM)) ? (QueryBuilder)ComponentProvider.getInstance().newInstance(SenchaQueryBuilder.class) : (QueryBuilder)ComponentProvider.getInstance().newInstance(QueryBuilder.class);
        queryBuilder.setEntityName(entityName);
        queryBuilder.setFilterSort(parameters);
        return queryBuilder;
    }

    public String getSelectQuery() {
        try {
            return "select e " + this.getFromWhereClause();
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getFromWhereClause() throws JSONException {
        StringBuilder sb = new StringBuilder();
        sb.append("from " + this.getEntityName() + " e ");
        if (this.filterJSON != null && this.filterJSON.length() > 0) {
            boolean addOr = false;
            sb.append(" where ");
            int i = 0;
            while (i < this.filterJSON.length()) {
                JSONObject filterClause = this.filterJSON.getJSONObject(i);
                if (addOr) {
                    sb.append(" or ");
                }
                sb.append("upper(e." + filterClause.getString("property") + ")");
                sb.append(" like ");
                sb.append("'%" + this.escapeLike(filterClause.getString("value").toString().toUpperCase()).replaceAll(" ", "%") + "%' escape '" + '|' + "'");
                addOr = true;
                ++i;
            }
        }
        return sb.toString();
    }

    public String getCountQuery() {
        try {
            return "select count(e) " + this.getFromWhereClause();
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    public void setFilterSort(Map<String, Object> parameters) {
        try {
            String sort;
            String filter = (String)parameters.get(this.getFilterParamName());
            if (filter != null) {
                this.filterJSON = new JSONArray(filter);
            }
            if ((sort = (String)parameters.get(this.getSortParamName())) != null) {
                this.sortJSON = new JSONArray(sort);
            }
        }
        catch (JSONException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getFilterParamName() {
        return "filter";
    }

    private String escapeLike(String value) {
        if (value == null || value.trim().length() == 0) {
            return value;
        }
        String localValue = value.replace("|", "248");
        localValue = localValue.replace("'", "|'");
        localValue = localValue.replace("_", "|_");
        localValue = localValue.replace("%", "|%");
        return localValue;
    }

    protected String getSortParamName() {
        return "sort";
    }

    protected String getEntityName() {
        return this.entityName;
    }

    protected void setEntityName(String entityName) {
        this.entityName = entityName;
    }
}

