/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.server.service;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.texo.component.ComponentProvider;
import org.eclipse.emf.texo.component.TexoComponent;
import org.eclipse.emf.texo.server.model.request.RequestModelPackage;
import org.eclipse.emf.texo.server.model.response.ErrorType;
import org.eclipse.emf.texo.server.model.response.ResponseModelPackage;
import org.eclipse.emf.texo.server.service.ServiceOptions;
import org.eclipse.emf.texo.store.MemoryObjectStore;
import org.eclipse.emf.texo.store.ObjectStore;

public abstract class ServiceContext
implements TexoComponent {
    protected static final String CONTENT_TYPE_HEADER_PARAM = "Content-Type";
    protected static final String RESPONSE_HEADER_CACHE_CONTROL = "Cache-Control";
    protected static final String RESPONSE_NO_CACHE = "no-cache";
    private static boolean isInTexoTestRun = false;
    private String requestContent;
    private Map<String, Object> requestParameters = new HashMap<String, Object>();
    private String requestURI;
    private boolean useWebServiceUriFormat = true;
    private String serviceRequestURI;
    private String responseContent;
    private int responseCode = 200;
    private String responseContentType;
    private Map<String, String> responseHeaders = new HashMap<String, String>();
    private boolean errorOccured = false;
    private ObjectStore objectStore;
    private ServiceOptions serviceOptions = (ServiceOptions)ComponentProvider.getInstance().newInstance(ServiceOptions.class);
    private Object delegate;

    public static void setInTexoTestRun() {
        isInTexoTestRun = true;
    }

    protected static boolean isInTexoTestRun() {
        return isInTexoTestRun;
    }

    public ServiceContext() {
        this.getResponseHeaders().put(RESPONSE_HEADER_CACHE_CONTROL, RESPONSE_NO_CACHE);
        RequestModelPackage.initialize();
    }

    public String getRequestContent() {
        return this.requestContent;
    }

    public void setRequestContent(String requestContent) {
        this.requestContent = requestContent;
    }

    public Map<String, Object> getRequestParameters() {
        return this.requestParameters;
    }

    public void setRequestParameters(Map<String, Object> requestParameters) {
        this.requestParameters = requestParameters;
    }

    public String getRequestURI() {
        return this.requestURI;
    }

    public void setRequestURI(String requestURI) {
        this.requestURI = requestURI;
    }

    public String getResponseContent() {
        return this.responseContent;
    }

    public void setResponseContent(String responseContent) {
        this.responseContent = responseContent;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public void setResponseCode(int responseCode) {
        this.responseCode = responseCode;
    }

    public String getResponseContentType() {
        return this.responseContentType;
    }

    public void setResponseContentType(String responseType) {
        this.responseContentType = responseType;
        this.getResponseHeaders().put(CONTENT_TYPE_HEADER_PARAM, responseType);
    }

    public Object getDelegate() {
        return this.delegate;
    }

    public void setDelegate(Object delegate) {
        this.delegate = delegate;
    }

    public void createErrorResult(Throwable t) {
        this.setResponseCode(500);
        ErrorType error = this.createErrorType(t, new ArrayList<Throwable>());
        if (this.getObjectStore() == null) {
            this.setObjectStore((ObjectStore)ComponentProvider.getInstance().newInstance(MemoryObjectStore.class));
        }
        this.setResponseContent(this.convertToResultFormat(error));
        this.setErrorOccured(true);
    }

    public void createResourceNotFoundResult() {
        this.createErrorResult(new IllegalArgumentException("Resource not found " + this.getRequestURI()));
        this.setResponseCode(404);
    }

    public Map<String, String> getResponseHeaders() {
        return this.responseHeaders;
    }

    public boolean isErrorOccured() {
        return this.errorOccured;
    }

    public void setErrorOccured(boolean errorOccured) {
        this.errorOccured = errorOccured;
    }

    public String getServiceRequestURI() {
        return this.serviceRequestURI;
    }

    public void setServiceRequestURI(String serviceRequestURI) {
        this.serviceRequestURI = serviceRequestURI;
    }

    protected ErrorType createErrorType(Throwable t, List<Throwable> handledThrowables) {
        ErrorType error = ResponseModelPackage.INSTANCE.getModelFactory().createErrorType();
        error.setErrorClass(t.getClass().getName());
        error.setMessage(t.getMessage());
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.close();
        error.setStackTrace(sw.toString());
        if (t.getCause() != null && !handledThrowables.contains(t.getCause())) {
            error.setCause(this.createErrorType(t.getCause(), handledThrowables));
        }
        return error;
    }

    protected abstract String convertToResultFormat(Object var1);

    protected abstract String convertToResultFormat(EObject var1);

    public void setResultInResponse(Object object) {
        this.setResponseContent(this.convertToResultFormat(object));
    }

    public void setResultInResponse(EObject eObject) {
        this.setResponseContent(this.convertToResultFormat(eObject));
    }

    public abstract List<Object> getRequestData();

    public ObjectStore getObjectStore() {
        return this.objectStore;
    }

    public void setObjectStore(ObjectStore objectStore) {
        this.objectStore = objectStore;
    }

    public ServiceOptions getServiceOptions() {
        return this.serviceOptions;
    }

    public void setServiceOptions(ServiceOptions serviceOptions) {
        this.serviceOptions = serviceOptions;
    }

    public boolean isUseWebServiceUriFormat() {
        return this.useWebServiceUriFormat;
    }

    public void setUseWebServiceUriFormat(boolean useWebServiceUriFormat) {
        this.useWebServiceUriFormat = useWebServiceUriFormat;
    }
}

