/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.server.service.xml;

import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.texo.component.ComponentProvider;
import org.eclipse.emf.texo.resolver.ObjectResolver;
import org.eclipse.emf.texo.server.service.ServiceContext;
import org.eclipse.emf.texo.store.ObjectStore;
import org.eclipse.emf.texo.xml.ModelXMLLoader;
import org.eclipse.emf.texo.xml.ModelXMLSaver;

public class XMLServiceContext
extends ServiceContext {
    private static String TRUE_STRING = Boolean.TRUE.toString();

    public XMLServiceContext() {
        this.setResponseContentType("text/html;charset=UTF-8");
    }

    @Override
    public void setObjectStore(ObjectStore objectStore) {
        objectStore.setUseWebServiceUriFormat(this.isUseWebServiceUriFormat());
        super.setObjectStore(objectStore);
    }

    @Override
    protected String convertToResultFormat(Object object) {
        int childLevels = 2;
        if (this.getRequestParameters().containsKey("childLevels")) {
            try {
                childLevels = Integer.parseInt((String)this.getRequestParameters().get("childLevels"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.toXML(Collections.singletonList(object), this.isXmi(), childLevels);
    }

    @Override
    protected String convertToResultFormat(EObject eObject) {
        int childLevels = 2;
        if (this.getRequestParameters().containsKey("childLevels")) {
            try {
                childLevels = Integer.parseInt((String)this.getRequestParameters().get("childLevels"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return this.toXMLFromEObjects(Collections.singletonList(eObject), this.isXmi(), childLevels);
    }

    public boolean isXmi() {
        String xmiString = (String)this.getRequestParameters().get("xmi");
        return xmiString != null && xmiString.equals(TRUE_STRING);
    }

    @Override
    public List<Object> getRequestData() {
        return this.fromXML(this.getRequestContent(), this.isXmi());
    }

    private String toXML(List<Object> objects, boolean asXMI, int childLevels) {
        ModelXMLSaver xmlSaver = (ModelXMLSaver)ComponentProvider.getInstance().newInstance(ModelXMLSaver.class);
        xmlSaver.setOutputExtensionAttributes(true);
        xmlSaver.setSaveAsXMI(asXMI);
        xmlSaver.setObjects(objects);
        xmlSaver.getModelEMFConverter().setConvertNonContainedReferencedObjects(false);
        xmlSaver.getModelEMFConverter().setMaxChildLevelsToConvert(childLevels);
        xmlSaver.getModelEMFConverter().setObjectResolver((ObjectResolver)this.getObjectStore());
        StringWriter sw = new StringWriter();
        xmlSaver.setWriter((Writer)sw);
        xmlSaver.write();
        return sw.toString();
    }

    private String toXMLFromEObjects(List<EObject> eObjects, boolean asXMI, int childLevels) {
        ModelXMLSaver xmlSaver = (ModelXMLSaver)ComponentProvider.getInstance().newInstance(ModelXMLSaver.class);
        xmlSaver.setOutputExtensionAttributes(true);
        xmlSaver.setSaveAsXMI(asXMI);
        ArrayList<EObject> objects = new ArrayList<EObject>();
        for (EObject eObject : eObjects) {
            objects.add(eObject);
        }
        xmlSaver.setObjectsAreAlreadyEObjects(true);
        xmlSaver.setObjects(objects);
        xmlSaver.getModelEMFConverter().setConvertNonContainedReferencedObjects(false);
        xmlSaver.getModelEMFConverter().setMaxChildLevelsToConvert(childLevels);
        xmlSaver.getModelEMFConverter().setObjectResolver((ObjectResolver)this.getObjectStore());
        StringWriter sw = new StringWriter();
        xmlSaver.setWriter((Writer)sw);
        xmlSaver.write();
        return sw.toString();
    }

    private List<Object> fromXML(String content, boolean isXMI) {
        ModelXMLLoader xmlLoader = (ModelXMLLoader)ComponentProvider.getInstance().newInstance(ModelXMLLoader.class);
        xmlLoader.setLoadAsXMI(isXMI);
        xmlLoader.setReader((Reader)new StringReader(content));
        xmlLoader.getEMFModelConverter().setUriResolver((ObjectResolver)this.getObjectStore());
        return xmlLoader.read();
    }
}

