/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.server.store;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.texo.component.ComponentProvider;
import org.eclipse.emf.texo.component.TexoComponent;
import org.eclipse.emf.texo.component.TexoStaticSingleton;
import org.eclipse.emf.texo.server.store.BaseDao;
import org.eclipse.emf.texo.server.store.GenericModelDao;

public class DaoRegistry
implements TexoComponent,
TexoStaticSingleton {
    private static DaoRegistry instance = (DaoRegistry)ComponentProvider.getInstance().newInstance(DaoRegistry.class);
    private Map<Class<?>, Class<? extends BaseDao<?>>> daoRegistry = new HashMap();

    public static DaoRegistry getInstance() {
        return instance;
    }

    public static void setInstance(DaoRegistry instance) {
        DaoRegistry.instance = instance;
    }

    public void registerDao(Class<?> entityClass, Class<? extends BaseDao<?>> daoClass) {
        this.daoRegistry.put(entityClass, daoClass);
    }

    public <T> BaseDao<T> getDaoForEntity(Class<T> entityClass) {
        Class<? extends BaseDao<?>> daoClass = this.daoRegistry.get(entityClass);
        if (daoClass == null) {
            GenericModelDao genericDao = (GenericModelDao)ComponentProvider.getInstance().newInstance(GenericModelDao.class);
            genericDao.setEntityClass(entityClass);
            return genericDao;
        }
        return (BaseDao)ComponentProvider.getInstance().newInstance(daoClass);
    }

    public <T extends BaseDao<?>> T getDao(Class<T> daoClass) {
        for (Class<BaseDao<T>> clazz : this.daoRegistry.values()) {
            if (!clazz.isAssignableFrom(daoClass)) continue;
            return (T)((BaseDao)ComponentProvider.getInstance().newInstance(clazz));
        }
        return null;
    }
}

