/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.texo.server.store;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.Query;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.metamodel.EmbeddableType;
import javax.persistence.metamodel.EntityType;
import javax.persistence.metamodel.Metamodel;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.texo.model.ModelResolver;
import org.eclipse.emf.texo.server.store.BaseDao;
import org.eclipse.emf.texo.server.store.DaoRegistry;
import org.eclipse.emf.texo.server.store.EntityManagerProvider;
import org.eclipse.emf.texo.store.ObjectStore;

public class EntityManagerObjectStore
extends ObjectStore {
    private static final String COUNT = "count(";
    private static final String FROM = " from ";
    private static final String START_FROM = "from ";
    private static final int FROM_LENGTH = " from ".length();
    private static final int START_FROM_LENGTH = "from ".length();
    private boolean embeddablesDetermined = false;
    private List<Class<?>> embeddables = new ArrayList();
    @PersistenceContext
    private EntityManager entityManager;

    public EntityManager getEntityManager() {
        if (this.entityManager == null) {
            this.entityManager = EntityManagerProvider.getInstance().getEntityManager();
        }
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public Object get(EClass eClass, Object id) {
        Class clz = ModelResolver.getInstance().getImplementationClass((EClassifier)eClass);
        return this.getDao(clz).get(id);
    }

    public <T> T get(Class<T> clz, Object id) {
        return this.getDao(clz).get(id);
    }

    public <T> T update(T object) {
        if (this.isEmbeddable(object)) {
            return object;
        }
        return (T)this.getDao(object.getClass()).update(object);
    }

    public <T> void remove(T object) {
        if (this.isEmbeddable(object)) {
            return;
        }
        this.getDao(object.getClass()).remove(object);
    }

    public <T> void refresh(T object) {
        if (this.isEmbeddable(object)) {
            return;
        }
        this.getDao(object.getClass()).refresh(object);
    }

    public boolean isNew(Object o) {
        if (this.isEmbeddable(o)) {
            return true;
        }
        return super.isNew(o);
    }

    public <T> void insert(T object) {
        if (this.isEmbeddable(object)) {
            return;
        }
        this.getDao(object.getClass()).insert(object);
    }

    public List<?> query(String qryStr, Map<String, Object> namedParameters, int firstResult, int maxResults) {
        Query qry = this.getEntityManager().createQuery(qryStr);
        if (firstResult != -1) {
            qry.setFirstResult(firstResult);
        }
        if (maxResults > 0) {
            qry.setMaxResults(maxResults);
        }
        for (String key : namedParameters.keySet()) {
            qry.setParameter(key, namedParameters.get(key));
        }
        return qry.getResultList();
    }

    public List<?> namedQuery(String name, Map<String, Object> namedParameters, int firstResult, int maxResults) {
        Query qry = this.getEntityManager().createNamedQuery(name);
        if (firstResult != -1) {
            qry.setFirstResult(firstResult);
        }
        if (maxResults != -1) {
            qry.setMaxResults(maxResults);
        }
        for (String key : namedParameters.keySet()) {
            qry.setParameter(key, namedParameters.get(key));
        }
        return qry.getResultList();
    }

    public long count(String qryStr, Map<String, Object> namedParameters) {
        String subQryStr;
        String prefix = "select count(e) from ";
        if (qryStr.toLowerCase().contains(COUNT)) {
            subQryStr = qryStr;
            prefix = "";
        } else if (qryStr.toLowerCase().contains(FROM)) {
            int index = qryStr.toLowerCase().indexOf(FROM);
            subQryStr = qryStr.substring(index + FROM_LENGTH);
        } else {
            subQryStr = qryStr.toLowerCase().startsWith(START_FROM) ? qryStr.substring(START_FROM_LENGTH) : qryStr;
        }
        Query qry = this.getEntityManager().createQuery(String.valueOf(prefix) + subQryStr);
        for (String key : namedParameters.keySet()) {
            qry.setParameter(key, namedParameters.get(key));
        }
        return ((Number)qry.getSingleResult()).longValue();
    }

    public long countNamedQuery(String name, Map<String, Object> namedParameters) {
        Query qry = this.getEntityManager().createNamedQuery(name);
        for (String key : namedParameters.keySet()) {
            qry.setParameter(key, namedParameters.get(key));
        }
        return ((Number)qry.getSingleResult()).longValue();
    }

    public List<?> query(EClass eClass, int firstResult, int maxResults) {
        Class clz = ModelResolver.getInstance().getImplementationClass((EClassifier)eClass);
        CriteriaBuilder queryBuilder = this.getEntityManager().getCriteriaBuilder();
        CriteriaQuery qdef = queryBuilder.createQuery(clz);
        qdef.from(clz);
        TypedQuery query = this.getEntityManager().createQuery(qdef);
        if (firstResult > -1) {
            query.setFirstResult(firstResult);
        }
        if (maxResults > -1) {
            query.setMaxResults(maxResults);
        }
        return query.getResultList();
    }

    public void begin() {
        if (this.getEntityManager().getTransaction().isActive()) {
            return;
        }
        this.getEntityManager().getTransaction().begin();
    }

    public void commit() {
        this.getEntityManager().getTransaction().commit();
    }

    public void flush() {
        this.getEntityManager().flush();
    }

    public void rollback() {
        if (this.getEntityManager().getTransaction() != null && this.getEntityManager().getTransaction().isActive()) {
            this.getEntityManager().getTransaction().rollback();
        }
    }

    public void close() {
        this.getEntityManager().close();
    }

    public Object getDelegate() {
        return this.getEntityManager();
    }

    public <T> List<Object> getReferingObjects(T target, int maxResult, boolean includeContainerReferences) {
        return this.getDao(target.getClass()).getReferingObjects(target, maxResult, includeContainerReferences);
    }

    public <T> boolean isReferenced(T target, boolean includeContainerReferences) {
        return this.getDao(target.getClass()).isReferenced(target, includeContainerReferences);
    }

    public String getEntityName(EClass eClass) {
        Metamodel metaModel = this.getEntityManager().getMetamodel();
        EntityType entityType = metaModel.entity(ModelResolver.getInstance().getImplementationClass((EClassifier)eClass));
        return entityType.getName();
    }

    private <T> BaseDao<T> getDao(Class<T> entityClass) {
        BaseDao<T> dao = DaoRegistry.getInstance().getDaoForEntity(entityClass);
        dao.setEntityManager(this.getEntityManager());
        return dao;
    }

    protected boolean isEmbeddable(Object object) {
        if (!this.embeddablesDetermined) {
            this.determineEmbeddables();
        }
        if (this.embeddables.isEmpty()) {
            return false;
        }
        return this.embeddables.contains(object.getClass());
    }

    protected synchronized void determineEmbeddables() {
        if (this.embeddablesDetermined) {
            return;
        }
        for (EmbeddableType embeddable : this.entityManager.getEntityManagerFactory().getMetamodel().getEmbeddables()) {
            this.embeddables.add(embeddable.getJavaType());
        }
    }
}

