/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.http.jetty.internal;

import java.io.File;
import java.io.IOException;
import java.net.UnknownHostException;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import org.eclipse.equinox.http.servlet.HttpServiceServlet;
import org.mortbay.http.HttpContext;
import org.mortbay.http.HttpHandler;
import org.mortbay.http.HttpListener;
import org.mortbay.http.HttpServer;
import org.mortbay.http.SocketListener;
import org.mortbay.http.SslListener;
import org.mortbay.jetty.servlet.ServletHandler;
import org.mortbay.jetty.servlet.ServletHolder;
import org.osgi.service.cm.ConfigurationException;
import org.osgi.service.cm.ManagedServiceFactory;

public class HttpServerManager
implements ManagedServiceFactory {
    private static final String DIR_PREFIX = "pid_";
    private static final String INTERNAL_CONTEXT_CLASSLOADER = "org.eclipse.equinox.http.jetty.internal.ContextClassLoader";
    static final String HTTP_ENABLED = "http.enabled";
    static final String HTTP_PORT = "http.port";
    static final String HTTP_HOST = "http.host";
    static final String HTTPS_ENABLED = "https.enabled";
    static final String HTTPS_HOST = "https.host";
    static final String HTTPS_PORT = "https.port";
    static final String SSL_KEYSTORE = "ssl.keystore";
    static final String SSL_PASSWORD = "ssl.password";
    static final String SSL_KEYPASSWORD = "ssl.keypassword";
    static final String SSL_NEEDCLIENTAUTH = "ssl.needclientauth";
    static final String SSL_WANTCLIENTAUTH = "ssl.wantclientauth";
    static final String SSL_PROTOCOL = "ssl.protocol";
    static final String SSL_ALGORITHM = "ssl.algorithm";
    static final String SSL_KEYSTORETYPE = "ssl.keystoretype";
    static final String CONTEXT_PATH = "context.path";
    static final String CONTEXT_SESSIONINACTIVEINTERVAL = "context.sessioninactiveinterval";
    static final String OTHER_INFO = "other.info";
    private Map servers = new HashMap();
    private File workDir;
    static /* synthetic */ Class class$0;

    public HttpServerManager(File workDir) {
        this.workDir = workDir;
    }

    public synchronized void deleted(String pid) {
        HttpServer server = (HttpServer)this.servers.remove(pid);
        if (server != null) {
            try {
                server.stop();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            File contextWorkDir = new File(this.workDir, DIR_PREFIX + pid.hashCode());
            HttpServerManager.deleteDirectory(contextWorkDir);
        }
    }

    public String getName() {
        return this.getClass().getName();
    }

    public synchronized void updated(String pid, Dictionary dictionary) throws ConfigurationException {
        String otherInfo;
        SocketListener httpsListener;
        this.deleted(pid);
        HttpServer server = new HttpServer();
        SocketListener httpListener = this.createHttpListener(dictionary);
        if (httpListener != null) {
            server.addListener((HttpListener)httpListener);
        }
        if ((httpsListener = this.createHttpsListener(dictionary)) != null) {
            server.addListener((HttpListener)httpsListener);
        }
        ServletHandler servlets = new ServletHandler();
        servlets.setAutoInitializeServlets(true);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.equinox.http.jetty.internal.HttpServerManager$InternalHttpServiceServlet");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ServletHolder holder = servlets.addServlet("/*", clazz.getName());
        holder.setInitOrder(0);
        holder.setInitParameter("service.vendor", "Eclipse.org");
        holder.setInitParameter("service.description", "Equinox Jetty-based Http Service");
        if (httpListener != null) {
            holder.setInitParameter(HTTP_PORT, new Integer(httpListener.getPort()).toString());
        }
        if (httpsListener != null) {
            holder.setInitParameter(HTTPS_PORT, new Integer(httpsListener.getPort()).toString());
        }
        if ((otherInfo = (String)dictionary.get(OTHER_INFO)) != null) {
            holder.setInitParameter(OTHER_INFO, otherInfo);
        }
        HttpContext httpContext = this.createHttpContext(dictionary);
        httpContext.addHandler((HttpHandler)servlets);
        Integer sessionInactiveInterval = (Integer)dictionary.get(CONTEXT_SESSIONINACTIVEINTERVAL);
        if (sessionInactiveInterval != null) {
            servlets.setSessionInactiveInterval(sessionInactiveInterval.intValue());
        }
        server.addContext(httpContext);
        try {
            server.start();
        }
        catch (Exception e) {
            throw new ConfigurationException(pid, e.getMessage(), (Throwable)e);
        }
        this.servers.put(pid, server);
    }

    public synchronized void shutdown() throws Exception {
        Iterator it = this.servers.values().iterator();
        while (it.hasNext()) {
            HttpServer server = (HttpServer)it.next();
            server.stop();
        }
        this.servers.clear();
    }

    private SocketListener createHttpListener(Dictionary dictionary) {
        Boolean httpEnabled = (Boolean)dictionary.get(HTTP_ENABLED);
        if (httpEnabled != null && !httpEnabled.booleanValue()) {
            return null;
        }
        Integer httpPort = (Integer)dictionary.get(HTTP_PORT);
        if (httpPort == null) {
            return null;
        }
        SocketListener listener = new SocketListener();
        listener.setPort(httpPort.intValue());
        String httpHost = (String)dictionary.get(HTTP_HOST);
        if (httpHost != null) {
            try {
                listener.setHost(httpHost);
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
                return null;
            }
        }
        if (listener.getPort() == 0) {
            try {
                listener.open();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return listener;
    }

    private SocketListener createHttpsListener(Dictionary dictionary) {
        String keystoreType;
        String algorithm;
        String protocol;
        String wantClientAuth;
        String needClientAuth;
        String keyPassword;
        String password;
        String keyStore;
        Boolean httpsEnabled = (Boolean)dictionary.get(HTTPS_ENABLED);
        if (httpsEnabled == null || !httpsEnabled.booleanValue()) {
            return null;
        }
        Integer httpsPort = (Integer)dictionary.get(HTTPS_PORT);
        if (httpsPort == null) {
            return null;
        }
        SslListener listener = new SslListener();
        listener.setPort(httpsPort.intValue());
        String httpsHost = (String)dictionary.get(HTTPS_HOST);
        if (httpsHost != null) {
            try {
                listener.setHost(httpsHost);
            }
            catch (UnknownHostException e) {
                e.printStackTrace();
                return null;
            }
        }
        if ((keyStore = (String)dictionary.get(SSL_KEYSTORE)) != null) {
            listener.setKeystore(keyStore);
        }
        if ((password = (String)dictionary.get(SSL_PASSWORD)) != null) {
            listener.setPassword(password);
        }
        if ((keyPassword = (String)dictionary.get(SSL_KEYPASSWORD)) != null) {
            listener.setKeyPassword(keyPassword);
        }
        if ((needClientAuth = (String)dictionary.get(SSL_NEEDCLIENTAUTH)) != null) {
            listener.setNeedClientAuth(Boolean.valueOf(needClientAuth).booleanValue());
        }
        if ((wantClientAuth = (String)dictionary.get(SSL_WANTCLIENTAUTH)) != null) {
            listener.setWantClientAuth(Boolean.valueOf(wantClientAuth).booleanValue());
        }
        if ((protocol = (String)dictionary.get(SSL_PROTOCOL)) != null) {
            listener.setProtocol(protocol);
        }
        if ((algorithm = (String)dictionary.get(SSL_ALGORITHM)) != null) {
            listener.setAlgorithm(algorithm);
        }
        if ((keystoreType = (String)dictionary.get(SSL_KEYSTORETYPE)) != null) {
            listener.setKeystoreType(keystoreType);
        }
        if (listener.getPort() == 0) {
            try {
                listener.open();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return listener;
    }

    private HttpContext createHttpContext(Dictionary dictionary) {
        HttpContext httpContext = new HttpContext();
        httpContext.setAttribute(INTERNAL_CONTEXT_CLASSLOADER, (Object)Thread.currentThread().getContextClassLoader());
        httpContext.setClassLoader(this.getClass().getClassLoader());
        String contextPathProperty = (String)dictionary.get(CONTEXT_PATH);
        if (contextPathProperty == null) {
            contextPathProperty = "/";
        }
        httpContext.setContextPath(contextPathProperty);
        File contextWorkDir = new File(this.workDir, DIR_PREFIX + dictionary.get("service.pid").hashCode());
        contextWorkDir.mkdir();
        httpContext.setTempDirectory(contextWorkDir);
        return httpContext;
    }

    private static boolean deleteDirectory(File directory) {
        if (directory.exists() && directory.isDirectory()) {
            File[] files = directory.listFiles();
            int i = 0;
            while (i < files.length) {
                if (files[i].isDirectory()) {
                    HttpServerManager.deleteDirectory(files[i]);
                } else {
                    files[i].delete();
                }
                ++i;
            }
        }
        return directory.delete();
    }

    public static class InternalHttpServiceServlet
    implements Servlet {
        private static final long serialVersionUID = 7477982882399972088L;
        private Servlet httpServiceServlet = new HttpServiceServlet();
        private ClassLoader contextLoader;

        public void init(ServletConfig config) throws ServletException {
            ServletContext context = config.getServletContext();
            this.contextLoader = (ClassLoader)context.getAttribute(HttpServerManager.INTERNAL_CONTEXT_CLASSLOADER);
            Thread thread = Thread.currentThread();
            ClassLoader current = thread.getContextClassLoader();
            thread.setContextClassLoader(this.contextLoader);
            try {
                this.httpServiceServlet.init(config);
            }
            finally {
                thread.setContextClassLoader(current);
            }
        }

        public void destroy() {
            Thread thread = Thread.currentThread();
            ClassLoader current = thread.getContextClassLoader();
            thread.setContextClassLoader(this.contextLoader);
            try {
                this.httpServiceServlet.destroy();
            }
            finally {
                thread.setContextClassLoader(current);
            }
            this.contextLoader = null;
        }

        public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
            Thread thread = Thread.currentThread();
            ClassLoader current = thread.getContextClassLoader();
            thread.setContextClassLoader(this.contextLoader);
            try {
                this.httpServiceServlet.service(req, res);
            }
            finally {
                thread.setContextClassLoader(current);
            }
        }

        public ServletConfig getServletConfig() {
            return this.httpServiceServlet.getServletConfig();
        }

        public String getServletInfo() {
            return this.httpServiceServlet.getServletInfo();
        }
    }
}

