/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.launching.environments;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jdt.core.IAccessRule;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.jdt.launching.environments.IAccessRuleParticipant;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.osgi.framework.Bundle;

public class DefaultAccessRuleParticipant
implements IAccessRuleParticipant {
    private static Map fgRules = new HashMap();

    public IAccessRule[][] getAccessRules(IExecutionEnvironment environment, IVMInstall vm, LibraryLocation[] libraries, IJavaProject project) {
        IAccessRule[][] allRules = null;
        allRules = (IAccessRule[][])fgRules.get(environment.getId());
        if (allRules == null || allRules.length != libraries.length) {
            int i;
            String[] packages = this.retrieveSystemPackages(environment.getId());
            IAccessRule[] packageRules = null;
            if (packages.length > 0) {
                packageRules = new IAccessRule[packages.length + 1];
                i = 0;
                while (i < packages.length) {
                    packageRules[i] = JavaCore.newAccessRule((IPath)new Path(packages[i].replace('.', '/')), (int)0);
                    ++i;
                }
                packageRules[packages.length] = JavaCore.newAccessRule((IPath)new Path("**/*"), (int)1);
            } else {
                packageRules = new IAccessRule[]{};
            }
            allRules = new IAccessRule[libraries.length][];
            i = 0;
            while (i < allRules.length) {
                allRules[i] = packageRules;
                ++i;
            }
            fgRules.put(environment.getId(), allRules);
        }
        return allRules;
    }

    private String[] retrieveSystemPackages(String ee) {
        String packages;
        Properties profile = this.getJavaProfileProperties(ee);
        if (profile != null && (packages = profile.getProperty("org.osgi.framework.system.packages")) != null) {
            StringTokenizer tokenizer = new StringTokenizer(packages, ",");
            String[] result = new String[tokenizer.countTokens() + 1];
            result[0] = "java.**";
            int i = 1;
            while (i < result.length) {
                result[i] = String.valueOf(tokenizer.nextToken().trim()) + ".*";
                ++i;
            }
            return result;
        }
        return new String[0];
    }

    /*
     * Loose catch block
     */
    private Properties getJavaProfileProperties(String ee) {
        block19: {
            Bundle osgiBundle = Platform.getBundle((String)"org.eclipse.osgi");
            if (osgiBundle == null) {
                return null;
            }
            URL profileURL = osgiBundle.getEntry(String.valueOf(ee.replace('/', '_')) + ".profile");
            if (profileURL != null) {
                InputStream is;
                block18: {
                    is = null;
                    profileURL = FileLocator.resolve((URL)profileURL);
                    is = profileURL.openStream();
                    if (is == null) break block18;
                    Properties profile = new Properties();
                    profile.load(is);
                    Properties properties = profile;
                    try {
                        if (is != null) {
                            is.close();
                        }
                    }
                    catch (IOException iOException) {}
                    return properties;
                    catch (IOException iOException) {
                        try {}
                        catch (Throwable throwable) {
                            try {
                                if (is != null) {
                                    is.close();
                                }
                            }
                            catch (IOException iOException2) {}
                            throw throwable;
                        }
                        try {
                            if (is != null) {
                                is.close();
                            }
                            break block19;
                        }
                        catch (IOException iOException3) {}
                        break block19;
                    }
                }
                try {
                    if (is != null) {
                        is.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        return null;
    }
}

