/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.compiler.util.JRTUtil;
import org.eclipse.jdt.internal.compiler.util.Util;
import org.eclipse.jdt.internal.core.JarEntryResource;
import org.eclipse.jdt.internal.core.JavaModel;
import org.eclipse.jdt.internal.core.JavaModelManager;
import org.eclipse.jdt.internal.core.JavaModelStatus;

public class JarEntryFile
extends JarEntryResource {
    private static final IJarEntryResource[] NO_CHILDREN = new IJarEntryResource[0];

    public JarEntryFile(String simpleName) {
        super(simpleName);
    }

    @Override
    public JarEntryResource clone(Object newParent) {
        JarEntryFile file = new JarEntryFile(this.simpleName);
        file.setParent(newParent);
        return file;
    }

    public InputStream getContents() throws CoreException {
        IPackageFragmentRoot root = this.getPackageFragmentRoot();
        if (Util.isJrt((String)root.getPath().toOSString())) {
            try {
                IPath rootPath = root.getPath();
                Object target = JavaModel.getTarget(rootPath, false);
                if (target != null && target instanceof File) {
                    return JRTUtil.getContentFromJrt((File)((File)target), (String)this.getEntryName(), (String)root.getElementName());
                }
            }
            catch (IOException e) {
                throw new JavaModelException(e, 985);
            }
            return null;
        }
        ZipFile zipFile = null;
        try {
            String entryName;
            ZipEntry zipEntry;
            zipFile = this.getZipFile();
            if (JavaModelManager.ZIP_ACCESS_VERBOSE) {
                System.out.println("(" + String.valueOf(Thread.currentThread()) + ") [JarEntryFile.getContents()] Creating ZipFile on " + zipFile.getName());
            }
            if ((zipEntry = zipFile.getEntry(entryName = this.getEntryName())) == null) {
                throw new JavaModelException(new JavaModelStatus(979, entryName));
            }
            byte[] contents = Util.getZipEntryByteContent((ZipEntry)zipEntry, (ZipFile)zipFile);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(contents);
            return byteArrayInputStream;
        }
        catch (IOException e) {
            throw new JavaModelException(e, 985);
        }
        finally {
            JavaModelManager.getJavaModelManager().closeZipFile(zipFile);
        }
    }

    @Override
    public IJarEntryResource[] getChildren() {
        return NO_CHILDREN;
    }

    @Override
    public boolean isFile() {
        return true;
    }

    public String toString() {
        return "JarEntryFile[" + this.getEntryName() + "]";
    }
}

