/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.javaeditor;

import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.javaeditor.IJavaAnnotation;
import org.eclipse.jdt.internal.ui.text.correction.JavaCorrectionProcessor;
import org.eclipse.jdt.ui.PreferenceConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.texteditor.IAnnotationImageProvider;

public class JavaAnnotationImageProvider
implements IAnnotationImageProvider {
    private static final int NO_IMAGE = 0;
    private static final int GRAY_IMAGE = 1;
    private static final int OVERLAY_IMAGE = 2;
    private static final int QUICKFIX_WARNING_IMAGE = 3;
    private static final int QUICKFIX_ERROR_IMAGE = 4;
    private static final int QUICKFIX_INFO_IMAGE = 5;
    private static Image fgQuickFixWarningImage;
    private static Image fgQuickFixErrorImage;
    private static Image fgQuickFixInfoImage;
    private boolean fShowQuickFixIcon = PreferenceConstants.getPreferenceStore().getBoolean("JavaEditor.ShowTemporaryProblem");
    private int fCachedImageType;
    private Image fCachedImage;

    public Image getManagedImage(Annotation annotation) {
        if (annotation instanceof IJavaAnnotation) {
            IJavaAnnotation javaAnnotation = (IJavaAnnotation)annotation;
            int imageType = this.getImageType(javaAnnotation);
            return this.getImage(javaAnnotation, imageType);
        }
        return null;
    }

    public String getImageDescriptorId(Annotation annotation) {
        return null;
    }

    public ImageDescriptor getImageDescriptor(String symbolicName) {
        return null;
    }

    private boolean showQuickFix(IJavaAnnotation annotation) {
        return this.fShowQuickFixIcon && annotation.isProblem() && JavaCorrectionProcessor.hasCorrections((Annotation)annotation);
    }

    private Image getQuickFixWarningImage() {
        if (fgQuickFixWarningImage == null) {
            fgQuickFixWarningImage = JavaPluginImages.get("org.eclipse.jdt.ui.quickfix_warning_obj.gif");
        }
        return fgQuickFixWarningImage;
    }

    private Image getQuickFixErrorImage() {
        if (fgQuickFixErrorImage == null) {
            fgQuickFixErrorImage = JavaPluginImages.get("org.eclipse.jdt.ui.quickfix_error_obj.gif");
        }
        return fgQuickFixErrorImage;
    }

    private Image getQuickFixInfoImage() {
        if (fgQuickFixInfoImage == null) {
            fgQuickFixInfoImage = JavaPluginImages.get("org.eclipse.jdt.ui.quickfix_info_obj.gif");
        }
        return fgQuickFixInfoImage;
    }

    private int getImageType(IJavaAnnotation annotation) {
        int imageType = 0;
        if (annotation.hasOverlay()) {
            imageType = 2;
        } else if (!annotation.isMarkedDeleted()) {
            if (this.showQuickFix(annotation)) {
                imageType = "org.eclipse.jdt.ui.error".equals(annotation.getType()) ? 4 : ("org.eclipse.jdt.ui.warning".equals(annotation.getType()) ? 3 : 5);
            }
        } else {
            imageType = 1;
        }
        return imageType;
    }

    private Image getImage(IJavaAnnotation annotation, int imageType) {
        if ((imageType == 3 || imageType == 4 || imageType == 5) && this.fCachedImageType == imageType) {
            return this.fCachedImage;
        }
        Image image = null;
        switch (imageType) {
            case 2: {
                IJavaAnnotation overlay = annotation.getOverlay();
                image = this.getManagedImage((Annotation)overlay);
                this.fCachedImageType = -1;
                break;
            }
            case 3: {
                image = this.getQuickFixWarningImage();
                this.fCachedImageType = imageType;
                this.fCachedImage = image;
                break;
            }
            case 4: {
                image = this.getQuickFixErrorImage();
                this.fCachedImageType = imageType;
                this.fCachedImage = image;
                break;
            }
            case 5: {
                image = this.getQuickFixInfoImage();
                this.fCachedImageType = imageType;
                this.fCachedImage = image;
                break;
            }
            case 1: {
                String annotationType = annotation.getType();
                if ("org.eclipse.jdt.ui.error".equals(annotationType)) {
                    image = JavaPluginImages.get("org.eclipse.jdt.ui.error_alt_obj.gif");
                } else if ("org.eclipse.jdt.ui.warning".equals(annotationType)) {
                    image = JavaPluginImages.get("org.eclipse.jdt.ui.warning_alt_obj.gif");
                } else if ("org.eclipse.jdt.ui.info".equals(annotationType)) {
                    image = JavaPluginImages.get("org.eclipse.jdt.ui.info_alt_obj.gif");
                }
                this.fCachedImageType = -1;
            }
        }
        return image;
    }
}

