/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.wizards;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.IBuffer;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogFieldGroup;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public class NewAnnotationWizardPage
extends NewTypeWizardPage {
    private static final String PAGE_NAME = "NewAnnotationWizardPage";
    private static final int TYPE = 4;
    private static final String SETTINGS_ADD_DOCUMENTED = "add_documented";
    private AddRetentionControl fRetentionSelection;
    private AddTargetControl fTargetSelection;
    private SelectionButtonDialogField fDocumentedSelection;

    public NewAnnotationWizardPage() {
        super(4, PAGE_NAME);
        this.setTitle(NewWizardMessages.NewAnnotationWizardPage_title);
        this.setDescription(NewWizardMessages.NewAnnotationWizardPage_description);
        this.fRetentionSelection = new AddRetentionControl();
        this.fTargetSelection = new AddTargetControl();
        this.fDocumentedSelection = new SelectionButtonDialogField(32);
        this.fDocumentedSelection.setLabelText(NewWizardMessages.NewAnnotationWizardPage_add_documented);
    }

    public void init(IStructuredSelection selection) {
        IJavaElement jelem = this.getInitialJavaElement(selection);
        this.initContainerPage(jelem);
        this.initTypePage(jelem);
        this.initAnnotationPage();
        this.doStatusUpdate();
    }

    private void initAnnotationPage() {
        IDialogSettings dialogSettings = this.getDialogSettings();
        IDialogSettings section = null;
        if (dialogSettings != null) {
            section = dialogSettings.getSection(PAGE_NAME);
        }
        this.restoreSettings(section);
    }

    private void restoreSettings(IDialogSettings section) {
        if (section != null) {
            boolean addDocumented = section.getBoolean(SETTINGS_ADD_DOCUMENTED);
            this.fDocumentedSelection.setSelection(addDocumented);
        }
        this.fRetentionSelection.init(section);
        this.fTargetSelection.init(section);
    }

    @Override
    protected IStatus containerChanged() {
        IStatus status = super.containerChanged();
        if (status.isOK()) {
            IJavaProject javaProject = this.getJavaProject();
            this.fRetentionSelection.setProject(javaProject);
            this.fTargetSelection.setProject(javaProject);
        }
        return status;
    }

    private void doStatusUpdate() {
        IStatus[] status = new IStatus[]{this.fContainerStatus, this.isEnclosingTypeSelected() ? this.fEnclosingTypeStatus : this.fPackageStatus, this.fTypeNameStatus, this.fModifierStatus};
        this.updateStatus(status);
    }

    @Override
    protected void handleFieldChanged(String fieldName) {
        super.handleFieldChanged(fieldName);
        this.doStatusUpdate();
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        this.createEnclosingTypeControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createTypeNameControls(composite, nColumns);
        this.createModifierControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createAddAnnotationControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createCommentControls(composite, nColumns);
        this.enableCommentControl(true);
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.ui.new_annotation_wizard_page_context");
    }

    private void createAddAnnotationControls(Composite composite, int nColumns) {
        this.fRetentionSelection.doFillIntoGrid(composite, nColumns);
        DialogField.createEmptySpace(composite, nColumns);
        this.fTargetSelection.doFillIntoGrid(composite, nColumns);
        DialogField.createEmptySpace(composite, nColumns);
        this.fDocumentedSelection.doFillIntoGrid(composite, nColumns);
    }

    @Override
    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.setFocus();
        }
    }

    @Override
    protected void createTypeMembers(IType newType, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor) throws CoreException {
        String lineDelimiter = StubUtility.getLineDelimiterUsed(newType.getJavaProject());
        this.fTargetSelection.addAnnotation(newType, imports, lineDelimiter);
        this.fRetentionSelection.addAnnotation(newType, imports, lineDelimiter);
        this.addDocumentedAnnotation(newType, imports, lineDelimiter);
        this.persistSettings();
    }

    private void addDocumentedAnnotation(IType newType, NewTypeWizardPage.ImportsManager imports, String lineDelimiter) throws JavaModelException {
        if (this.fDocumentedSelection.isSelected()) {
            String typeName = imports.addImport(Documented.class.getName());
            int start = newType.getSourceRange().getOffset();
            IBuffer buffer = newType.getCompilationUnit().getBuffer();
            buffer.replace(start, 0, "@" + typeName + lineDelimiter);
        }
    }

    private void persistSettings() {
        IDialogSettings dialogSettings = this.getDialogSettings();
        if (dialogSettings != null) {
            IDialogSettings section = dialogSettings.getSection(PAGE_NAME);
            if (section == null) {
                section = dialogSettings.addNewSection(PAGE_NAME);
            }
            section.put(SETTINGS_ADD_DOCUMENTED, this.fDocumentedSelection.isSelected());
            this.fRetentionSelection.persistSettings(section);
            this.fTargetSelection.persistSettings(section);
        }
    }

    private static abstract class AddAnnotationControl<A, E extends Enum<E>> {
        private static final String SETTINGS_ENABLED = "enabled";
        private static final String SETTINGS_SELECTED_ENUMS = "selectedEnums";
        protected final SelectionButtonDialogField fEnableButton;
        protected final SelectionButtonDialogFieldGroup fEnumButtons;
        private final Class<A> fAnnotationClass;
        private final Class<E> fEnumClass;
        private boolean fControlsAreCreated;
        protected IJavaProject fJavaProject;

        public AddAnnotationControl(int style, String enableLabel, Class<A> annotationClass, Class<E> enumClass, int nColumns) {
            this.fAnnotationClass = annotationClass;
            this.fEnumClass = enumClass;
            String[] enumLabels = this.toStringArray(enumClass);
            this.fEnableButton = new SelectionButtonDialogField(32);
            this.fEnableButton.setLabelText(enableLabel);
            this.fEnumButtons = new SelectionButtonDialogFieldGroup(style, enumLabels, nColumns);
            this.fEnableButton.setDialogFieldListener(new IDialogFieldListener(){

                @Override
                public void dialogFieldChanged(DialogField field) {
                    fEnumButtons.setEnabled(fEnableButton.isSelected());
                }
            });
        }

        private String[] toStringArray(Class<E> enumClass) {
            Enum[] enums = (Enum[])enumClass.getEnumConstants();
            String[] strings = new String[enums.length];
            Enum[] enumArray = enums;
            int n = enums.length;
            int n2 = 0;
            while (n2 < n) {
                Enum en = enumArray[n2];
                strings[en.ordinal()] = this.labelFor(en);
                ++n2;
            }
            return strings;
        }

        protected String labelFor(Enum<?> en) {
            String name = en.name();
            String first = name.substring(0, 1).toUpperCase();
            String rest = name.substring(1).toLowerCase().replace('_', ' ');
            return String.valueOf(first) + rest;
        }

        public void init(IDialogSettings settings) {
            IDialogSettings section;
            boolean enabled = false;
            String[] selectedEnums = this.defaultSelectedEnums();
            if (settings != null && (section = settings.getSection(this.dialogSettingsSectionName())) != null) {
                enabled = section.getBoolean(SETTINGS_ENABLED);
                selectedEnums = section.getArray(SETTINGS_SELECTED_ENUMS);
            }
            this.applyInitialSettings(enabled, selectedEnums);
        }

        protected String[] defaultSelectedEnums() {
            return new String[0];
        }

        private void applyInitialSettings(boolean enabled, String[] selectedEnumsAsStrings) {
            this.fEnableButton.setSelection(enabled);
            this.fEnumButtons.setEnabled(enabled);
            this.fEnumButtons.setSelection(0, false);
            String[] stringArray = selectedEnumsAsStrings;
            int n = selectedEnumsAsStrings.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray[n2];
                E en = Enum.valueOf(this.fEnumClass, string);
                this.fEnumButtons.setSelection(((Enum)en).ordinal(), true);
                ++n2;
            }
        }

        protected abstract String dialogSettingsSectionName();

        public void persistSettings(IDialogSettings settings) {
            String sectionName = this.dialogSettingsSectionName();
            IDialogSettings section = settings.getSection(sectionName);
            if (section == null) {
                section = settings.addNewSection(sectionName);
            }
            section.put(SETTINGS_ENABLED, this.isEnabled());
            section.put(SETTINGS_SELECTED_ENUMS, this.selectedEnumsAsStrings());
        }

        private String[] selectedEnumsAsStrings() {
            ArrayList<String> resultList = new ArrayList<String>();
            Enum[] enumArray = this.allEnums();
            int n = enumArray.length;
            int n2 = 0;
            while (n2 < n) {
                Enum en = enumArray[n2];
                if (this.isSelected(en)) {
                    resultList.add(en.name());
                }
                ++n2;
            }
            String[] resultArray = resultList.toArray(new String[0]);
            return resultArray;
        }

        private E[] allEnums() {
            return (Enum[])this.fEnumClass.getEnumConstants();
        }

        public void doFillIntoGrid(Composite parent, int nColumns) {
            Button button = this.fEnableButton.getSelectionButton(parent);
            GridData gdButton = new GridData(2);
            button.setLayoutData((Object)gdButton);
            Composite buttonsGroup = this.fEnumButtons.getSelectionButtonsGroup(parent);
            GridData gdButtonsGroup = new GridData();
            gdButtonsGroup.horizontalSpan = nColumns - 1;
            buttonsGroup.setLayoutData((Object)gdButtonsGroup);
            this.fControlsAreCreated = true;
            this.updateButtons();
        }

        public void setProject(IJavaProject javaProject) {
            this.fJavaProject = javaProject;
            this.updateButtons();
        }

        private void updateButtons() {
            if (this.fControlsAreCreated && this.fJavaProject != null) {
                this.updateAvailableButtons();
            }
        }

        protected void updateAvailableButtons() {
        }

        public boolean isEnabled() {
            return this.fEnableButton.isSelected();
        }

        public void addAnnotation(IType newType, NewTypeWizardPage.ImportsManager imports, String lineDelimiter) throws JavaModelException {
            List<E> selectedEnums;
            if (this.isEnabled() && (selectedEnums = this.availableSelectedEnums()).size() > 0) {
                String annotation = this.createAnnotationAndImports(selectedEnums, imports, lineDelimiter);
                int start = newType.getSourceRange().getOffset();
                IBuffer buffer = newType.getCompilationUnit().getBuffer();
                buffer.replace(start, 0, annotation);
            }
        }

        private List<E> availableSelectedEnums() {
            ArrayList<Enum> resultList = new ArrayList<Enum>();
            Enum[] enumArray = this.allEnums();
            int n = enumArray.length;
            int n2 = 0;
            while (n2 < n) {
                Enum en = enumArray[n2];
                if (this.isEnabled(en) && this.isSelected(en)) {
                    resultList.add(en);
                }
                ++n2;
            }
            return resultList;
        }

        private boolean isEnabled(E en) {
            return this.fEnumButtons.isEnabled(((Enum)en).ordinal());
        }

        private boolean isSelected(E en) {
            return this.fEnumButtons.isSelected(((Enum)en).ordinal());
        }

        private String createAnnotationAndImports(List<E> selectedEnums, NewTypeWizardPage.ImportsManager imports, String lineDelimiter) {
            StringBuffer buffer = new StringBuffer();
            String annotationTypeName = imports.addImport(this.fAnnotationClass.getName());
            buffer.append("@");
            buffer.append(annotationTypeName);
            buffer.append("(");
            if (selectedEnums.size() > 1) {
                buffer.append("{");
            }
            for (Enum en : selectedEnums) {
                String enumTypeName = imports.addStaticImport(en.getClass().getName(), en.name(), true);
                buffer.append(enumTypeName);
                buffer.append(", ");
            }
            buffer.delete(buffer.length() - 2, buffer.length());
            if (selectedEnums.size() > 1) {
                buffer.append("}");
            }
            buffer.append(")");
            buffer.append(lineDelimiter);
            return buffer.toString();
        }
    }

    private static class AddRetentionControl
    extends AddAnnotationControl<Retention, RetentionPolicy> {
        private static final String SETTINGS_SECTION_NAME = "AddRetention";
        private static final String[] MNEMONICS = new String[]{"S", "l", "n"};

        public AddRetentionControl() {
            super(16, NewWizardMessages.NewAnnotationWizardPage_add_retention, Retention.class, RetentionPolicy.class, 3);
        }

        @Override
        protected String labelFor(Enum<?> en) {
            String label = super.labelFor(en);
            String mnemonic = MNEMONICS[en.ordinal()];
            return label.replaceFirst(mnemonic, "&" + mnemonic);
        }

        @Override
        protected String dialogSettingsSectionName() {
            return SETTINGS_SECTION_NAME;
        }

        @Override
        protected String[] defaultSelectedEnums() {
            return new String[]{RetentionPolicy.CLASS.name()};
        }
    }

    private static class AddTargetControl
    extends AddAnnotationControl<Target, ElementType> {
        private static final String SETTINGS_SECTION_NAME = "AddTarget";
        private static final int[] fEnumValuesSinceJava8 = new int[]{8, 9};

        public AddTargetControl() {
            super(32, NewWizardMessages.NewAnnotationWizardPage_add_target, Target.class, ElementType.class, 3);
        }

        @Override
        protected void updateAvailableButtons() {
            boolean isJava8orHigher = JavaModelUtil.is18OrHigher((IJavaProject)this.fJavaProject);
            int[] nArray = fEnumValuesSinceJava8;
            int n = fEnumValuesSinceJava8.length;
            int n2 = 0;
            while (n2 < n) {
                int index = nArray[n2];
                this.fEnumButtons.enableSelectionButton(index, isJava8orHigher);
                ++n2;
            }
        }

        @Override
        protected String dialogSettingsSectionName() {
            return SETTINGS_SECTION_NAME;
        }
    }
}

