/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction.proposals;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IModuleDescription;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.QualifiedTypeNameHistory;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.internal.ui.text.correction.proposals.AddModuleRequiresCorrectionProposal;
import org.eclipse.jdt.ui.text.java.correction.ASTRewriteCorrectionProposal;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IEditorPart;

public class AddImportCorrectionProposal
extends ASTRewriteCorrectionProposal {
    private final String fTypeName;
    private final String fQualifierName;
    protected AddModuleRequiresCorrectionProposal fAdditionalProposal = null;

    public AddImportCorrectionProposal(String name, ICompilationUnit cu, int relevance, Image image, String qualifierName, String typeName, SimpleName node) {
        super(name, cu, ASTRewrite.create((AST)node.getAST()), relevance, image);
        this.fTypeName = typeName;
        this.fQualifierName = qualifierName;
        this.fAdditionalProposal = this.getAdditionalChangeCorrectionProposal();
    }

    public String getQualifiedTypeName() {
        return String.valueOf(this.fQualifierName) + '.' + this.fTypeName;
    }

    public AddModuleRequiresCorrectionProposal getAdditionalProposal() {
        return this.fAdditionalProposal;
    }

    @Override
    protected void performChange(IEditorPart activeEditor, IDocument document) throws CoreException {
        super.performChange(activeEditor, document);
        this.rememberSelection();
    }

    private void rememberSelection() {
        QualifiedTypeNameHistory.remember(this.getQualifiedTypeName());
    }

    private AddModuleRequiresCorrectionProposal getAdditionalChangeCorrectionProposal() {
        ICompilationUnit cu = this.getCompilationUnit();
        AddModuleRequiresCorrectionProposal additionalChangeCorrectionProposal = null;
        IJavaProject currentJavaProject = cu.getJavaProject();
        if (currentJavaProject == null || !JavaModelUtil.is9OrHigher((IJavaProject)currentJavaProject)) {
            return null;
        }
        IModuleDescription currentModuleDescription = null;
        try {
            currentModuleDescription = currentJavaProject.getModuleDescription();
        }
        catch (JavaModelException javaModelException) {}
        if (currentModuleDescription == null) {
            return null;
        }
        ICompilationUnit currentModuleCompilationUnit = currentModuleDescription.getCompilationUnit();
        if (currentModuleCompilationUnit == null || !currentModuleCompilationUnit.exists()) {
            return null;
        }
        String qualifiedName = this.getQualifiedTypeName();
        List<IPackageFragment> packageFragments = AddModuleRequiresCorrectionProposal.getPackageFragmentsOfMatchingTypes(qualifiedName, 0, (IJavaElement)currentJavaProject);
        IPackageFragment enclosingPackage = null;
        if (packageFragments.size() == 1) {
            enclosingPackage = packageFragments.get(0);
        }
        if (enclosingPackage != null) {
            IModuleDescription projectModule = null;
            if (enclosingPackage.isReadOnly()) {
                IPackageFragmentRoot root = (IPackageFragmentRoot)enclosingPackage.getAncestor(3);
                if (root != null) {
                    projectModule = root.getModuleDescription();
                }
            } else {
                IJavaProject project = enclosingPackage.getJavaProject();
                if (project != null && JavaModelUtil.is9OrHigher((IJavaProject)project)) {
                    try {
                        projectModule = project.getModuleDescription();
                    }
                    catch (JavaModelException javaModelException) {}
                }
            }
            if (projectModule != null && projectModule.exists() && !projectModule.equals(currentModuleDescription)) {
                String moduleName = projectModule.getElementName();
                Object[] args = new String[]{moduleName};
                String changeName = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_add_requires_module_info, args);
                String changeDescription = Messages.format(CorrectionMessages.UnresolvedElementsSubProcessor_add_requires_module_description, args);
                additionalChangeCorrectionProposal = new AddModuleRequiresCorrectionProposal(moduleName, changeName, changeDescription, currentModuleCompilationUnit, this.getRelevance());
            }
        }
        return additionalChangeCorrectionProposal;
    }
}

