/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.codemanipulation;

import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.ITypeHierarchy;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationMessages;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.TokenScanner;
import org.eclipse.jdt.internal.corext.util.MethodOverrideTester;
import org.eclipse.jdt.internal.corext.util.Strings;
import org.eclipse.jdt.internal.corext.util.SuperTypeHierarchyCache;
import org.eclipse.jdt.internal.ui.JavaUIStatus;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.TextUtilities;
import org.eclipse.text.edits.InsertEdit;
import org.eclipse.text.edits.MultiTextEdit;
import org.eclipse.text.edits.TextEdit;

public class AddJavaDocStubOperation
implements IWorkspaceRunnable {
    private IMember[] fMembers;

    public AddJavaDocStubOperation(IMember[] members) {
        this.fMembers = members;
    }

    private String createTypeComment(IType type, String lineDelimiter) throws CoreException {
        String[] typeParameterNames = StubUtility.getTypeParameterNames(type.getTypeParameters());
        return CodeGeneration.getTypeComment(type.getCompilationUnit(), type.getTypeQualifiedName('.'), typeParameterNames, lineDelimiter);
    }

    private String createMethodComment(IMethod meth, String lineDelimiter) throws CoreException {
        IType declaringType = meth.getDeclaringType();
        IMethod overridden = null;
        if (!meth.isConstructor()) {
            ITypeHierarchy hierarchy = SuperTypeHierarchyCache.getTypeHierarchy(declaringType);
            MethodOverrideTester tester = new MethodOverrideTester(declaringType, hierarchy);
            overridden = tester.findOverriddenMethod(meth, true);
        }
        return CodeGeneration.getMethodComment(meth, overridden, lineDelimiter);
    }

    private String createFieldComment(IField field, String lineDelimiter) throws JavaModelException, CoreException {
        String typeName = Signature.toString((String)field.getTypeSignature());
        String fieldName = field.getElementName();
        return CodeGeneration.getFieldComment(field.getCompilationUnit(), typeName, fieldName, lineDelimiter);
    }

    public ISchedulingRule getScheduleRule() {
        return ResourcesPlugin.getWorkspace().getRoot();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(IProgressMonitor monitor) throws CoreException, OperationCanceledException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (this.fMembers.length == 0) {
            return;
        }
        try {
            monitor.beginTask(CodeGenerationMessages.AddJavaDocStubOperation_description, this.fMembers.length + 2);
            this.addJavadocComments(monitor);
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            monitor.done();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        monitor.done();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addJavadocComments(IProgressMonitor monitor) throws CoreException {
        ICompilationUnit cu = this.fMembers[0].getCompilationUnit();
        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
        IPath path = cu.getPath();
        manager.connect(path, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        try {
            try {
                IDocument document = manager.getTextFileBuffer(path).getDocument();
                String lineDelim = TextUtilities.getDefaultLineDelimiter((IDocument)document);
                MultiTextEdit edit = new MultiTextEdit();
                int i = 0;
                while (true) {
                    block14: {
                        if (i < this.fMembers.length) break block14;
                        edit.apply(document);
                        break;
                    }
                    IMember curr = this.fMembers[i];
                    int memberStartOffset = this.getMemberStartOffset(curr, document);
                    String comment = null;
                    switch (curr.getElementType()) {
                        case 7: {
                            comment = this.createTypeComment((IType)curr, lineDelim);
                            break;
                        }
                        case 8: {
                            comment = this.createFieldComment((IField)curr, lineDelim);
                            break;
                        }
                        case 9: {
                            comment = this.createMethodComment((IMethod)curr, lineDelim);
                            break;
                        }
                    }
                    if (comment == null) {
                        StringBuffer buf = new StringBuffer();
                        buf.append("/**").append(lineDelim);
                        buf.append(" *").append(lineDelim);
                        buf.append(" */").append(lineDelim);
                        comment = buf.toString();
                    } else if (!comment.endsWith(lineDelim)) {
                        comment = String.valueOf(comment) + lineDelim;
                    }
                    IJavaProject project = cu.getJavaProject();
                    IRegion region = document.getLineInformationOfOffset(memberStartOffset);
                    String line = document.get(region.getOffset(), region.getLength());
                    String indentString = Strings.getIndentString(line, project);
                    String indentedComment = Strings.changeIndent(comment, 0, project, indentString, lineDelim);
                    edit.addChild((TextEdit)new InsertEdit(memberStartOffset, indentedComment));
                    monitor.worked(1);
                    ++i;
                }
            }
            catch (BadLocationException e) {
                throw new CoreException(JavaUIStatus.createError(4, e));
            }
        }
        catch (Throwable throwable) {
            Object var17_19 = null;
            manager.disconnect(path, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            throw throwable;
        }
        {
            Object var17_20 = null;
        }
        manager.disconnect(path, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
    }

    private int getMemberStartOffset(IMember curr, IDocument document) throws JavaModelException {
        int offset = curr.getSourceRange().getOffset();
        TokenScanner scanner = new TokenScanner(document);
        try {
            return scanner.getNextStartOffset(offset, true);
        }
        catch (CoreException coreException) {
            return offset;
        }
    }
}

