/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.FieldDeclaration;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.GenericVisitor;
import org.eclipse.jdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.jdt.internal.corext.dom.VariableDeclarationRewrite;
import org.eclipse.jdt.internal.corext.fix.AbstractFix;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.IFix;
import org.eclipse.jdt.internal.corext.fix.IFixRewriteOperation;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.text.edits.TextEditGroup;

public class VariableDeclarationFix
extends AbstractFix {
    static /* synthetic */ Class class$0;

    public static IFix createChangeModifierToFinalFix(CompilationUnit compilationUnit, ASTNode[] selectedNodes) {
        HashSet writtenNames = new HashSet();
        WrittenNamesFinder finder = new WrittenNamesFinder(writtenNames);
        compilationUnit.accept((ASTVisitor)finder);
        ArrayList ops = new ArrayList();
        VariableDeclarationFinder visitor = new VariableDeclarationFinder(true, true, true, compilationUnit, ops, writtenNames);
        int i = 0;
        while (i < selectedNodes.length) {
            ASTNode selectedNode = selectedNodes[i];
            if (selectedNode instanceof SimpleName) {
                selectedNode = selectedNode.getParent();
            }
            selectedNode.accept((ASTVisitor)visitor);
            ++i;
        }
        if (ops.size() == 0) {
            return null;
        }
        IFixRewriteOperation[] result = ops.toArray(new IFixRewriteOperation[ops.size()]);
        String label = result.length == 1 ? FixMessages.VariableDeclarationFix_changeModifierOfUnknownToFinal_description : FixMessages.VariableDeclarationFix_ChangeMidifiersToFinalWherPossible_description;
        return new VariableDeclarationFix(label, compilationUnit, result);
    }

    public static IFix createCleanUp(CompilationUnit compilationUnit, boolean addFinalFields, boolean addFinalParameters, boolean addFinalLocals) {
        if (!(addFinalFields || addFinalParameters || addFinalLocals)) {
            return null;
        }
        HashSet writtenNames = new HashSet();
        WrittenNamesFinder finder = new WrittenNamesFinder(writtenNames);
        compilationUnit.accept((ASTVisitor)finder);
        ArrayList operations = new ArrayList();
        VariableDeclarationFinder visitor = new VariableDeclarationFinder(addFinalFields, addFinalParameters, addFinalLocals, compilationUnit, operations, writtenNames);
        compilationUnit.accept((ASTVisitor)visitor);
        if (operations.isEmpty()) {
            return null;
        }
        return new VariableDeclarationFix(FixMessages.VariableDeclarationFix_changeModifierOfUnknownToFinal_description, compilationUnit, operations.toArray(new IFixRewriteOperation[operations.size()]));
    }

    private static ModifierChangeOperation createAddFinalOperation(SimpleName name, CompilationUnit compilationUnit, ASTNode decl) {
        if (decl == null) {
            return null;
        }
        IBinding binding = name.resolveBinding();
        if (!VariableDeclarationFix.canAddFinal(binding, name, decl)) {
            return null;
        }
        if (VariableDeclarationFix.isWrittenOutsideInitializer(compilationUnit, (IVariableBinding)binding)) {
            return null;
        }
        if (decl instanceof SingleVariableDeclaration) {
            return new ModifierChangeOperation(decl, new ArrayList(), 16, 0);
        }
        if (decl instanceof VariableDeclarationExpression) {
            return new ModifierChangeOperation(decl, new ArrayList(), 16, 0);
        }
        if (decl instanceof VariableDeclarationFragment) {
            VariableDeclarationFragment frag = (VariableDeclarationFragment)decl;
            if ((decl = decl.getParent()) instanceof FieldDeclaration || decl instanceof VariableDeclarationStatement) {
                ArrayList<VariableDeclarationFragment> list = new ArrayList<VariableDeclarationFragment>();
                list.add(frag);
                return new ModifierChangeOperation(decl, list, 16, 0);
            }
            if (decl instanceof VariableDeclarationExpression) {
                return new ModifierChangeOperation(decl, new ArrayList(), 16, 0);
            }
        }
        return null;
    }

    private static boolean canAddFinal(IBinding binding, SimpleName name, ASTNode declNode) {
        MethodDeclaration declaration;
        ASTNode varDecl;
        ASTNode parent;
        if (!(binding instanceof IVariableBinding)) {
            return false;
        }
        IVariableBinding varbinding = (IVariableBinding)binding;
        if (Modifier.isFinal((int)varbinding.getModifiers())) {
            return false;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.VariableDeclarationExpression");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((parent = ASTNodes.getParent(declNode, clazz)) != null && ((VariableDeclarationExpression)parent).fragments().size() > 1) {
            return false;
        }
        if (varbinding.isField() && !Modifier.isPrivate((int)varbinding.getModifiers())) {
            return false;
        }
        return !varbinding.isParameter() || !((varDecl = declNode.getParent()) instanceof MethodDeclaration) || (declaration = (MethodDeclaration)varDecl).getBody() != null;
    }

    private static boolean isWrittenOutsideInitializer(CompilationUnit compilationUnit, IVariableBinding varbinding) {
        SimpleName[] names = LinkedNodeFinder.findByBinding((ASTNode)compilationUnit, (IBinding)varbinding);
        int i = 0;
        while (i < names.length) {
            SimpleName access = names[i];
            if (!(access.getParent() instanceof VariableDeclarationFragment) && !(access.getParent() instanceof SingleVariableDeclaration) && ASTResolving.isWriteAccess((Name)access)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected VariableDeclarationFix(String name, CompilationUnit compilationUnit, IFixRewriteOperation[] fixRewriteOperations) {
        super(name, compilationUnit, fixRewriteOperations);
    }

    private static class ModifierChangeOperation
    extends AbstractFix.AbstractFixRewriteOperation {
        private final ASTNode fDeclaration;
        private final List fToChange;
        private final int fIncludedModifiers;
        private final int fExcludedModifiers;

        public ModifierChangeOperation(ASTNode declaration, List toChange, int includedModifiers, int excludedModifiers) {
            this.fDeclaration = declaration;
            this.fToChange = toChange;
            this.fIncludedModifiers = includedModifiers;
            this.fExcludedModifiers = excludedModifiers;
        }

        public void rewriteAST(CompilationUnitRewrite cuRewrite, List textEditGroups) throws CoreException {
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            TextEditGroup group = this.createTextEditGroup(FixMessages.VariableDeclarationFix_changeModifierOfUnknownToFinal_description);
            textEditGroups.add(group);
            if (this.fDeclaration instanceof VariableDeclarationStatement) {
                VariableDeclarationFragment[] toChange = this.fToChange.toArray(new VariableDeclarationFragment[this.fToChange.size()]);
                VariableDeclarationRewrite.rewriteModifiers((VariableDeclarationStatement)this.fDeclaration, toChange, this.fIncludedModifiers, this.fExcludedModifiers, rewrite, group);
            } else if (this.fDeclaration instanceof FieldDeclaration) {
                VariableDeclarationFragment[] toChange = this.fToChange.toArray(new VariableDeclarationFragment[this.fToChange.size()]);
                VariableDeclarationRewrite.rewriteModifiers((FieldDeclaration)this.fDeclaration, toChange, this.fIncludedModifiers, this.fExcludedModifiers, rewrite, group);
            } else if (this.fDeclaration instanceof SingleVariableDeclaration) {
                VariableDeclarationRewrite.rewriteModifiers((SingleVariableDeclaration)this.fDeclaration, this.fIncludedModifiers, this.fExcludedModifiers, rewrite, group);
            } else if (this.fDeclaration instanceof VariableDeclarationExpression) {
                VariableDeclarationRewrite.rewriteModifiers((VariableDeclarationExpression)this.fDeclaration, this.fIncludedModifiers, this.fExcludedModifiers, rewrite, group);
            }
        }
    }

    private static class VariableDeclarationFinder
    extends GenericVisitor {
        private final CompilationUnit fCompilationUnit;
        private final List fResult;
        private final HashSet fWrittenVariables;
        private final boolean fAddFinalFields;
        private final boolean fAddFinalParameters;
        private final boolean fAddFinalLocals;

        public VariableDeclarationFinder(boolean addFinalFields, boolean addFinalParameters, boolean addFinalLocals, CompilationUnit compilationUnit, List result, HashSet writtenVariables) {
            this.fAddFinalFields = addFinalFields;
            this.fAddFinalParameters = addFinalParameters;
            this.fAddFinalLocals = addFinalLocals;
            this.fCompilationUnit = compilationUnit;
            this.fResult = result;
            this.fWrittenVariables = writtenVariables;
        }

        public boolean visit(FieldDeclaration node) {
            if (this.fAddFinalFields) {
                return this.handleFragments(node.fragments(), (ASTNode)node);
            }
            return false;
        }

        public boolean visit(VariableDeclarationStatement node) {
            if (this.fAddFinalLocals) {
                return this.handleFragments(node.fragments(), (ASTNode)node);
            }
            return false;
        }

        public boolean visit(VariableDeclarationExpression node) {
            if (this.fAddFinalLocals && node.fragments().size() == 1) {
                ModifierChangeOperation op = VariableDeclarationFix.createAddFinalOperation(((VariableDeclarationFragment)node.fragments().get(0)).getName(), this.fCompilationUnit, (ASTNode)node);
                if (op == null) {
                    return false;
                }
                this.fResult.add(op);
                return false;
            }
            return false;
        }

        private boolean handleFragments(List list, ASTNode declaration) {
            ArrayList<VariableDeclarationFragment> toChange = new ArrayList<VariableDeclarationFragment>();
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                VariableDeclarationFragment fragment = (VariableDeclarationFragment)iter.next();
                SimpleName name = fragment.getName();
                IBinding resolveBinding = name.resolveBinding();
                if (this.fWrittenVariables.contains(resolveBinding) || !VariableDeclarationFix.canAddFinal(resolveBinding, name, declaration)) continue;
                toChange.add(fragment);
            }
            if (toChange.size() == 0) {
                return false;
            }
            ModifierChangeOperation op = new ModifierChangeOperation(declaration, toChange, 16, 0);
            this.fResult.add(op);
            return false;
        }

        public boolean visit(VariableDeclarationFragment node) {
            ModifierChangeOperation op = VariableDeclarationFix.createAddFinalOperation(node.getName(), this.fCompilationUnit, (ASTNode)node);
            if (op == null) {
                return false;
            }
            this.fResult.add(op);
            return false;
        }

        public boolean visit(SingleVariableDeclaration node) {
            if (this.fAddFinalParameters && this.fAddFinalLocals) {
                ModifierChangeOperation op = VariableDeclarationFix.createAddFinalOperation(node.getName(), this.fCompilationUnit, (ASTNode)node);
                if (op == null) {
                    return false;
                }
                this.fResult.add(op);
                return false;
            }
            if (this.fAddFinalParameters) {
                IBinding binding = node.getName().resolveBinding();
                if (!(binding instanceof IVariableBinding)) {
                    return false;
                }
                IVariableBinding varBinding = (IVariableBinding)binding;
                if (!varBinding.isParameter()) {
                    return false;
                }
                ModifierChangeOperation op = VariableDeclarationFix.createAddFinalOperation(node.getName(), this.fCompilationUnit, (ASTNode)node);
                if (op == null) {
                    return false;
                }
                this.fResult.add(op);
                return false;
            }
            if (this.fAddFinalLocals) {
                IBinding binding = node.getName().resolveBinding();
                if (!(binding instanceof IVariableBinding)) {
                    return false;
                }
                IVariableBinding varBinding = (IVariableBinding)binding;
                if (varBinding.isParameter()) {
                    return false;
                }
                ModifierChangeOperation op = VariableDeclarationFix.createAddFinalOperation(node.getName(), this.fCompilationUnit, (ASTNode)node);
                if (op == null) {
                    return false;
                }
                this.fResult.add(op);
                return false;
            }
            return false;
        }
    }

    private static class WrittenNamesFinder
    extends GenericVisitor {
        private final HashSet fResult;

        public WrittenNamesFinder(HashSet result) {
            this.fResult = result;
        }

        public boolean visit(SimpleName node) {
            if (node.getParent() instanceof VariableDeclarationFragment) {
                return super.visit(node);
            }
            if (node.getParent() instanceof SingleVariableDeclaration) {
                return super.visit(node);
            }
            IBinding binding = node.resolveBinding();
            if (!(binding instanceof IVariableBinding)) {
                return super.visit(node);
            }
            if (this.fResult.contains(binding = ((IVariableBinding)binding).getVariableDeclaration())) {
                return super.visit(node);
            }
            if (ASTResolving.isWriteAccess((Name)node)) {
                this.fResult.add(binding);
            }
            return super.visit(node);
        }
    }
}

