/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.reorg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.jdt.internal.corext.refactoring.participants.ResourceProcessors;
import org.eclipse.jdt.internal.corext.refactoring.reorg.INewNameQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgDestinationValidator;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgPolicy;
import org.eclipse.jdt.internal.corext.refactoring.reorg.IReorgQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.MonitoringNewNameQueries;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ParentChecker;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgPolicyFactory;
import org.eclipse.jdt.internal.corext.refactoring.reorg.ReorgUtils;
import org.eclipse.jdt.internal.corext.refactoring.tagging.ICommentProvider;
import org.eclipse.jdt.internal.corext.util.Resources;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.CopyProcessor;
import org.eclipse.ltk.core.refactoring.participants.RefactoringParticipant;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;

public final class JavaCopyProcessor
extends CopyProcessor
implements IReorgDestinationValidator,
ICommentProvider {
    private INewNameQueries fNewNameQueries;
    private IReorgQueries fReorgQueries;
    private IReorgPolicy.ICopyPolicy fCopyPolicy;
    private ReorgExecutionLog fExecutionLog;
    private String fComment;
    static /* synthetic */ Class class$0;

    public static JavaCopyProcessor create(IResource[] resources, IJavaElement[] javaElements) throws JavaModelException {
        IReorgPolicy.ICopyPolicy copyPolicy = ReorgPolicyFactory.createCopyPolicy(resources, javaElements);
        if (!copyPolicy.canEnable()) {
            return null;
        }
        return new JavaCopyProcessor(copyPolicy);
    }

    private JavaCopyProcessor(IReorgPolicy.ICopyPolicy copyPolicy) {
        this.fCopyPolicy = copyPolicy;
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.JavaCopyProcessor_processorName;
    }

    public String getIdentifier() {
        return "org.eclipse.jdt.ui.CopyProcessor";
    }

    public boolean isApplicable() throws CoreException {
        return this.fCopyPolicy.canEnable();
    }

    public void setNewNameQueries(INewNameQueries newNameQueries) {
        Assert.isNotNull((Object)newNameQueries);
        this.fNewNameQueries = newNameQueries;
    }

    public void setReorgQueries(IReorgQueries queries) {
        Assert.isNotNull((Object)queries);
        this.fReorgQueries = queries;
    }

    public IJavaElement[] getJavaElements() {
        return this.fCopyPolicy.getJavaElements();
    }

    public IResource[] getResources() {
        return this.fCopyPolicy.getResources();
    }

    public Object[] getElements() {
        IJavaElement[] jElements = this.fCopyPolicy.getJavaElements();
        IResource[] resources = this.fCopyPolicy.getResources();
        ArrayList<Object> result = new ArrayList<Object>(jElements.length + resources.length);
        result.addAll(Arrays.asList(jElements));
        result.addAll(Arrays.asList(resources));
        return result.toArray();
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        result.merge(RefactoringStatus.create((IStatus)Resources.checkInSync(ReorgUtils.getNotNulls(this.fCopyPolicy.getResources()))));
        IResource[] javaResources = ReorgUtils.getResources(this.fCopyPolicy.getJavaElements());
        result.merge(RefactoringStatus.create((IStatus)Resources.checkInSync(ReorgUtils.getNotNulls(javaResources))));
        return result;
    }

    public Object getCommonParentForInputElements() {
        return new ParentChecker(this.fCopyPolicy.getResources(), this.fCopyPolicy.getJavaElements()).getCommonParent();
    }

    public RefactoringStatus setDestination(IJavaElement destination) throws JavaModelException {
        return this.fCopyPolicy.setDestination(destination);
    }

    public RefactoringStatus setDestination(IResource destination) throws JavaModelException {
        return this.fCopyPolicy.setDestination(destination);
    }

    public boolean canChildrenBeDestinations(IJavaElement javaElement) {
        return this.fCopyPolicy.canChildrenBeDestinations(javaElement);
    }

    public boolean canChildrenBeDestinations(IResource resource) {
        return this.fCopyPolicy.canChildrenBeDestinations(resource);
    }

    public boolean canElementBeDestination(IJavaElement javaElement) {
        return this.fCopyPolicy.canElementBeDestination(javaElement);
    }

    public boolean canElementBeDestination(IResource resource) {
        return this.fCopyPolicy.canElementBeDestination(resource);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        Assert.isNotNull((Object)this.fNewNameQueries, (String)"Missing new name queries");
        Assert.isNotNull((Object)this.fReorgQueries, (String)"Missing reorg queries");
        pm.beginTask("", 2);
        RefactoringStatus result = this.fCopyPolicy.checkFinalConditions((IProgressMonitor)new SubProgressMonitor(pm, 1), context, this.fReorgQueries);
        result.merge(context.check((IProgressMonitor)new SubProgressMonitor(pm, 1)));
        return result;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        DynamicValidationStateChange dynamicValidationStateChange;
        Assert.isNotNull((Object)this.fNewNameQueries);
        Assert.isTrue((this.fCopyPolicy.getJavaElementDestination() == null || this.fCopyPolicy.getResourceDestination() == null ? 1 : 0) != 0);
        Assert.isTrue((this.fCopyPolicy.getJavaElementDestination() != null || this.fCopyPolicy.getResourceDestination() != null ? 1 : 0) != 0);
        try {
            DynamicValidationStateChange result = new DynamicValidationStateChange(this.getChangeName()){

                public Change perform(IProgressMonitor pm2) throws CoreException {
                    try {
                        super.perform(pm2);
                    }
                    catch (OperationCanceledException e) {
                        JavaCopyProcessor.this.fExecutionLog.markAsCanceled();
                        throw e;
                    }
                    return null;
                }

                public Object getAdapter(Class adapter) {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("org.eclipse.ltk.core.refactoring.participants.ReorgExecutionLog");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if (clazz.equals(adapter)) {
                        return JavaCopyProcessor.this.fExecutionLog;
                    }
                    return super.getAdapter(adapter);
                }
            };
            Change change = this.fCopyPolicy.createChange(pm, new MonitoringNewNameQueries(this.fNewNameQueries, this.fExecutionLog));
            if (change instanceof CompositeChange) {
                CompositeChange subComposite = (CompositeChange)change;
                result.merge(subComposite);
            } else {
                result.add(change);
            }
            dynamicValidationStateChange = result;
            Object var5_6 = null;
        }
        catch (Throwable throwable) {
            Object var5_7 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return dynamicValidationStateChange;
    }

    private String getChangeName() {
        return RefactoringCoreMessages.JavaCopyProcessor_changeName;
    }

    public RefactoringParticipant[] loadParticipants(RefactoringStatus status, SharableParticipants sharedParticipants) throws CoreException {
        RefactoringParticipant[] result = this.fCopyPolicy.loadParticipants(status, (RefactoringProcessor)this, this.getAffectedProjectNatures(), sharedParticipants);
        this.fExecutionLog = this.fCopyPolicy.getReorgExecutionLog();
        return result;
    }

    private String[] getAffectedProjectNatures() throws CoreException {
        String[] jNatures = JavaProcessors.computeAffectedNaturs(this.fCopyPolicy.getJavaElements());
        String[] rNatures = ResourceProcessors.computeAffectedNatures(this.fCopyPolicy.getResources());
        HashSet<String> result = new HashSet<String>();
        result.addAll(Arrays.asList(jNatures));
        result.addAll(Arrays.asList(rNatures));
        return result.toArray(new String[result.size()]);
    }

    public boolean canEnableComment() {
        return true;
    }

    public String getComment() {
        return this.fComment;
    }

    public void setComment(String comment) {
        this.fComment = comment;
    }
}

