/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.internal.corext.refactoring.typeconstraints.types.TypeEnvironment;

public abstract class TType {
    public static final int NULL_TYPE = 1;
    public static final int VOID_TYPE = 2;
    public static final int PRIMITIVE_TYPE = 3;
    public static final int ARRAY_TYPE = 4;
    public static final int STANDARD_TYPE = 5;
    public static final int GENERIC_TYPE = 6;
    public static final int PARAMETERIZED_TYPE = 7;
    public static final int RAW_TYPE = 8;
    public static final int UNBOUND_WILDCARD_TYPE = 9;
    public static final int SUPER_WILDCARD_TYPE = 10;
    public static final int EXTENDS_WILDCARD_TYPE = 11;
    public static final int TYPE_VARIABLE = 12;
    public static final int CAPTURE_TYPE = 13;
    protected static final int WILDCARD_TYPE_SHIFT = 3;
    protected static final int ARRAY_TYPE_SHIFT = 5;
    private static final int F_IS_CLASS = 1;
    private static final int F_IS_INTERFACE = 2;
    private static final int F_IS_ENUM = 4;
    private static final int F_IS_ANNOTATION = 8;
    private static final int F_IS_TOP_LEVEL = 16;
    private static final int F_IS_NESTED = 32;
    private static final int F_IS_MEMBER = 64;
    private static final int F_IS_LOCAL = 128;
    private static final int F_IS_ANONYMOUS = 256;
    protected static final TType[] EMPTY_TYPE_ARRAY = new TType[0];
    private TypeEnvironment fEnvironment;
    private String fBindingKey;
    private int fModifiers;
    private int fFlags;

    protected TType(TypeEnvironment environment) {
        this.fEnvironment = environment;
    }

    protected TType(TypeEnvironment environment, String key) {
        this(environment);
        Assert.isNotNull((Object)key);
        this.fBindingKey = key;
    }

    protected void initialize(ITypeBinding binding) {
        this.fBindingKey = binding.getKey();
        Assert.isNotNull((Object)this.fBindingKey);
        this.fModifiers = binding.getModifiers();
        if (binding.isClass()) {
            this.fFlags = 1;
        } else if (binding.isAnnotation()) {
            this.fFlags = 10;
        } else if (binding.isInterface()) {
            this.fFlags = 2;
        } else if (binding.isEnum()) {
            this.fFlags = 4;
        }
        if (binding.isTopLevel()) {
            this.fFlags |= 0x10;
        } else if (binding.isNested()) {
            this.fFlags |= 0x20;
            if (binding.isMember()) {
                this.fFlags |= 0x40;
            } else if (binding.isLocal()) {
                this.fFlags |= 0x80;
            } else if (binding.isAnonymous()) {
                this.fFlags |= 0x100;
            }
        }
    }

    public TypeEnvironment getEnvironment() {
        return this.fEnvironment;
    }

    public String getBindingKey() {
        return this.fBindingKey;
    }

    public int getModifiers() {
        return this.fModifiers;
    }

    public abstract int getKind();

    public boolean isJavaLangObject() {
        return false;
    }

    public boolean isJavaLangCloneable() {
        return false;
    }

    public boolean isJavaIoSerializable() {
        return false;
    }

    public final boolean isNullType() {
        return this.getKind() == 1;
    }

    public final boolean isVoidType() {
        return this.getKind() == 2;
    }

    public final boolean isPrimitiveType() {
        return this.getKind() == 3;
    }

    public final boolean isArrayType() {
        return this.getKind() == 4;
    }

    public final boolean isHierarchyType() {
        int elementType = this.getKind();
        return elementType == 8 || elementType == 7 || elementType == 6 || elementType == 5;
    }

    public final boolean isStandardType() {
        return this.getKind() == 5;
    }

    public final boolean isRawType() {
        return this.getKind() == 8;
    }

    public final boolean isParameterizedType() {
        return this.getKind() == 7;
    }

    public final boolean isGenericType() {
        return this.getKind() == 6;
    }

    public final boolean isTypeVariable() {
        return this.getKind() == 12;
    }

    public final boolean isCaptureType() {
        return this.getKind() == 13;
    }

    public final boolean isWildcardType() {
        int elementType = this.getKind();
        return elementType == 11 || elementType == 9 || elementType == 10;
    }

    public final boolean isUnboundWildcardType() {
        return this.getKind() == 9;
    }

    public final boolean isExtendsWildcardType() {
        return this.getKind() == 11;
    }

    public final boolean isSuperWildcardType() {
        return this.getKind() == 10;
    }

    public final boolean isClass() {
        return (this.fFlags & 1) != 0;
    }

    public final boolean isInterface() {
        return (this.fFlags & 2) != 0;
    }

    public final boolean isEnum() {
        return (this.fFlags & 4) != 0;
    }

    public final boolean isAnnotation() {
        return (this.fFlags & 8) != 0;
    }

    public final boolean isTopLevel() {
        return (this.fFlags & 0x10) != 0;
    }

    public final boolean isNested() {
        return (this.fFlags & 0x20) != 0;
    }

    public final boolean isMember() {
        return (this.fFlags & 0x40) != 0;
    }

    public final boolean isLocal() {
        return (this.fFlags & 0x80) != 0;
    }

    public final boolean isAnonymous() {
        return (this.fFlags & 0x100) != 0;
    }

    public TType getSuperclass() {
        return null;
    }

    public TType[] getInterfaces() {
        return EMPTY_TYPE_ARRAY;
    }

    public boolean isEqualTo(ITypeBinding binding) {
        if (binding == null) {
            return false;
        }
        return binding.getKey().equals(this.fBindingKey);
    }

    public final boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TType)) {
            return false;
        }
        TType otherType = (TType)other;
        TypeEnvironment otherEnvironment = otherType.fEnvironment;
        if (this.fEnvironment.isIdentityTest() && otherEnvironment.isIdentityTest() && this.fEnvironment == otherEnvironment) {
            return false;
        }
        if (this.getKind() != otherType.getKind()) {
            return false;
        }
        return this.doEquals(otherType);
    }

    protected abstract boolean doEquals(TType var1);

    public TType getErasure() {
        return this;
    }

    public TType getTypeDeclaration() {
        return this;
    }

    public TType[] getSubTypes() throws IllegalStateException {
        Map subTypes = this.fEnvironment.getSubTypes();
        if (subTypes == null) {
            throw new IllegalStateException("This TypeEnvironment does not remember subtypes");
        }
        List subtypes = (List)subTypes.get(this);
        if (subtypes == null) {
            return EMPTY_TYPE_ARRAY;
        }
        return subtypes.toArray(new TType[subtypes.size()]);
    }

    public final boolean canAssignTo(TType lhs) {
        if (this.isTypeEquivalentTo(lhs)) {
            return true;
        }
        return this.doCanAssignTo(lhs);
    }

    protected boolean isTypeEquivalentTo(TType other) {
        return this.equals(other);
    }

    protected boolean checkTypeArgument(TType rhs) {
        return this.equals(rhs);
    }

    protected abstract boolean doCanAssignTo(TType var1);

    public abstract String getName();

    public String getPrettySignature() {
        return this.getPlainPrettySignature();
    }

    protected abstract String getPlainPrettySignature();

    public String toString() {
        return this.getPrettySignature();
    }
}

