/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.preferences.formatter;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.preferences.PreferencesAccess;
import org.eclipse.jdt.internal.ui.preferences.formatter.AlreadyExistsDialog;
import org.eclipse.jdt.internal.ui.preferences.formatter.CompilationUnitPreview;
import org.eclipse.jdt.internal.ui.preferences.formatter.CreateProfileDialog;
import org.eclipse.jdt.internal.ui.preferences.formatter.FormatterMessages;
import org.eclipse.jdt.internal.ui.preferences.formatter.ModifyDialog;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileManager;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileStore;
import org.eclipse.jdt.internal.ui.preferences.formatter.ProfileVersioner;
import org.eclipse.jdt.internal.ui.preferences.formatter.RenameProfileDialog;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.util.PixelConverter;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.osgi.service.prefs.BackingStoreException;

public class CodeFormatterConfigurationBlock {
    private static final String DIALOGSTORE_LASTLOADPATH = "org.eclipse.jdt.ui.codeformatter.loadpath";
    private static final String DIALOGSTORE_LASTSAVEPATH = "org.eclipse.jdt.ui.codeformatter.savepath";
    private static final String PREVIEW = "/**\n* " + FormatterMessages.CodingStyleConfigurationBlock_preview_title + "\n*/\n\n" + "package mypackage; import java.util.LinkedList; public class MyIntStack {" + "private final LinkedList fStack;" + "public MyIntStack(){fStack= new LinkedList();}" + "public int pop(){return ((Integer)fStack.removeFirst()).intValue();}" + "public void push(int elem){fStack.addFirst(new Integer(elem));}" + "public boolean isEmpty() {return fStack.isEmpty();}" + "}";
    protected Composite fComposite;
    protected Combo fProfileCombo;
    protected Button fEditButton;
    protected Button fRenameButton;
    protected Button fDeleteButton;
    protected Button fNewButton;
    protected Button fLoadButton;
    protected Button fSaveButton;
    protected final ProfileManager fProfileManager;
    protected CompilationUnitPreview fJavaPreview;
    private PixelConverter fPixConv;
    private IScopeContext fCurrContext;
    private IScopeContext fInstanceScope;

    public CodeFormatterConfigurationBlock(IProject project, PreferencesAccess access) {
        this.fInstanceScope = access.getInstanceScope();
        ArrayList profiles = null;
        try {
            profiles = ProfileStore.readProfiles(this.fInstanceScope);
        }
        catch (CoreException e) {
            JavaPlugin.log(e);
        }
        if (profiles == null) {
            try {
                profiles = ProfileStore.readProfilesFromPreferences((IScopeContext)new DefaultScope());
            }
            catch (CoreException e) {
                JavaPlugin.log(e);
            }
        }
        if (profiles == null) {
            profiles = new ArrayList();
        }
        this.fCurrContext = project != null ? access.getProjectScope(project) : this.fInstanceScope;
        this.fProfileManager = new ProfileManager(profiles, this.fCurrContext, access);
        new StoreUpdater();
    }

    public Composite createContents(Composite parent) {
        this.fPixConv = new PixelConverter((Control)parent);
        this.fComposite = this.createComposite(parent, 5);
        this.fProfileCombo = CodeFormatterConfigurationBlock.createProfileCombo(this.fComposite, 2, this.fPixConv.convertWidthInCharsToPixels(20));
        this.fEditButton = CodeFormatterConfigurationBlock.createButton(this.fComposite, FormatterMessages.CodingStyleConfigurationBlock_edit_button_desc, 32);
        this.fRenameButton = CodeFormatterConfigurationBlock.createButton(this.fComposite, FormatterMessages.CodingStyleConfigurationBlock_rename_button_desc, 32);
        this.fDeleteButton = CodeFormatterConfigurationBlock.createButton(this.fComposite, FormatterMessages.CodingStyleConfigurationBlock_remove_button_desc, 32);
        Composite group = this.createComposite(this.fComposite, 4);
        GridData groupData = new GridData(256);
        groupData.horizontalSpan = 5;
        group.setLayoutData((Object)groupData);
        this.fNewButton = CodeFormatterConfigurationBlock.createButton(group, FormatterMessages.CodingStyleConfigurationBlock_new_button_desc, 32);
        ((GridData)this.createLabel((Composite)group, (String)"", (int)1).getLayoutData()).grabExcessHorizontalSpace = true;
        this.fLoadButton = CodeFormatterConfigurationBlock.createButton(group, FormatterMessages.CodingStyleConfigurationBlock_load_button_desc, 128);
        this.fSaveButton = CodeFormatterConfigurationBlock.createButton(group, FormatterMessages.CodingStyleConfigurationBlock_save_button_desc, 128);
        this.createLabel(this.fComposite, FormatterMessages.CodingStyleConfigurationBlock_preview_label_text, 5);
        this.configurePreview(this.fComposite, 5);
        new ButtonController();
        new ProfileComboController();
        new PreviewController();
        return this.fComposite;
    }

    private static Button createButton(Composite composite, String text, int style) {
        Button button = new Button(composite, 8);
        button.setFont(composite.getFont());
        button.setText(text);
        GridData gd = new GridData(style);
        gd.widthHint = SWTUtil.getButtonWidthHint(button);
        button.setLayoutData((Object)gd);
        return button;
    }

    private static Combo createProfileCombo(Composite composite, int span, int widthHint) {
        GridData gd = new GridData(768);
        gd.horizontalSpan = span;
        gd.widthHint = widthHint;
        Combo combo = new Combo(composite, 12);
        combo.setFont(composite.getFont());
        combo.setLayoutData((Object)gd);
        return combo;
    }

    private Label createLabel(Composite composite, String text, int numColumns) {
        GridData gd = new GridData(256);
        gd.horizontalSpan = numColumns;
        gd.widthHint = 0;
        Label label = new Label(composite, 64);
        label.setFont(composite.getFont());
        label.setText(text);
        label.setLayoutData((Object)gd);
        return label;
    }

    private Composite createComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        GridLayout layout = new GridLayout(numColumns, false);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        return composite;
    }

    private void configurePreview(Composite composite, int numColumns) {
        this.fJavaPreview = new CompilationUnitPreview(this.fProfileManager.getSelected().getSettings(), composite);
        this.fJavaPreview.setPreviewText(PREVIEW);
        GridData gd = new GridData(1296);
        gd.horizontalSpan = numColumns;
        gd.verticalSpan = 7;
        gd.widthHint = 0;
        gd.heightHint = 0;
        this.fJavaPreview.getControl().setLayoutData((Object)gd);
    }

    public final boolean hasProjectSpecificOptions(IProject project) {
        if (project != null) {
            return ProfileManager.hasProjectSpecificSettings((IScopeContext)new ProjectScope(project));
        }
        return false;
    }

    public boolean performOk() {
        return true;
    }

    public void performApply() {
        try {
            this.fCurrContext.getNode("org.eclipse.jdt.ui").flush();
            this.fCurrContext.getNode("org.eclipse.jdt.core").flush();
            if (this.fCurrContext != this.fInstanceScope) {
                this.fInstanceScope.getNode("org.eclipse.jdt.ui").flush();
                this.fInstanceScope.getNode("org.eclipse.jdt.core").flush();
            }
        }
        catch (BackingStoreException e) {
            JavaPlugin.log(e);
        }
    }

    public void performDefaults() {
        int defaultIndex;
        ProfileManager.Profile profile = this.fProfileManager.getProfile("org.eclipse.jdt.ui.default.eclipse_profile");
        if (profile != null && (defaultIndex = this.fProfileManager.getSortedProfiles().indexOf(profile)) != -1) {
            this.fProfileManager.setSelected(profile);
        }
    }

    public void dispose() {
    }

    public void enableProjectSpecificSettings(boolean useProjectSpecificSettings) {
        if (useProjectSpecificSettings) {
            this.fProfileManager.commitChanges(this.fCurrContext);
        } else {
            this.fProfileManager.clearAllSettings(this.fCurrContext);
        }
    }

    private class ButtonController
    implements Observer,
    SelectionListener {
        public ButtonController() {
            CodeFormatterConfigurationBlock.this.fProfileManager.addObserver(this);
            CodeFormatterConfigurationBlock.this.fNewButton.addSelectionListener((SelectionListener)this);
            CodeFormatterConfigurationBlock.this.fRenameButton.addSelectionListener((SelectionListener)this);
            CodeFormatterConfigurationBlock.this.fEditButton.addSelectionListener((SelectionListener)this);
            CodeFormatterConfigurationBlock.this.fDeleteButton.addSelectionListener((SelectionListener)this);
            CodeFormatterConfigurationBlock.this.fSaveButton.addSelectionListener((SelectionListener)this);
            CodeFormatterConfigurationBlock.this.fLoadButton.addSelectionListener((SelectionListener)this);
            this.update(CodeFormatterConfigurationBlock.this.fProfileManager, null);
        }

        public void update(Observable o, Object arg) {
            ProfileManager.Profile selected = ((ProfileManager)o).getSelected();
            boolean notBuiltIn = !selected.isBuiltInProfile();
            CodeFormatterConfigurationBlock.this.fEditButton.setText(notBuiltIn ? FormatterMessages.CodingStyleConfigurationBlock_edit_button_desc : FormatterMessages.CodingStyleConfigurationBlock_show_button_desc);
            CodeFormatterConfigurationBlock.this.fDeleteButton.setEnabled(notBuiltIn);
            CodeFormatterConfigurationBlock.this.fSaveButton.setEnabled(notBuiltIn);
            CodeFormatterConfigurationBlock.this.fRenameButton.setEnabled(notBuiltIn);
        }

        public void widgetSelected(SelectionEvent e) {
            Button button = (Button)e.widget;
            if (button == CodeFormatterConfigurationBlock.this.fSaveButton) {
                this.saveButtonPressed();
            } else if (button == CodeFormatterConfigurationBlock.this.fEditButton) {
                this.modifyButtonPressed();
            } else if (button == CodeFormatterConfigurationBlock.this.fDeleteButton) {
                this.deleteButtonPressed();
            } else if (button == CodeFormatterConfigurationBlock.this.fNewButton) {
                this.newButtonPressed();
            } else if (button == CodeFormatterConfigurationBlock.this.fLoadButton) {
                this.loadButtonPressed();
            } else if (button == CodeFormatterConfigurationBlock.this.fRenameButton) {
                this.renameButtonPressed();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        private void renameButtonPressed() {
            if (CodeFormatterConfigurationBlock.this.fProfileManager.getSelected().isBuiltInProfile()) {
                return;
            }
            ProfileManager.CustomProfile profile = (ProfileManager.CustomProfile)CodeFormatterConfigurationBlock.this.fProfileManager.getSelected();
            RenameProfileDialog renameDialog = new RenameProfileDialog(CodeFormatterConfigurationBlock.this.fComposite.getShell(), profile, CodeFormatterConfigurationBlock.this.fProfileManager);
            if (renameDialog.open() == 0) {
                CodeFormatterConfigurationBlock.this.fProfileManager.setSelected(renameDialog.getRenamedProfile());
            }
        }

        private void modifyButtonPressed() {
            ModifyDialog modifyDialog = new ModifyDialog(CodeFormatterConfigurationBlock.this.fComposite.getShell(), CodeFormatterConfigurationBlock.this.fProfileManager.getSelected(), CodeFormatterConfigurationBlock.this.fProfileManager, false);
            modifyDialog.open();
        }

        private void deleteButtonPressed() {
            if (MessageDialog.openQuestion((Shell)CodeFormatterConfigurationBlock.this.fComposite.getShell(), (String)FormatterMessages.CodingStyleConfigurationBlock_delete_confirmation_title, (String)Messages.format(FormatterMessages.CodingStyleConfigurationBlock_delete_confirmation_question, CodeFormatterConfigurationBlock.this.fProfileManager.getSelected().getName()))) {
                CodeFormatterConfigurationBlock.this.fProfileManager.deleteSelected();
            }
        }

        private void newButtonPressed() {
            CreateProfileDialog p = new CreateProfileDialog(CodeFormatterConfigurationBlock.this.fComposite.getShell(), CodeFormatterConfigurationBlock.this.fProfileManager);
            if (p.open() != 0) {
                return;
            }
            if (!p.openEditDialog()) {
                return;
            }
            ModifyDialog modifyDialog = new ModifyDialog(CodeFormatterConfigurationBlock.this.fComposite.getShell(), p.getCreatedProfile(), CodeFormatterConfigurationBlock.this.fProfileManager, true);
            modifyDialog.open();
        }

        private void saveButtonPressed() {
            String path;
            ProfileManager.Profile selected = CodeFormatterConfigurationBlock.this.fProfileManager.getSelected();
            if (selected.isSharedProfile()) {
                RenameProfileDialog renameDialog = new RenameProfileDialog(CodeFormatterConfigurationBlock.this.fComposite.getShell(), selected, CodeFormatterConfigurationBlock.this.fProfileManager);
                if (renameDialog.open() != 0) {
                    return;
                }
                selected = renameDialog.getRenamedProfile();
                CodeFormatterConfigurationBlock.this.fProfileManager.setSelected(selected);
            }
            FileDialog dialog = new FileDialog(CodeFormatterConfigurationBlock.this.fComposite.getShell(), 8192);
            dialog.setText(FormatterMessages.CodingStyleConfigurationBlock_save_profile_dialog_title);
            dialog.setFilterExtensions(new String[]{"*.xml"});
            String lastPath = JavaPlugin.getDefault().getDialogSettings().get(CodeFormatterConfigurationBlock.DIALOGSTORE_LASTSAVEPATH);
            if (lastPath != null) {
                dialog.setFilterPath(lastPath);
            }
            if ((path = dialog.open()) == null) {
                return;
            }
            JavaPlugin.getDefault().getDialogSettings().put(CodeFormatterConfigurationBlock.DIALOGSTORE_LASTSAVEPATH, dialog.getFilterPath());
            File file = new File(path);
            if (file.exists() && !MessageDialog.openQuestion((Shell)CodeFormatterConfigurationBlock.this.fComposite.getShell(), (String)FormatterMessages.CodingStyleConfigurationBlock_save_profile_overwrite_title, (String)Messages.format(FormatterMessages.CodingStyleConfigurationBlock_save_profile_overwrite_message, path))) {
                return;
            }
            ArrayList<ProfileManager.Profile> profiles = new ArrayList<ProfileManager.Profile>();
            profiles.add(selected);
            try {
                ProfileStore.writeProfilesToFile(profiles, file);
            }
            catch (CoreException e) {
                String title = FormatterMessages.CodingStyleConfigurationBlock_save_profile_error_title;
                String message = FormatterMessages.CodingStyleConfigurationBlock_save_profile_error_message;
                ExceptionHandler.handle(e, CodeFormatterConfigurationBlock.this.fComposite.getShell(), title, message);
            }
        }

        private void loadButtonPressed() {
            AlreadyExistsDialog aeDialog;
            String message;
            String title;
            String path;
            FileDialog dialog = new FileDialog(CodeFormatterConfigurationBlock.this.fComposite.getShell(), 4096);
            dialog.setText(FormatterMessages.CodingStyleConfigurationBlock_load_profile_dialog_title);
            dialog.setFilterExtensions(new String[]{"*.xml"});
            String lastPath = JavaPlugin.getDefault().getDialogSettings().get(CodeFormatterConfigurationBlock.DIALOGSTORE_LASTLOADPATH);
            if (lastPath != null) {
                dialog.setFilterPath(lastPath);
            }
            if ((path = dialog.open()) == null) {
                return;
            }
            JavaPlugin.getDefault().getDialogSettings().put(CodeFormatterConfigurationBlock.DIALOGSTORE_LASTLOADPATH, dialog.getFilterPath());
            File file = new File(path);
            List profiles = null;
            try {
                profiles = ProfileStore.readProfilesFromFile(file);
            }
            catch (CoreException e) {
                title = FormatterMessages.CodingStyleConfigurationBlock_load_profile_error_title;
                message = FormatterMessages.CodingStyleConfigurationBlock_load_profile_error_message;
                ExceptionHandler.handle(e, CodeFormatterConfigurationBlock.this.fComposite.getShell(), title, message);
            }
            if (profiles == null || profiles.isEmpty()) {
                return;
            }
            ProfileManager.CustomProfile profile = (ProfileManager.CustomProfile)profiles.iterator().next();
            if (ProfileVersioner.getVersionStatus(profile) > 0) {
                title = FormatterMessages.CodingStyleConfigurationBlock_load_profile_error_too_new_title;
                message = FormatterMessages.CodingStyleConfigurationBlock_load_profile_error_too_new_message;
                MessageDialog.openWarning((Shell)CodeFormatterConfigurationBlock.this.fComposite.getShell(), (String)title, (String)message);
            }
            if (CodeFormatterConfigurationBlock.this.fProfileManager.containsName(profile.getName()) && (aeDialog = new AlreadyExistsDialog(CodeFormatterConfigurationBlock.this.fComposite.getShell(), profile, CodeFormatterConfigurationBlock.this.fProfileManager)).open() != 0) {
                return;
            }
            ProfileVersioner.updateAndComplete(profile);
            CodeFormatterConfigurationBlock.this.fProfileManager.addProfile(profile);
        }
    }

    private class PreviewController
    implements Observer {
        public PreviewController() {
            CodeFormatterConfigurationBlock.this.fProfileManager.addObserver(this);
            CodeFormatterConfigurationBlock.this.fJavaPreview.setWorkingValues(CodeFormatterConfigurationBlock.this.fProfileManager.getSelected().getSettings());
            CodeFormatterConfigurationBlock.this.fJavaPreview.update();
        }

        public void update(Observable o, Object arg) {
            int value = (Integer)arg;
            switch (value) {
                case 1: 
                case 2: 
                case 4: 
                case 5: {
                    CodeFormatterConfigurationBlock.this.fJavaPreview.setWorkingValues(((ProfileManager)o).getSelected().getSettings());
                    CodeFormatterConfigurationBlock.this.fJavaPreview.update();
                }
            }
        }
    }

    private class ProfileComboController
    implements Observer,
    SelectionListener {
        private final List fSortedProfiles;

        public ProfileComboController() {
            this.fSortedProfiles = CodeFormatterConfigurationBlock.this.fProfileManager.getSortedProfiles();
            CodeFormatterConfigurationBlock.this.fProfileCombo.addSelectionListener((SelectionListener)this);
            CodeFormatterConfigurationBlock.this.fProfileManager.addObserver(this);
            this.updateProfiles();
            this.updateSelection();
        }

        public void widgetSelected(SelectionEvent e) {
            int index = CodeFormatterConfigurationBlock.this.fProfileCombo.getSelectionIndex();
            CodeFormatterConfigurationBlock.this.fProfileManager.setSelected((ProfileManager.Profile)this.fSortedProfiles.get(index));
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        public void update(Observable o, Object arg) {
            if (arg == null) {
                return;
            }
            int value = (Integer)arg;
            switch (value) {
                case 2: 
                case 3: 
                case 4: {
                    this.updateProfiles();
                    this.updateSelection();
                    break;
                }
                case 1: {
                    this.updateSelection();
                }
            }
        }

        private void updateProfiles() {
            CodeFormatterConfigurationBlock.this.fProfileCombo.setItems(CodeFormatterConfigurationBlock.this.fProfileManager.getSortedDisplayNames());
        }

        private void updateSelection() {
            CodeFormatterConfigurationBlock.this.fProfileCombo.setText(CodeFormatterConfigurationBlock.this.fProfileManager.getSelected().getName());
        }
    }

    private class StoreUpdater
    implements Observer {
        public StoreUpdater() {
            CodeFormatterConfigurationBlock.this.fProfileManager.addObserver(this);
        }

        public void update(Observable o, Object arg) {
            int value = (Integer)arg;
            switch (value) {
                case 2: 
                case 3: 
                case 4: 
                case 5: {
                    try {
                        ProfileStore.writeProfiles(CodeFormatterConfigurationBlock.this.fProfileManager.getSortedProfiles(), CodeFormatterConfigurationBlock.this.fInstanceScope);
                        CodeFormatterConfigurationBlock.this.fProfileManager.commitChanges(CodeFormatterConfigurationBlock.this.fCurrContext);
                    }
                    catch (CoreException x) {
                        JavaPlugin.log(x);
                    }
                    break;
                }
                case 1: {
                    CodeFormatterConfigurationBlock.this.fProfileManager.commitChanges(CodeFormatterConfigurationBlock.this.fCurrContext);
                }
            }
        }
    }
}

