/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.nls;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.JavaElementSorter;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;

public class SourceContainerDialog
extends ElementTreeSelectionDialog {
    private SourceContainerDialog(Shell shell) {
        super(shell, (ILabelProvider)new JavaElementLabelProvider(JavaElementLabelProvider.SHOW_DEFAULT), (ITreeContentProvider)new StandardJavaElementContentProvider());
        this.setValidator(new PackageAndProjectSelectionValidator(this));
        this.setSorter(new JavaElementSorter());
        this.setTitle(NewWizardMessages.NewContainerWizardPage_ChooseSourceContainerDialog_title);
        this.setMessage(NewWizardMessages.NewContainerWizardPage_ChooseSourceContainerDialog_description);
        this.addFilter(new JavaTypedViewerFilter(this));
    }

    public static IPackageFragmentRoot getSourceContainer(Shell shell, IWorkspaceRoot workspaceRoot, IJavaElement initElement) {
        SourceContainerDialog dialog = new SourceContainerDialog(shell);
        dialog.setInput(JavaCore.create((IWorkspaceRoot)workspaceRoot));
        dialog.setInitialSelection(initElement);
        if (dialog.open() == 0) {
            Object element = dialog.getFirstResult();
            if (element instanceof IJavaProject) {
                IJavaProject jproject = (IJavaProject)element;
                return jproject.getPackageFragmentRoot((IResource)jproject.getProject());
            }
            if (element instanceof IPackageFragmentRoot) {
                return (IPackageFragmentRoot)element;
            }
            return null;
        }
        return null;
    }

    private class JavaTypedViewerFilter
    extends TypedViewerFilter {
        final /* synthetic */ SourceContainerDialog this$0;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;

        public JavaTypedViewerFilter(SourceContainerDialog sourceContainerDialog) {
            Class[] classArray = new Class[2];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jdt.core.IPackageFragmentRoot");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            Class<?> clazz2 = class$1;
            if (clazz2 == null) {
                try {
                    clazz2 = class$1 = Class.forName("org.eclipse.jdt.core.IJavaProject");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[1] = clazz2;
            super(classArray);
            this.this$0 = sourceContainerDialog;
        }

        public boolean select(Viewer viewer, Object parent, Object element) {
            if (element instanceof IPackageFragmentRoot) {
                IPackageFragmentRoot fragmentRoot = (IPackageFragmentRoot)element;
                try {
                    return fragmentRoot.getKind() == 1;
                }
                catch (JavaModelException javaModelException) {
                    return false;
                }
            }
            return super.select(viewer, parent, element);
        }
    }

    private class PackageAndProjectSelectionValidator
    extends TypedElementSelectionValidator {
        final /* synthetic */ SourceContainerDialog this$0;
        static /* synthetic */ Class class$0;

        public PackageAndProjectSelectionValidator(SourceContainerDialog sourceContainerDialog) {
            Class[] classArray = new Class[1];
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.jdt.core.IPackageFragmentRoot");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            super(classArray, false);
            this.this$0 = sourceContainerDialog;
        }

        public boolean isSelectedValid(Object element) {
            try {
                if (element instanceof IJavaProject) {
                    IJavaProject jproject = (IJavaProject)element;
                    IPath path = jproject.getProject().getFullPath();
                    return jproject.findPackageFragmentRoot(path) != null;
                }
                if (element instanceof IPackageFragmentRoot) {
                    return ((IPackageFragmentRoot)element).getKind() == 1;
                }
                return true;
            }
            catch (JavaModelException javaModelException) {
                return false;
            }
        }
    }
}

