/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.search;

import java.text.Collator;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.dnd.JdtViewerDragAdapter;
import org.eclipse.jdt.internal.ui.dnd.ResourceTransferDragAdapter;
import org.eclipse.jdt.internal.ui.packageview.SelectionTransferDragAdapter;
import org.eclipse.jdt.internal.ui.search.ColorDecoratingLabelProvider;
import org.eclipse.jdt.internal.ui.search.FilterAction;
import org.eclipse.jdt.internal.ui.search.FiltersDialogAction;
import org.eclipse.jdt.internal.ui.search.GroupAction;
import org.eclipse.jdt.internal.ui.search.JavaSearchContentProvider;
import org.eclipse.jdt.internal.ui.search.JavaSearchEditorOpener;
import org.eclipse.jdt.internal.ui.search.JavaSearchQuery;
import org.eclipse.jdt.internal.ui.search.JavaSearchResult;
import org.eclipse.jdt.internal.ui.search.JavaSearchTableContentProvider;
import org.eclipse.jdt.internal.ui.search.LevelTreeContentProvider;
import org.eclipse.jdt.internal.ui.search.MatchFilter;
import org.eclipse.jdt.internal.ui.search.NewSearchViewActionGroup;
import org.eclipse.jdt.internal.ui.search.PostfixLabelProvider;
import org.eclipse.jdt.internal.ui.search.SearchMessages;
import org.eclipse.jdt.internal.ui.search.SortAction;
import org.eclipse.jdt.internal.ui.search.SortingLabelProvider;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.viewsupport.ProblemTableViewer;
import org.eclipse.jdt.internal.ui.viewsupport.ProblemTreeViewer;
import org.eclipse.jdt.ui.search.IMatchPresentation;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.util.TransferDragSourceListener;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.search.ui.SearchResultEvent;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.dialogs.PreferencesUtil;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.part.ResourceTransfer;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.ui.views.navigator.LocalSelectionTransfer;

public class JavaSearchResultPage
extends AbstractTextSearchViewPage
implements IAdaptable {
    private static final int DEFAULT_ELEMENT_LIMIT = 1000;
    private static final String FALSE = "FALSE";
    private static final String TRUE = "TRUE";
    private static final String KEY_GROUPING = "org.eclipse.jdt.search.resultpage.grouping";
    private static final String KEY_SORTING = "org.eclipse.jdt.search.resultpage.sorting";
    private static final String KEY_LIMIT_ENABLED = "org.eclipse.jdt.search.resultpage.limit_enabled";
    private static final String KEY_LIMIT = "org.eclipse.jdt.search.resultpage.limit";
    private static final String GROUP_GROUPING = "org.eclipse.jdt.search.resultpage.grouping";
    private static final String GROUP_FILTERING = "org.eclipse.jdt.search.resultpage.filtering";
    private NewSearchViewActionGroup fActionGroup;
    private JavaSearchContentProvider fContentProvider;
    private int fCurrentSortOrder;
    private SortAction fSortByNameAction;
    private SortAction fSortByParentName;
    private SortAction fSortByPathAction;
    private GroupAction fGroupTypeAction;
    private GroupAction fGroupFileAction;
    private GroupAction fGroupPackageAction;
    private GroupAction fGroupProjectAction;
    private int fCurrentGrouping;
    private FilterAction[] fFilterActions;
    private FiltersDialogAction fFilterDialogAction;
    private static final String[] SHOW_IN_TARGETS = new String[]{"org.eclipse.jdt.ui.PackageExplorer", "org.eclipse.ui.views.ResourceNavigator"};
    public static final IShowInTargetList SHOW_IN_TARGET_LIST = new IShowInTargetList(){

        public String[] getShowInTargetIds() {
            return SHOW_IN_TARGETS;
        }
    };
    private JavaSearchEditorOpener fEditorOpener = new JavaSearchEditorOpener();
    private boolean fLimitElements = false;
    private int fElementLimit;
    static /* synthetic */ Class class$0;

    public JavaSearchResultPage() {
        this.initSortActions();
        this.initGroupingActions();
        this.initFilterActions();
    }

    private void initFilterActions() {
        MatchFilter[] allFilters = MatchFilter.allFilters();
        this.fFilterActions = new FilterAction[allFilters.length];
        int i = 0;
        while (i < this.fFilterActions.length) {
            this.fFilterActions[i] = new FilterAction(this, allFilters[i]);
            this.fFilterActions[i].setId("org.eclipse.jdt.search.filters." + i);
            ++i;
        }
        this.fFilterDialogAction = new FiltersDialogAction(this);
        this.fFilterDialogAction.setId("org.eclipse.jdt.search.filters." + allFilters.length);
        JavaPluginImages.setLocalImageDescriptors((IAction)this.fFilterDialogAction, "filter_ps.gif");
    }

    private void initSortActions() {
        this.fSortByNameAction = new SortAction(SearchMessages.JavaSearchResultPage_sortByName, this, 1);
        this.fSortByPathAction = new SortAction(SearchMessages.JavaSearchResultPage_sortByPath, this, 3);
        this.fSortByParentName = new SortAction(SearchMessages.JavaSearchResultPage_sortByParentName, this, 2);
    }

    private void initGroupingActions() {
        this.fGroupProjectAction = new GroupAction(SearchMessages.JavaSearchResultPage_groupby_project, SearchMessages.JavaSearchResultPage_groupby_project_tooltip, this, 4);
        JavaPluginImages.setLocalImageDescriptors((IAction)this.fGroupProjectAction, "prj_mode.gif");
        this.fGroupPackageAction = new GroupAction(SearchMessages.JavaSearchResultPage_groupby_package, SearchMessages.JavaSearchResultPage_groupby_package_tooltip, this, 3);
        JavaPluginImages.setLocalImageDescriptors((IAction)this.fGroupPackageAction, "package_mode.gif");
        this.fGroupFileAction = new GroupAction(SearchMessages.JavaSearchResultPage_groupby_file, SearchMessages.JavaSearchResultPage_groupby_file_tooltip, this, 2);
        JavaPluginImages.setLocalImageDescriptors((IAction)this.fGroupFileAction, "file_mode.gif");
        this.fGroupTypeAction = new GroupAction(SearchMessages.JavaSearchResultPage_groupby_type, SearchMessages.JavaSearchResultPage_groupby_type_tooltip, this, 1);
        JavaPluginImages.setLocalImageDescriptors((IAction)this.fGroupTypeAction, "type_mode.gif");
    }

    public void setViewPart(ISearchResultViewPart part) {
        super.setViewPart(part);
        this.fActionGroup = new NewSearchViewActionGroup((IViewPart)part);
    }

    public void showMatch(Match match, int offset, int length, boolean activate) throws PartInitException {
        IEditorPart editor;
        try {
            editor = this.fEditorOpener.openMatch(match);
        }
        catch (JavaModelException e) {
            throw new PartInitException(e.getStatus());
        }
        if (editor != null && activate) {
            editor.getEditorSite().getPage().activate((IWorkbenchPart)editor);
        }
        Object element = match.getElement();
        if (editor instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)editor;
            textEditor.selectAndReveal(offset, length);
        } else if (editor != null) {
            if (element instanceof IFile) {
                IFile file = (IFile)element;
                this.showWithMarker(editor, file, offset, length);
            }
        } else {
            JavaSearchResult result = (JavaSearchResult)this.getInput();
            IMatchPresentation participant = result.getSearchParticpant(element);
            if (participant != null) {
                participant.showMatch(match, offset, length, activate);
            }
        }
    }

    private void showWithMarker(IEditorPart editor, IFile file, int offset, int length) throws PartInitException {
        try {
            IMarker marker = file.createMarker("org.eclipse.search.searchmarker");
            HashMap<String, Integer> attributes = new HashMap<String, Integer>(4);
            attributes.put("charStart", new Integer(offset));
            attributes.put("charEnd", new Integer(offset + length));
            marker.setAttributes(attributes);
            IDE.gotoMarker((IEditorPart)editor, (IMarker)marker);
            marker.delete();
        }
        catch (CoreException e) {
            throw new PartInitException(SearchMessages.JavaSearchResultPage_error_marker, (Throwable)e);
        }
    }

    protected void fillContextMenu(IMenuManager mgr) {
        super.fillContextMenu(mgr);
        this.addSortActions(mgr);
        this.fActionGroup.setContext(new ActionContext(this.getSite().getSelectionProvider().getSelection()));
        this.fActionGroup.fillContextMenu(mgr);
    }

    private void addSortActions(IMenuManager mgr) {
        if (this.getLayout() != 1) {
            return;
        }
        MenuManager sortMenu = new MenuManager(SearchMessages.JavaSearchResultPage_sortBylabel);
        sortMenu.add((IAction)this.fSortByNameAction);
        sortMenu.add((IAction)this.fSortByPathAction);
        sortMenu.add((IAction)this.fSortByParentName);
        this.fSortByNameAction.setChecked(this.fCurrentSortOrder == this.fSortByNameAction.getSortOrder());
        this.fSortByPathAction.setChecked(this.fCurrentSortOrder == this.fSortByPathAction.getSortOrder());
        this.fSortByParentName.setChecked(this.fCurrentSortOrder == this.fSortByParentName.getSortOrder());
        mgr.appendToGroup("group.viewerSetup", (IContributionItem)sortMenu);
    }

    protected void fillToolbar(IToolBarManager tbm) {
        super.fillToolbar(tbm);
        if (this.getLayout() != 1) {
            this.addGroupActions(tbm);
        }
    }

    private void addGroupActions(IToolBarManager mgr) {
        mgr.appendToGroup("group.viewerSetup", (IContributionItem)new Separator("org.eclipse.jdt.search.resultpage.grouping"));
        mgr.appendToGroup("org.eclipse.jdt.search.resultpage.grouping", (IAction)this.fGroupProjectAction);
        mgr.appendToGroup("org.eclipse.jdt.search.resultpage.grouping", (IAction)this.fGroupPackageAction);
        mgr.appendToGroup("org.eclipse.jdt.search.resultpage.grouping", (IAction)this.fGroupFileAction);
        mgr.appendToGroup("org.eclipse.jdt.search.resultpage.grouping", (IAction)this.fGroupTypeAction);
        this.updateGroupingActions();
    }

    private void updateGroupingActions() {
        this.fGroupProjectAction.setChecked(this.fCurrentGrouping == 4);
        this.fGroupPackageAction.setChecked(this.fCurrentGrouping == 3);
        this.fGroupFileAction.setChecked(this.fCurrentGrouping == 2);
        this.fGroupTypeAction.setChecked(this.fCurrentGrouping == 1);
    }

    public void dispose() {
        this.fActionGroup.dispose();
        super.dispose();
    }

    protected void elementsChanged(Object[] objects) {
        if (this.fContentProvider != null) {
            this.fContentProvider.elementsChanged(objects);
        }
    }

    protected void clear() {
        if (this.fContentProvider != null) {
            this.fContentProvider.clear();
        }
    }

    private void addDragAdapters(StructuredViewer viewer) {
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getInstance(), ResourceTransfer.getInstance()};
        int ops = 5;
        TransferDragSourceListener[] dragListeners = new TransferDragSourceListener[]{new SelectionTransferDragAdapter((ISelectionProvider)viewer), new ResourceTransferDragAdapter((ISelectionProvider)viewer)};
        viewer.addDragSupport(ops, transfers, (DragSourceListener)new JdtViewerDragAdapter(viewer, dragListeners));
    }

    protected void configureTableViewer(TableViewer viewer) {
        viewer.setUseHashlookup(true);
        SortingLabelProvider sortingLabelProvider = new SortingLabelProvider(this);
        viewer.setLabelProvider((IBaseLabelProvider)new ColorDecoratingLabelProvider(sortingLabelProvider, PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        this.fContentProvider = new JavaSearchTableContentProvider(this);
        viewer.setContentProvider((IContentProvider)this.fContentProvider);
        viewer.setSorter((ViewerSorter)new DecoratorIgnoringViewerSorter(sortingLabelProvider));
        this.setSortOrder(this.fCurrentSortOrder);
        this.addDragAdapters((StructuredViewer)viewer);
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        PostfixLabelProvider postfixLabelProvider = new PostfixLabelProvider(this);
        viewer.setUseHashlookup(true);
        viewer.setSorter((ViewerSorter)new DecoratorIgnoringViewerSorter(postfixLabelProvider));
        viewer.setLabelProvider((IBaseLabelProvider)new ColorDecoratingLabelProvider(postfixLabelProvider, PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        this.fContentProvider = new LevelTreeContentProvider(this, this.fCurrentGrouping);
        viewer.setContentProvider((IContentProvider)this.fContentProvider);
        this.addDragAdapters((StructuredViewer)viewer);
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        return new ProblemTreeViewer(parent, 770){

            public void add(Object parentElement, Object[] childElements) {
                if (JavaSearchResultPage.this.limitElements() && parentElement.equals(this.getInput())) {
                    int elementLimit = JavaSearchResultPage.this.getElementLimit();
                    Widget parentWidget = this.findItem(parentElement);
                    if (parentWidget == null) {
                        return;
                    }
                    Item[] children = this.getChildren(parentWidget);
                    if (children.length >= elementLimit) {
                        return;
                    }
                    if (children.length + childElements.length <= elementLimit) {
                        super.add(parentElement, childElements);
                        return;
                    }
                    int toAdd = elementLimit - children.length;
                    Object[] limited = new Object[toAdd];
                    System.arraycopy(childElements, 0, limited, 0, limited.length);
                    super.add(parentElement, limited);
                    return;
                }
                super.add(parentElement, childElements);
            }

            protected Object[] getFilteredChildren(Object parentElement) {
                if (parentElement == null) {
                    return new Object[0];
                }
                Object[] filtered = super.getFilteredChildren(parentElement);
                int elementLimit = JavaSearchResultPage.this.getElementLimit();
                if (JavaSearchResultPage.this.limitElements() && parentElement.equals(this.getInput()) && filtered.length > elementLimit) {
                    Object[] limited = new Object[elementLimit];
                    System.arraycopy(filtered, 0, limited, 0, limited.length);
                    return limited;
                }
                return filtered;
            }
        };
    }

    int getElementLimit() {
        return this.fElementLimit;
    }

    protected TableViewer createTableViewer(Composite parent) {
        return new ProblemTableViewer(parent, 770){

            public void add(Object[] elements) {
                if (JavaSearchResultPage.this.limitElements()) {
                    int elementLimit = JavaSearchResultPage.this.getElementLimit();
                    int currentCount = this.getTable().getItemCount();
                    if (currentCount >= elementLimit) {
                        return;
                    }
                    if (currentCount + elements.length <= elementLimit) {
                        super.add(elements);
                        return;
                    }
                    int toAdd = elementLimit - currentCount;
                    Object[] limited = new Object[toAdd];
                    System.arraycopy(elements, 0, limited, 0, limited.length);
                    super.add(limited);
                    return;
                }
                super.add(elements);
            }

            protected Object[] getFilteredChildren(Object parentElement) {
                if (parentElement == null) {
                    return new Object[0];
                }
                Object[] filtered = super.getFilteredChildren(parentElement);
                int elementLimit = JavaSearchResultPage.this.getElementLimit();
                if (JavaSearchResultPage.this.limitElements() && parentElement.equals(this.getInput()) && filtered.length > elementLimit) {
                    Object[] limited = new Object[elementLimit];
                    System.arraycopy(filtered, 0, limited, 0, limited.length);
                    return limited;
                }
                return filtered;
            }
        };
    }

    void setSortOrder(int order) {
        this.fCurrentSortOrder = order;
        StructuredViewer viewer = this.getViewer();
        viewer.getControl().setRedraw(false);
        DecoratingLabelProvider dlp = (DecoratingLabelProvider)viewer.getLabelProvider();
        ((SortingLabelProvider)dlp.getLabelProvider()).setOrder(order);
        viewer.getControl().setRedraw(true);
        viewer.refresh();
        this.getSettings().put(KEY_SORTING, this.fCurrentSortOrder);
    }

    public void init(IPageSite site) {
        super.init(site);
        IMenuManager menuManager = site.getActionBars().getMenuManager();
        menuManager.insertBefore("group.properties", (IContributionItem)new Separator(GROUP_FILTERING));
        this.fActionGroup.fillActionBars(site.getActionBars());
        menuManager.appendToGroup(GROUP_FILTERING, (IAction)this.fFilterDialogAction);
        menuManager.appendToGroup("group.properties", (IAction)new Action(SearchMessages.JavaSearchResultPage_preferences_label){

            public void run() {
                String pageId = "org.eclipse.search.preferences.SearchPreferencePage";
                PreferencesUtil.createPreferenceDialogOn((Shell)JavaPlugin.getActiveWorkbenchShell(), (String)pageId, null, null).open();
            }
        });
    }

    void setGrouping(int grouping) {
        this.fCurrentGrouping = grouping;
        StructuredViewer viewer = this.getViewer();
        LevelTreeContentProvider cp = (LevelTreeContentProvider)viewer.getContentProvider();
        cp.setLevel(grouping);
        this.updateGroupingActions();
        this.getSettings().put("org.eclipse.jdt.search.resultpage.grouping", this.fCurrentGrouping);
        this.getViewPart().updateLabel();
    }

    protected StructuredViewer getViewer() {
        return super.getViewer();
    }

    public void restoreState(IMemento memento) {
        super.restoreState(memento);
        try {
            this.fCurrentSortOrder = this.getSettings().getInt(KEY_SORTING);
        }
        catch (NumberFormatException numberFormatException) {
            this.fCurrentSortOrder = 1;
        }
        try {
            this.fCurrentGrouping = this.getSettings().getInt("org.eclipse.jdt.search.resultpage.grouping");
        }
        catch (NumberFormatException numberFormatException) {
            this.fCurrentGrouping = 3;
        }
        this.fLimitElements = !FALSE.equals(this.getSettings().get(KEY_LIMIT_ENABLED));
        try {
            this.fElementLimit = this.getSettings().getInt(KEY_LIMIT);
        }
        catch (NumberFormatException numberFormatException) {
            this.fElementLimit = 1000;
        }
        if (memento != null) {
            Integer value = memento.getInteger("org.eclipse.jdt.search.resultpage.grouping");
            if (value != null) {
                this.fCurrentGrouping = value;
            }
            if ((value = memento.getInteger(KEY_SORTING)) != null) {
                this.fCurrentSortOrder = value;
            }
            this.fLimitElements = !FALSE.equals(memento.getString(KEY_LIMIT_ENABLED));
            value = memento.getInteger(KEY_LIMIT);
            if (value != null) {
                this.fElementLimit = value;
            }
        }
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento.putInteger("org.eclipse.jdt.search.resultpage.grouping", this.fCurrentGrouping);
        memento.putInteger(KEY_SORTING, this.fCurrentSortOrder);
        if (this.fLimitElements) {
            memento.putString(KEY_LIMIT_ENABLED, TRUE);
        } else {
            memento.putString(KEY_LIMIT_ENABLED, FALSE);
        }
        memento.putInteger(KEY_LIMIT, this.getElementLimit());
    }

    void enableLimit(boolean enable) {
        this.fLimitElements = enable;
        if (this.fLimitElements) {
            this.getSettings().put(KEY_LIMIT_ENABLED, TRUE);
        } else {
            this.getSettings().put(KEY_LIMIT_ENABLED, FALSE);
        }
        this.limitChanged();
    }

    private void limitChanged() {
        this.getViewer().refresh();
        this.getViewPart().updateLabel();
    }

    boolean limitElements() {
        return this.fLimitElements;
    }

    void removeMatchFilter(MatchFilter filter) {
        String id = filter.getID();
        MatchFilter[] matchFilters = this.getMatchFilters();
        ArrayList<MatchFilter> res = new ArrayList<MatchFilter>(matchFilters.length);
        int i = 0;
        while (i < matchFilters.length) {
            if (!id.equals(matchFilters[i].getID())) {
                res.add(matchFilters[i]);
            }
            ++i;
        }
        MatchFilter[] newFilters = res.toArray(new MatchFilter[res.size()]);
        this.setFilters(newFilters);
    }

    void addMatchFilter(MatchFilter filter) {
        String id = filter.getID();
        MatchFilter[] matchFilters = this.getMatchFilters();
        ArrayList<MatchFilter> res = new ArrayList<MatchFilter>(matchFilters.length);
        int i = 0;
        while (i < matchFilters.length) {
            if (!id.equals(matchFilters[i].getID())) {
                res.add(matchFilters[i]);
            }
            ++i;
        }
        res.add(filter);
        MatchFilter[] newFilters = res.toArray(new MatchFilter[res.size()]);
        this.setFilters(newFilters);
    }

    protected synchronized void handleSearchResultChanged(SearchResultEvent e) {
        super.handleSearchResultChanged(e);
        if (e instanceof JavaSearchResult.MatchFilterEvent) {
            this.filtersChanged(((JavaSearchResult.MatchFilterEvent)e).getActivatedFilters());
        }
    }

    private void filtersChanged(MatchFilter[] newFilters) {
        StructuredViewer viewer = this.getViewer();
        JavaSearchContentProvider cp = (JavaSearchContentProvider)viewer.getContentProvider();
        cp.filtersChanged(this.getMatchFilters());
        this.updateFilterActions();
        this.getViewer().refresh();
        this.getViewPart().updateLabel();
    }

    private void updateFilterActions() {
        IMenuManager menu = this.getSite().getActionBars().getMenuManager();
        int i = 0;
        while (i < this.fFilterActions.length) {
            this.fFilterActions[i].updateCheckState();
            ++i;
        }
        this.getSite().getActionBars().updateActionBars();
        menu.updateAll(true);
    }

    boolean hasMatchFilter(MatchFilter filter) {
        JavaSearchResult input = (JavaSearchResult)this.getInput();
        if (input != null) {
            return input.hasMatchFilterActivated(filter);
        }
        return false;
    }

    MatchFilter[] getMatchFilters() {
        JavaSearchResult input = (JavaSearchResult)this.getInput();
        if (input != null) {
            return input.getActivatedMatchFilters();
        }
        return new MatchFilter[0];
    }

    public int getDisplayedMatchCount(Object element) {
        if (this.getMatchFilters().length == 0) {
            return super.getDisplayedMatchCount(element);
        }
        Match[] matches = super.getDisplayedMatches(element);
        int count = 0;
        int i = 0;
        while (i < matches.length) {
            if (!matches[i].isFiltered()) {
                ++count;
            }
            ++i;
        }
        return count;
    }

    public Match[] getDisplayedMatches(Object element) {
        if (this.getMatchFilters().length == 0) {
            return super.getDisplayedMatches(element);
        }
        Match[] matches = super.getDisplayedMatches(element);
        int count = 0;
        int i = 0;
        while (i < matches.length) {
            if (matches[i].isFiltered()) {
                matches[i] = null;
            } else {
                ++count;
            }
            ++i;
        }
        Match[] filteredMatches = new Match[count];
        int writeIndex = 0;
        int i2 = 0;
        while (i2 < matches.length) {
            if (matches[i2] != null) {
                filteredMatches[writeIndex++] = matches[i2];
            }
            ++i2;
        }
        return filteredMatches;
    }

    public void setInput(ISearchResult search, Object viewState) {
        super.setInput(search, viewState);
        JavaSearchResult input = (JavaSearchResult)search;
        this.updateFilterEnablement(input);
    }

    private void updateFilterEnablement(JavaSearchResult result) {
        IActionBars bars = this.getSite().getActionBars();
        IMenuManager menu = bars.getMenuManager();
        int i = 0;
        while (i < this.fFilterActions.length) {
            menu.remove(this.fFilterActions[i].getId());
            ++i;
        }
        i = this.fFilterActions.length - 1;
        while (i >= 0) {
            FilterAction filterAction = this.fFilterActions[i];
            if (this.shouldEnable(result, filterAction)) {
                menu.prependToGroup(GROUP_FILTERING, (IAction)filterAction);
            }
            filterAction.updateCheckState();
            --i;
        }
        menu.updateAll(true);
        bars.updateActionBars();
    }

    private boolean shouldEnable(JavaSearchResult result, FilterAction filterAction) {
        if (result == null) {
            return false;
        }
        JavaSearchQuery query = (JavaSearchQuery)result.getQuery();
        if (query == null) {
            return false;
        }
        return filterAction.getFilter().isApplicable(query);
    }

    private boolean isQueryRunning() {
        AbstractTextSearchResult result = this.getInput();
        if (result != null) {
            return NewSearchUI.isQueryRunning((ISearchQuery)result.getQuery());
        }
        return false;
    }

    public String getLabel() {
        int filteredOut;
        String label = super.getLabel();
        if (this.getInput() != null && ((filteredOut = this.getInput().getMatchCount() - this.getFilteredMatchCount()) > 0 || this.getMatchFiltersCount() > 0)) {
            if (this.isQueryRunning()) {
                String message = SearchMessages.JavaSearchResultPage_filtered_message;
                return Messages.format(message, new Object[]{label});
            }
            String message = SearchMessages.JavaSearchResultPage_filteredWithCount_message;
            return Messages.format(message, new Object[]{label, String.valueOf(filteredOut)});
        }
        return label;
    }

    private int getMatchFiltersCount() {
        MatchFilter[] filters = this.getMatchFilters();
        AbstractTextSearchResult result = this.getInput();
        if (result == null) {
            return 0;
        }
        int filterCount = 0;
        int i = 0;
        while (i < filters.length) {
            if (filters[i].isApplicable((JavaSearchQuery)result.getQuery())) {
                ++filterCount;
            }
            ++i;
        }
        return filterCount;
    }

    private int getFilteredMatchCount() {
        StructuredViewer viewer = this.getViewer();
        if (viewer instanceof TreeViewer) {
            ITreeContentProvider tp = (ITreeContentProvider)viewer.getContentProvider();
            return this.getMatchCount(tp, this.getRootElements((TreeViewer)this.getViewer()));
        }
        return this.getMatchCount((TableViewer)viewer);
    }

    private Object[] getRootElements(TreeViewer viewer) {
        Tree t = viewer.getTree();
        TreeItem[] roots = t.getItems();
        Object[] elements = new Object[roots.length];
        int i = 0;
        while (i < elements.length) {
            elements[i] = roots[i].getData();
            ++i;
        }
        return elements;
    }

    private Object[] getRootElements(TableViewer viewer) {
        Table t = viewer.getTable();
        TableItem[] roots = t.getItems();
        Object[] elements = new Object[roots.length];
        int i = 0;
        while (i < elements.length) {
            elements[i] = roots[i].getData();
            ++i;
        }
        return elements;
    }

    private int getMatchCount(ITreeContentProvider cp, Object[] elements) {
        int count = 0;
        int j = 0;
        while (j < elements.length) {
            count += this.getDisplayedMatchCount(elements[j]);
            Object[] children = cp.getChildren(elements[j]);
            count += this.getMatchCount(cp, children);
            ++j;
        }
        return count;
    }

    private int getMatchCount(TableViewer viewer) {
        Object[] elements = this.getRootElements(viewer);
        int count = 0;
        int i = 0;
        while (i < elements.length) {
            count += this.getDisplayedMatchCount(elements[i]);
            ++i;
        }
        return count;
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.part.IShowInTargetList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter)) {
            return SHOW_IN_TARGET_LIST;
        }
        return null;
    }

    protected void handleOpen(OpenEvent event) {
        Object firstElement = ((IStructuredSelection)event.getSelection()).getFirstElement();
        if ((firstElement instanceof ICompilationUnit || firstElement instanceof IClassFile || firstElement instanceof IMember) && this.getDisplayedMatchCount(firstElement) == 0) {
            try {
                this.fEditorOpener.openElement(firstElement);
            }
            catch (CoreException e) {
                ExceptionHandler.handle(e, this.getSite().getShell(), SearchMessages.JavaSearchResultPage_open_editor_error_title, SearchMessages.JavaSearchResultPage_open_editor_error_message);
            }
            return;
        }
        super.handleOpen(event);
    }

    public void setFilters(MatchFilter[] enabledFilters) {
        JavaSearchResult input = (JavaSearchResult)this.getInput();
        if (input != null) {
            input.setActivatedFilters(enabledFilters);
        }
    }

    void setElementLimit(int elementLimit) {
        this.fElementLimit = elementLimit;
        this.getSettings().put(KEY_LIMIT, elementLimit);
        this.limitChanged();
    }

    public static class DecoratorIgnoringViewerSorter
    extends ViewerSorter {
        private final ILabelProvider fLabelProvider;
        private com.ibm.icu.text.Collator fNewCollator;

        public DecoratorIgnoringViewerSorter(ILabelProvider labelProvider) {
            super(null);
            this.fLabelProvider = labelProvider;
            this.fNewCollator = null;
        }

        public int compare(Viewer viewer, Object e1, Object e2) {
            String name1 = this.fLabelProvider.getText(e1);
            String name2 = this.fLabelProvider.getText(e2);
            if (name1 == null) {
                name1 = "";
            }
            if (name2 == null) {
                name2 = "";
            }
            return this.getNewCollator().compare(name1, name2);
        }

        public final Collator getCollator() {
            if (this.collator == null) {
                this.collator = Collator.getInstance();
            }
            return this.collator;
        }

        private final com.ibm.icu.text.Collator getNewCollator() {
            if (this.fNewCollator == null) {
                this.fNewCollator = com.ibm.icu.text.Collator.getInstance();
            }
            return this.fNewCollator;
        }
    }
}

