/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.CompletionProposal;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.java.GenericJavaTypeProposal;
import org.eclipse.jdt.internal.ui.text.java.JavaCompletionProposalComputer;
import org.eclipse.jdt.internal.ui.text.java.LazyJavaTypeCompletionProposal;
import org.eclipse.jdt.ui.text.java.CompletionProposalCollector;
import org.eclipse.jdt.ui.text.java.ContentAssistInvocationContext;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jdt.ui.text.java.JavaContentAssistInvocationContext;
import org.eclipse.jface.text.BadLocationException;

public class JavaTypeCompletionProposalComputer
extends JavaCompletionProposalComputer {
    protected CompletionProposalCollector createCollector(JavaContentAssistInvocationContext context) {
        CompletionProposalCollector collector = super.createCollector(context);
        collector.setIgnored(13, true);
        collector.setIgnored(1, true);
        collector.setIgnored(2, true);
        collector.setIgnored(3, true);
        collector.setIgnored(4, true);
        collector.setIgnored(5, true);
        collector.setIgnored(7, true);
        collector.setIgnored(12, true);
        collector.setIgnored(6, true);
        collector.setIgnored(8, true);
        collector.setIgnored(11, true);
        collector.setIgnored(10, true);
        collector.setIgnored(19, true);
        collector.setIgnored(14, true);
        collector.setIgnored(20, true);
        collector.setIgnored(15, true);
        collector.setIgnored(18, true);
        collector.setIgnored(16, true);
        collector.setIgnored(17, true);
        collector.setIgnored(9, false);
        return collector;
    }

    public List computeCompletionProposals(ContentAssistInvocationContext context, IProgressMonitor monitor) {
        List types = super.computeCompletionProposals(context, monitor);
        if (context instanceof JavaContentAssistInvocationContext) {
            JavaContentAssistInvocationContext javaContext = (JavaContentAssistInvocationContext)context;
            try {
                IType expectedType;
                if (types.size() > 0 && context.computeIdentifierPrefix().length() == 0 && (expectedType = javaContext.getExpectedType()) != null) {
                    LazyJavaTypeCompletionProposal typeProposal = (LazyJavaTypeCompletionProposal)types.get(0);
                    List history = JavaPlugin.getDefault().getContentAssistHistory().getHistory(expectedType.getFullyQualifiedName()).getTypes();
                    int relevance = typeProposal.getRelevance() - history.size() - 1;
                    Iterator it = history.iterator();
                    while (it.hasNext()) {
                        String type = (String)it.next();
                        if (type.equals(((IType)typeProposal.getJavaElement()).getFullyQualifiedName())) continue;
                        IJavaCompletionProposal proposal = this.createTypeProposal(relevance, type, javaContext);
                        if (proposal != null) {
                            types.add(proposal);
                        }
                        ++relevance;
                    }
                }
            }
            catch (BadLocationException x) {
                JavaPlugin.log(x);
            }
            catch (JavaModelException x) {
                JavaPlugin.log(x);
            }
        }
        return types;
    }

    private IJavaCompletionProposal createTypeProposal(int relevance, String fullyQualifiedType, JavaContentAssistInvocationContext context) throws JavaModelException {
        IType type = context.getCompilationUnit().getJavaProject().findType(fullyQualifiedType);
        if (type == null) {
            return null;
        }
        CompletionProposal proposal = CompletionProposal.create((int)9, (int)context.getInvocationOffset());
        proposal.setCompletion(type.getElementName().toCharArray());
        proposal.setDeclarationSignature(type.getPackageFragment().getElementName().toCharArray());
        proposal.setFlags(type.getFlags());
        proposal.setRelevance(relevance);
        proposal.setReplaceRange(context.getInvocationOffset(), context.getInvocationOffset());
        proposal.setSignature(Signature.createTypeSignature((String)fullyQualifiedType, (boolean)true).toCharArray());
        if (this.shouldProposeGenerics(context.getProject())) {
            return new GenericJavaTypeProposal(proposal, context);
        }
        return new LazyJavaTypeCompletionProposal(proposal, context);
    }

    private final boolean shouldProposeGenerics(IJavaProject project) {
        String sourceVersion = project != null ? project.getOption("org.eclipse.jdt.core.compiler.source", true) : JavaCore.getOption((String)"org.eclipse.jdt.core.compiler.source");
        return sourceVersion != null && "1.5".compareTo(sourceVersion) <= 0;
    }
}

