/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.fix;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.internal.corext.codemanipulation.CodeGenerationSettings;
import org.eclipse.jdt.internal.corext.codemanipulation.OrganizeImportsOperation;
import org.eclipse.jdt.internal.corext.fix.AbstractFix;
import org.eclipse.jdt.internal.corext.fix.FixMessages;
import org.eclipse.jdt.internal.corext.fix.IFix;
import org.eclipse.jdt.internal.corext.fix.IFixRewriteOperation;
import org.eclipse.jdt.internal.corext.refactoring.changes.CompilationUnitChange;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.ltk.core.refactoring.CategorizedTextEditGroup;
import org.eclipse.ltk.core.refactoring.GroupCategory;
import org.eclipse.ltk.core.refactoring.GroupCategorySet;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.TextChange;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.text.edits.TextEditGroup;

public class ImportsFix
extends AbstractFix {
    public static IFix createCleanUp(final CompilationUnit cu, CodeGenerationSettings settings, boolean organizeImports, RefactoringStatus status) throws CoreException {
        TextEdit edit;
        if (!organizeImports) {
            return null;
        }
        OrganizeImportsOperation.IChooseImportQuery query = new OrganizeImportsOperation.IChooseImportQuery(){

            public TypeNameMatch[] chooseImports(TypeNameMatch[][] openChoices, ISourceRange[] ranges) {
                throw new AmbiguousImportException();
            }
        };
        OrganizeImportsOperation op = new OrganizeImportsOperation((ICompilationUnit)cu.getJavaElement(), cu, settings.importIgnoreLowercase, false, false, query);
        try {
            edit = op.createTextEdit(null);
        }
        catch (AmbiguousImportException ambiguousImportException) {
            status.addInfo(Messages.format(ActionMessages.OrganizeImportsAction_multi_error_unresolvable, ImportsFix.getLocationString(cu)));
            return null;
        }
        if (op.getParseError() != null) {
            status.addInfo(Messages.format(ActionMessages.OrganizeImportsAction_multi_error_parse, ImportsFix.getLocationString(cu)));
            return null;
        }
        if (edit == null) {
            return null;
        }
        if (op.getNumberOfImportsAdded() == 0 && op.getNumberOfImportsRemoved() == 0) {
            return null;
        }
        return new IFix(){

            public TextChange createChange() throws CoreException {
                CompilationUnitChange result = new CompilationUnitChange(this.getDescription(), this.getCompilationUnit());
                result.setEdit(edit);
                String label = this.getDescription();
                result.addTextEditGroup((TextEditGroup)new CategorizedTextEditGroup(label, new GroupCategorySet(new GroupCategory(label, label, label))));
                return result;
            }

            public ICompilationUnit getCompilationUnit() {
                return (ICompilationUnit)cu.getJavaElement();
            }

            public String getDescription() {
                return FixMessages.ImportsFix_OrganizeImports_Description;
            }

            public IStatus getStatus() {
                return StatusInfo.OK_STATUS;
            }
        };
    }

    private static String getLocationString(CompilationUnit cu) {
        return cu.getJavaElement().getPath().makeRelative().toString();
    }

    protected ImportsFix(String name, CompilationUnit compilationUnit, IFixRewriteOperation[] fixRewriteOperations) {
        super(name, compilationUnit, fixRewriteOperations);
    }

    private static final class AmbiguousImportException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        private AmbiguousImportException() {
        }
    }
}

