/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.changes;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.base.JDTChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.DeleteFromClasspathChange;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class AddToClasspathChange
extends JDTChange {
    private IJavaProject fProjectHandle;
    private IClasspathEntry fEntryToAdd;

    public AddToClasspathChange(IJavaProject project, IClasspathEntry entryToAdd) {
        this.fProjectHandle = project;
        this.fEntryToAdd = entryToAdd;
    }

    public AddToClasspathChange(IJavaProject project, String sourceFolderName) {
        this(project, JavaCore.newSourceEntry((IPath)project.getPath().append(sourceFolderName)));
    }

    public AddToClasspathChange(IJavaProject project, IPath newProjectEntry) {
        this(project, JavaCore.newProjectEntry((IPath)newProjectEntry));
    }

    public AddToClasspathChange(IJavaProject project, int entryKind, IPath path, IPath sourceAttachmentPath, IPath sourceAttachmentRootPath) {
        this(project, AddToClasspathChange.createNewClasspathEntry(entryKind, path, sourceAttachmentPath, sourceAttachmentRootPath));
    }

    public RefactoringStatus isValid(IProgressMonitor pm) throws CoreException {
        return super.isValid(pm, 3);
    }

    public Change perform(IProgressMonitor pm) throws CoreException {
        pm.beginTask(this.getName(), 1);
        try {
            if (this.validateClasspath()) {
                this.getJavaProject().setRawClasspath(this.getNewClasspathEntries(), (IProgressMonitor)new SubProgressMonitor(pm, 1));
                IPath classpathEntryPath = JavaCore.getResolvedClasspathEntry((IClasspathEntry)this.fEntryToAdd).getPath();
                DeleteFromClasspathChange deleteFromClasspathChange = new DeleteFromClasspathChange(classpathEntryPath, this.getJavaProject());
                return deleteFromClasspathChange;
            }
            NullChange nullChange = new NullChange();
            return nullChange;
        }
        finally {
            pm.done();
        }
    }

    public boolean validateClasspath() throws JavaModelException {
        IJavaProject javaProject = this.getJavaProject();
        IPath outputLocation = javaProject.getOutputLocation();
        IClasspathEntry[] newClasspathEntries = this.getNewClasspathEntries();
        return JavaConventions.validateClasspath((IJavaProject)javaProject, (IClasspathEntry[])newClasspathEntries, (IPath)outputLocation).isOK();
    }

    private IClasspathEntry[] getNewClasspathEntries() throws JavaModelException {
        IClasspathEntry[] entries = this.getJavaProject().getRawClasspath();
        ArrayList<IClasspathEntry> cp = new ArrayList<IClasspathEntry>(entries.length + 1);
        cp.addAll(Arrays.asList(entries));
        cp.add(this.fEntryToAdd);
        return cp.toArray(new IClasspathEntry[cp.size()]);
    }

    private static IClasspathEntry createNewClasspathEntry(int kind, IPath path, IPath sourceAttach, IPath sourceAttachRoot) {
        switch (kind) {
            case 1: {
                return JavaCore.newLibraryEntry((IPath)path, (IPath)sourceAttach, (IPath)sourceAttachRoot);
            }
            case 2: {
                return JavaCore.newProjectEntry((IPath)path);
            }
            case 3: {
                return JavaCore.newSourceEntry((IPath)path);
            }
            case 4: {
                return JavaCore.newVariableEntry((IPath)path, (IPath)sourceAttach, (IPath)sourceAttachRoot);
            }
            case 5: {
                return JavaCore.newContainerEntry((IPath)path);
            }
        }
        Assert.isTrue((boolean)false);
        return null;
    }

    private IJavaProject getJavaProject() {
        return this.fProjectHandle;
    }

    public String getName() {
        return String.valueOf(RefactoringCoreMessages.AddToClasspathChange_add) + this.getJavaProject().getElementName();
    }

    public Object getModifiedElement() {
        return this.getJavaProject();
    }

    public IClasspathEntry getClasspathEntry() {
        return this.fEntryToAdd;
    }
}

