/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.structure;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.NamingConventions;
import org.eclipse.jdt.core.ToolFactory;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.core.compiler.IScanner;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ArrayCreation;
import org.eclipse.jdt.core.dom.ArrayInitializer;
import org.eclipse.jdt.core.dom.ArrayType;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.ClassInstanceCreation;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.ExpressionStatement;
import org.eclipse.jdt.core.dom.FieldAccess;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.Javadoc;
import org.eclipse.jdt.core.dom.Message;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.Name;
import org.eclipse.jdt.core.dom.NullLiteral;
import org.eclipse.jdt.core.dom.QualifiedName;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SuperFieldAccess;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.corext.dom.TokenScanner;
import org.eclipse.jdt.internal.corext.dom.TypeBindingVisitor;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.ParameterInfo;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.TypeContextChecker;
import org.eclipse.jdt.internal.corext.refactoring.changes.CreateCompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.CreatePackageChange;
import org.eclipse.jdt.internal.corext.refactoring.structure.BodyUpdater;
import org.eclipse.jdt.internal.corext.refactoring.structure.ChangeSignatureRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.structure.CompilationUnitRewrite;
import org.eclipse.jdt.internal.corext.refactoring.structure.IDefaultValueAdvisor;
import org.eclipse.jdt.internal.corext.refactoring.structure.IntroduceParameterObjectRefactoring;
import org.eclipse.jdt.internal.corext.refactoring.structure.ParameterObjectFactory;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.correction.ASTResolving;
import org.eclipse.jdt.ui.CodeGeneration;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.RefactoringArguments;
import org.eclipse.text.edits.TextEdit;

public class IntroduceParameterObjectRefactoring
extends ChangeSignatureRefactoring {
    private static final String PARAMETER_CLASS_APPENDIX = "Parameter";
    private static final String DEFAULT_PARAMETER_OBJECT_NAME = "parameterObject";
    private MethodDeclaration fMethodDeclaration;
    private ICompilationUnit fCompilationUnit;
    private int fOffset;
    private int fLength;
    private ParameterObjectFactory fParameterObjectFactory;
    private boolean fCreateAsTopLevel = true;
    private ParameterInfo fParameterObjectReference;
    static /* synthetic */ Class class$0;

    private boolean isParameter(ParameterInfo pi, ASTNode node, List enclosingMethodParameters, String qualifier) {
        if (node instanceof Name) {
            Name name = (Name)node;
            IVariableBinding binding = ASTNodes.getVariableBinding(name);
            if (binding != null && binding.isParameter()) {
                return binding.getName().equals(this.getNameInScope(pi, enclosingMethodParameters));
            }
            if (node instanceof QualifiedName) {
                QualifiedName qn = (QualifiedName)node;
                return qn.getFullyQualifiedName().equals(JavaModelUtil.concatenateName(qualifier, this.getNameInScope(pi, enclosingMethodParameters)));
            }
        }
        return false;
    }

    public IntroduceParameterObjectRefactoring(IMethod method) throws JavaModelException {
        super(method);
        Assert.isNotNull((Object)method);
        this.initializeFields(method);
        this.setBodyUpdater(new RewriteParameterBody());
        this.setDefaultValueAdvisor(new ParameterObjectCreator());
        List parameterInfos = this.getParameterInfos();
        Iterator iter = parameterInfos.iterator();
        while (iter.hasNext()) {
            ParameterInfo pi = (ParameterInfo)iter.next();
            if (pi.isAdded()) continue;
            pi.setCreateField(true);
            pi.setNewName(this.getFieldName(pi));
        }
    }

    private void initializeFields(IMethod method) throws JavaModelException {
        this.fCompilationUnit = method.getCompilationUnit();
        Assert.isNotNull((Object)this.fCompilationUnit);
        this.fOffset = method.getNameRange().getOffset();
        this.fLength = method.getNameRange().getLength();
        this.fParameterObjectFactory = new ParameterObjectFactory(this.fCompilationUnit);
        String methodName = method.getElementName();
        String className = String.valueOf(Character.toUpperCase(methodName.charAt(0)));
        if (methodName.length() > 1) {
            className = String.valueOf(className) + methodName.substring(1);
        }
        className = String.valueOf(className) + PARAMETER_CLASS_APPENDIX;
        this.fParameterObjectReference = ParameterInfo.createInfoForAddedParameter(className, DEFAULT_PARAMETER_OBJECT_NAME);
        this.fParameterObjectFactory.setClassName(className);
        this.fParameterObjectFactory.setPackage(method.getDeclaringType().getPackageFragment().getElementName());
        this.updateReferenceType();
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        status.merge(this.fParameterObjectFactory.checkConditions());
        status.merge(Checks.checkIdentifier(this.getParameterName()));
        if (status.hasFatalError()) {
            return status;
        }
        status.merge(super.checkFinalConditions(pm));
        return status;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        List parameterInfos;
        RefactoringStatus status = new RefactoringStatus();
        status.merge(super.checkInitialConditions(pm));
        status.merge(Checks.checkAvailability((IJavaElement)this.fCompilationUnit));
        if (status.hasFatalError()) {
            return status;
        }
        CompilationUnit astRoot = this.getBaseCuRewrite().getRoot();
        ASTNode selectedNode = NodeFinder.perform((ASTNode)astRoot, this.fOffset, this.fLength);
        if (selectedNode == null) {
            return this.mappingErrorFound(status, selectedNode);
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.MethodDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.fMethodDeclaration = (MethodDeclaration)ASTNodes.getParent(selectedNode, clazz);
        if (this.fMethodDeclaration == null) {
            return this.mappingErrorFound(status, selectedNode);
        }
        IMethodBinding resolveBinding = this.fMethodDeclaration.resolveBinding();
        if (resolveBinding == null) {
            if (!this.processCompilerError(status, selectedNode)) {
                status.addFatalError(RefactoringCoreMessages.SelfEncapsulateField_type_not_resolveable);
            }
            return status;
        }
        ITypeBinding declaringClass = resolveBinding.getDeclaringClass();
        if (this.fParameterObjectFactory.getPackage() == null) {
            this.fParameterObjectFactory.setPackage(declaringClass.getPackage().getName());
        }
        if (this.fParameterObjectFactory.getEnclosingType() == null) {
            this.fParameterObjectFactory.setEnclosingType(declaringClass.getQualifiedName());
        }
        if (!(parameterInfos = super.getParameterInfos()).contains(this.fParameterObjectReference)) {
            parameterInfos.add(0, this.fParameterObjectReference);
        }
        HashMap<String, IVariableBinding> bindingMap = new HashMap<String, IVariableBinding>();
        Iterator iter = this.fMethodDeclaration.parameters().iterator();
        while (iter.hasNext()) {
            SingleVariableDeclaration sdv = (SingleVariableDeclaration)iter.next();
            bindingMap.put(sdv.getName().getIdentifier(), sdv.resolveBinding());
        }
        iter = parameterInfos.iterator();
        while (iter.hasNext()) {
            ParameterInfo pi = (ParameterInfo)iter.next();
            if (pi == this.fParameterObjectReference) continue;
            pi.setOldBinding((IVariableBinding)bindingMap.get(pi.getOldName()));
        }
        this.fParameterObjectFactory.setVariables(parameterInfos);
        return status;
    }

    protected TypeContextChecker.IProblemVerifier doGetProblemVerifier() {
        return new TypeContextChecker.IProblemVerifier(){

            public boolean isError(IProblem problem, ASTNode node) {
                if (node instanceof Type) {
                    Type type = (Type)node;
                    if (problem.getID() == 0x1000002 && IntroduceParameterObjectRefactoring.this.getClassName().equals(ASTNodes.getTypeName(type))) {
                        return false;
                    }
                }
                if (node instanceof Name) {
                    Name name = (Name)node;
                    if (problem.getID() == 268435846 && IntroduceParameterObjectRefactoring.this.getPackage().indexOf(name.getFullyQualifiedName()) != -1) {
                        return false;
                    }
                }
                return true;
            }
        };
    }

    public String getClassName() {
        return this.fParameterObjectFactory.getClassName();
    }

    public ITypeBinding getContainingClass() {
        return this.fMethodDeclaration.resolveBinding().getDeclaringClass();
    }

    private String getMappingErrorMessage() {
        return Messages.format(RefactoringCoreMessages.IntroduceParameterObjectRefactoring_cannotalanyzemethod_mappingerror, new String[0]);
    }

    public String getFieldName(ParameterInfo element) {
        String paramName = element.getOldName();
        IJavaProject javaProject = this.fCompilationUnit.getJavaProject();
        String stripped = NamingConventions.removePrefixAndSuffixForArgumentName((IJavaProject)javaProject, (String)paramName);
        int dim = element.getNewTypeBinding() != null ? element.getNewTypeBinding().getDimensions() : 0;
        return StubUtility.getVariableNameSuggestions(2, javaProject, stripped, dim, null, true)[0];
    }

    public String getName() {
        return RefactoringCoreMessages.IntroduceParameterObjectRefactoring_refactoring_name;
    }

    protected String doGetRefactoringChangeName() {
        return this.getName();
    }

    public String getParameterName() {
        return this.fParameterObjectReference.getNewName();
    }

    public RefactoringStatus initialize(RefactoringArguments arguments) {
        RefactoringStatus refactoringStatus = new RefactoringStatus();
        refactoringStatus.merge(super.initialize(arguments));
        return refactoringStatus;
    }

    public boolean isCreateGetter() {
        return this.fParameterObjectFactory.isCreateGetter();
    }

    public boolean isCreateSetter() {
        return this.fParameterObjectFactory.isCreateSetter();
    }

    public boolean isCreateAsTopLevel() {
        return this.fCreateAsTopLevel;
    }

    private boolean isValidField(ParameterInfo pi) {
        return pi.isCreateField() & !pi.isAdded();
    }

    private RefactoringStatus mappingErrorFound(RefactoringStatus result, ASTNode node) {
        if (node != null && (node.getFlags() & 1) != 0 && this.processCompilerError(result, node)) {
            return result;
        }
        result.addFatalError(this.getMappingErrorMessage());
        return result;
    }

    public void moveFieldDown(ParameterInfo selected) {
        this.fParameterObjectFactory.moveDown(selected);
    }

    public void moveFieldUp(ParameterInfo selected) {
        this.fParameterObjectFactory.moveUp(selected);
    }

    private boolean processCompilerError(RefactoringStatus result, ASTNode node) {
        Message[] messages = ASTNodes.getMessages(node, 2);
        if (messages.length == 0) {
            return false;
        }
        result.addFatalError(Messages.format(RefactoringCoreMessages.IntroduceParameterObjectRefactoring_cannotanalysemethod_compilererror, new String[]{messages[0].getMessage()}));
        return true;
    }

    public void setClassName(String className) {
        this.fParameterObjectFactory.setClassName(className);
        this.updateReferenceType();
    }

    private void updateReferenceType() {
        if (this.fCreateAsTopLevel) {
            this.fParameterObjectReference.setNewTypeName(JavaModelUtil.concatenateName(this.fParameterObjectFactory.getPackage(), this.fParameterObjectFactory.getClassName()));
        } else {
            this.fParameterObjectReference.setNewTypeName(JavaModelUtil.concatenateName(this.fParameterObjectFactory.getEnclosingType(), this.fParameterObjectFactory.getClassName()));
        }
    }

    public void setCreateComments(boolean selection) {
        this.fParameterObjectFactory.setCreateComments(selection);
    }

    public void setCreateGetter(boolean createGetter) {
        this.fParameterObjectFactory.setCreateGetter(createGetter);
    }

    public void setCreateSetter(boolean createSetter) {
        this.fParameterObjectFactory.setCreateSetter(createSetter);
    }

    public void setPackageName(String packageName) {
        this.fParameterObjectFactory.setPackage(packageName);
        this.updateReferenceType();
    }

    public void setParameterName(String paramName) {
        this.fParameterObjectReference.setNewName(paramName);
    }

    public void setCreateAsTopLevel(boolean topLevel) {
        this.fCreateAsTopLevel = topLevel;
        this.updateReferenceType();
    }

    public void updateParameterPosition() {
        this.fParameterObjectFactory.updateParameterPosition(this.fParameterObjectReference);
    }

    private void createParameterClass(MethodDeclaration methodDeclaration, CompilationUnitRewrite cuRewrite) throws CoreException {
        if (this.fCreateAsTopLevel) {
            ICompilationUnit unit;
            IJavaProject javaProject = this.fCompilationUnit.getJavaProject();
            IPackageFragment packageFragment = this.getPackageFragmentRoot().getPackageFragment(this.fParameterObjectFactory.getPackage());
            if (!packageFragment.exists()) {
                this.fOtherChanges.add(new CreatePackageChange(packageFragment));
            }
            Assert.isTrue((!(unit = packageFragment.getCompilationUnit(String.valueOf(this.fParameterObjectFactory.getClassName()) + ".java")).exists() ? 1 : 0) != 0);
            this.createTopLevelParameterObject(javaProject, unit);
        } else {
            ASTRewrite rewriter = cuRewrite.getASTRewrite();
            TypeDeclaration enclosingType = (TypeDeclaration)methodDeclaration.getParent();
            ListRewrite bodyRewrite = rewriter.getListRewrite((ASTNode)enclosingType, TypeDeclaration.BODY_DECLARATIONS_PROPERTY);
            TypeDeclaration classDeclaration = this.fParameterObjectFactory.createClassDeclaration(this.fCompilationUnit, enclosingType.getName().getFullyQualifiedName(), cuRewrite);
            classDeclaration.modifiers().add(rewriter.getAST().newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
            classDeclaration.modifiers().add(rewriter.getAST().newModifier(Modifier.ModifierKeyword.STATIC_KEYWORD));
            bodyRewrite.insertBefore((ASTNode)classDeclaration, (ASTNode)methodDeclaration, null);
        }
    }

    private void createTopLevelParameterObject(IJavaProject javaProject, ICompilationUnit unit) throws JavaModelException, CoreException {
        ICompilationUnit workingCopy = unit.getWorkingCopy(null);
        try {
            String lineDelimiter = StubUtility.getLineDelimiterUsed(javaProject);
            String fileComment = this.getFileComment(workingCopy, lineDelimiter);
            String typeComment = this.getTypeComment(workingCopy, lineDelimiter);
            String content = CodeGeneration.getCompilationUnitContent(workingCopy, fileComment, typeComment, "class " + this.getClassName() + "{}", lineDelimiter);
            workingCopy.getBuffer().setContents(content);
            CompilationUnitRewrite cuRewrite = new CompilationUnitRewrite(workingCopy);
            ASTRewrite rewriter = cuRewrite.getASTRewrite();
            CompilationUnit root = cuRewrite.getRoot();
            AST ast = cuRewrite.getAST();
            ImportRewrite importRewrite = cuRewrite.getImportRewrite();
            ListRewrite types = rewriter.getListRewrite((ASTNode)root, CompilationUnit.TYPES_PROPERTY);
            ASTNode dummyType = (ASTNode)types.getOriginalList().get(0);
            String newTypeName = JavaModelUtil.concatenateName(this.fParameterObjectFactory.getPackage(), this.fParameterObjectFactory.getClassName());
            TypeDeclaration classDeclaration = this.fParameterObjectFactory.createClassDeclaration(workingCopy, newTypeName, cuRewrite);
            classDeclaration.modifiers().add(ast.newModifier(Modifier.ModifierKeyword.PUBLIC_KEYWORD));
            Javadoc javadoc = (Javadoc)dummyType.getStructuralProperty((StructuralPropertyDescriptor)TypeDeclaration.JAVADOC_PROPERTY);
            rewriter.set((ASTNode)classDeclaration, (StructuralPropertyDescriptor)TypeDeclaration.JAVADOC_PROPERTY, (Object)javadoc, null);
            types.replace(dummyType, (ASTNode)classDeclaration, null);
            String charset = ResourceUtil.getFile(this.fCompilationUnit).getCharset(false);
            Document document = new Document(content);
            try {
                rewriter.rewriteAST().apply((IDocument)document);
                TextEdit rewriteImports = importRewrite.rewriteImports(null);
                rewriteImports.apply((IDocument)document);
            }
            catch (BadLocationException e) {
                throw new CoreException((IStatus)new Status(4, JavaPlugin.getPluginId(), RefactoringCoreMessages.IntroduceParameterObjectRefactoring_parameter_object_creation_error, (Throwable)e));
            }
            String docContent = document.get();
            CreateCompilationUnitChange compilationUnitChange = new CreateCompilationUnitChange(unit, docContent, charset);
            this.fOtherChanges.add(compilationUnitChange);
        }
        finally {
            workingCopy.discardWorkingCopy();
        }
    }

    public IPackageFragmentRoot getPackageFragmentRoot() {
        return (IPackageFragmentRoot)this.fCompilationUnit.getAncestor(3);
    }

    protected String getFileComment(ICompilationUnit parentCU, String lineDelimiter) throws CoreException {
        if (this.fParameterObjectFactory.isCreateComments()) {
            return CodeGeneration.getFileComment(parentCU, lineDelimiter);
        }
        return null;
    }

    protected String getTypeComment(ICompilationUnit parentCU, String lineDelimiter) throws CoreException {
        if (this.fParameterObjectFactory.isCreateComments()) {
            StringBuffer typeName = new StringBuffer();
            typeName.append(this.fParameterObjectFactory.getClassName());
            String[] typeParamNames = new String[]{};
            String comment = CodeGeneration.getTypeComment(parentCU, typeName.toString(), typeParamNames, lineDelimiter);
            if (comment != null && this.isValidComment(comment)) {
                return comment;
            }
        }
        return null;
    }

    private boolean isValidComment(String template) {
        IScanner scanner = ToolFactory.createScanner((boolean)true, (boolean)false, (boolean)false, (boolean)false);
        scanner.setSource(template.toCharArray());
        try {
            int next = scanner.getNextToken();
            while (TokenScanner.isComment(next)) {
                next = scanner.getNextToken();
            }
            return next == 158;
        }
        catch (InvalidInputException invalidInputException) {
            return false;
        }
    }

    public String getPackage() {
        return this.fParameterObjectFactory.getPackage();
    }

    public void setPackage(String typeQualifier) {
        this.fParameterObjectFactory.setPackage(typeQualifier);
    }

    public ICompilationUnit getCompilationUnit() {
        return this.fCompilationUnit;
    }

    private String getNameInScope(ParameterInfo pi, List enclosingMethodParameters) {
        boolean emptyVararg;
        Assert.isNotNull((Object)enclosingMethodParameters);
        boolean bl = emptyVararg = pi.getOldIndex() >= enclosingMethodParameters.size();
        if (!emptyVararg) {
            SingleVariableDeclaration svd = (SingleVariableDeclaration)enclosingMethodParameters.get(pi.getOldIndex());
            return svd.getName().getIdentifier();
        }
        return null;
    }

    public String getNewTypeName() {
        return this.fParameterObjectReference.getNewTypeName();
    }

    private final class ParameterObjectCreator
    implements IDefaultValueAdvisor {
        private ParameterObjectCreator() {
        }

        public Expression createDefaultExpression(List invocationArguments, ParameterInfo addedInfo, List parameterInfos, MethodDeclaration enclosingMethod, boolean isRecursive, CompilationUnitRewrite cuRewrite) {
            AST ast = cuRewrite.getAST();
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            if (isRecursive && this.canReuseParameterObject(invocationArguments, addedInfo, parameterInfos, enclosingMethod)) {
                return ast.newSimpleName(addedInfo.getNewName());
            }
            ClassInstanceCreation classCreation = ast.newClassInstanceCreation();
            int startPosition = enclosingMethod != null ? enclosingMethod.getStartPosition() : cuRewrite.getRoot().getStartPosition();
            classCreation.setType(IntroduceParameterObjectRefactoring.this.fParameterObjectFactory.createType(IntroduceParameterObjectRefactoring.this.fCreateAsTopLevel, cuRewrite, startPosition));
            List constructorArguments = classCreation.arguments();
            Iterator iter = parameterInfos.iterator();
            while (iter.hasNext()) {
                ParameterInfo pi = (ParameterInfo)iter.next();
                if (!IntroduceParameterObjectRefactoring.this.isValidField(pi)) continue;
                if (pi.isOldVarargs()) {
                    boolean isLastParameter = !iter.hasNext();
                    constructorArguments.addAll(this.computeVarargs(invocationArguments, pi, isLastParameter, cuRewrite));
                    continue;
                }
                Expression exp = (Expression)invocationArguments.get(pi.getOldIndex());
                this.importNodeTypes((ASTNode)exp, cuRewrite);
                constructorArguments.add(IntroduceParameterObjectRefactoring.this.moveNode((ASTNode)exp, rewrite));
            }
            return classCreation;
        }

        public Type createType(String newTypeName, int startPosition, CompilationUnitRewrite cuRewrite) {
            return IntroduceParameterObjectRefactoring.this.fParameterObjectFactory.createType(IntroduceParameterObjectRefactoring.this.fCreateAsTopLevel, cuRewrite, startPosition);
        }

        private boolean canReuseParameterObject(List invocationArguments, ParameterInfo addedInfo, List parameterInfos, MethodDeclaration enclosingMethod) {
            Assert.isNotNull((Object)enclosingMethod);
            List parameters = enclosingMethod.parameters();
            Iterator iter = parameterInfos.iterator();
            while (iter.hasNext()) {
                ParameterInfo pi = (ParameterInfo)iter.next();
                if (!IntroduceParameterObjectRefactoring.this.isValidField(pi)) continue;
                if (!pi.isInlined()) {
                    return false;
                }
                ASTNode node = (ASTNode)invocationArguments.get(pi.getOldIndex());
                if (IntroduceParameterObjectRefactoring.this.isParameter(pi, node, parameters, addedInfo.getNewName())) continue;
                return false;
            }
            return true;
        }

        private List computeVarargs(List invocationArguments, ParameterInfo varArgPI, boolean isLastParameter, CompilationUnitRewrite cuRewrite) {
            ArrayCreation creation;
            ITypeBinding arrayType;
            boolean isEmptyVarArg = varArgPI.getOldIndex() >= invocationArguments.size();
            ASTRewrite rewrite = cuRewrite.getASTRewrite();
            AST ast = cuRewrite.getAST();
            ASTNode lastNode = isEmptyVarArg ? null : (ASTNode)invocationArguments.get(varArgPI.getOldIndex());
            ArrayList<Object> constructorArguments = new ArrayList<Object>();
            if (lastNode instanceof ArrayCreation && (arrayType = (creation = (ArrayCreation)lastNode).resolveTypeBinding()) != null && arrayType.isAssignmentCompatible(varArgPI.getNewTypeBinding())) {
                constructorArguments.add(IntroduceParameterObjectRefactoring.this.moveNode((ASTNode)creation, rewrite));
                return constructorArguments;
            }
            if (isLastParameter) {
                int i = varArgPI.getOldIndex();
                while (i < invocationArguments.size()) {
                    ASTNode node = (ASTNode)invocationArguments.get(i);
                    this.importNodeTypes(node, cuRewrite);
                    constructorArguments.add(IntroduceParameterObjectRefactoring.this.moveNode(node, rewrite));
                    ++i;
                }
            } else if (lastNode instanceof NullLiteral) {
                NullLiteral nullLiteral = (NullLiteral)lastNode;
                constructorArguments.add(IntroduceParameterObjectRefactoring.this.moveNode((ASTNode)nullLiteral, rewrite));
            } else {
                creation = ast.newArrayCreation();
                creation.setType((ArrayType)this.importBinding(varArgPI.getNewTypeBinding(), cuRewrite));
                ArrayInitializer initializer = ast.newArrayInitializer();
                List expressions = initializer.expressions();
                int i = varArgPI.getOldIndex();
                while (i < invocationArguments.size()) {
                    ASTNode node = (ASTNode)invocationArguments.get(i);
                    this.importNodeTypes(node, cuRewrite);
                    expressions.add(IntroduceParameterObjectRefactoring.this.moveNode(node, rewrite));
                    ++i;
                }
                if (expressions.isEmpty()) {
                    creation.dimensions().add(ast.newNumberLiteral("0"));
                } else {
                    creation.setInitializer(initializer);
                }
                constructorArguments.add(creation);
            }
            return constructorArguments;
        }

        public Type importBinding(ITypeBinding newTypeBinding, CompilationUnitRewrite cuRewrite) {
            Type type = cuRewrite.getImportRewrite().addImport(newTypeBinding, cuRewrite.getAST());
            cuRewrite.getImportRemover().registerAddedImports(type);
            return type;
        }

        private void importNodeTypes(ASTNode node, CompilationUnitRewrite cuRewrite) {
            ASTResolving.visitAllBindings(node, new TypeBindingVisitor(this, cuRewrite){
                final /* synthetic */ ParameterObjectCreator this$1;
                private final /* synthetic */ CompilationUnitRewrite val$cuRewrite;
                {
                    this.this$1 = parameterObjectCreator;
                    this.val$cuRewrite = compilationUnitRewrite;
                }

                public boolean visit(ITypeBinding nodeBinding) {
                    this.this$1.importBinding(nodeBinding, this.val$cuRewrite);
                    return false;
                }
            });
        }
    }

    private final class RewriteParameterBody
    extends BodyUpdater {
        private boolean fParameterClassCreated = false;

        private RewriteParameterBody() {
        }

        public void updateBody(MethodDeclaration methodDeclaration, CompilationUnitRewrite cuRewrite, RefactoringStatus result) throws CoreException {
            IntroduceParameterObjectRefactoring.this.fParameterObjectFactory.createType(IntroduceParameterObjectRefactoring.this.fCreateAsTopLevel, cuRewrite, methodDeclaration.getStartPosition());
            if (cuRewrite.getCu().equals(IntroduceParameterObjectRefactoring.this.fCompilationUnit) && !this.fParameterClassCreated) {
                IntroduceParameterObjectRefactoring.this.createParameterClass(methodDeclaration, cuRewrite);
                this.fParameterClassCreated = true;
            }
            Block body = methodDeclaration.getBody();
            List parameters = methodDeclaration.parameters();
            if (body != null) {
                ASTRewrite rewriter = cuRewrite.getASTRewrite();
                ListRewrite bodyStatements = rewriter.getListRewrite((ASTNode)body, Block.STATEMENTS_PROPERTY);
                List managedParams = IntroduceParameterObjectRefactoring.this.getParameterInfos();
                Iterator iter = managedParams.iterator();
                while (iter.hasNext()) {
                    ParameterInfo pi = (ParameterInfo)iter.next();
                    if (!IntroduceParameterObjectRefactoring.this.isValidField(pi)) continue;
                    if (this.isReadOnly(pi, body, parameters, null)) {
                        body.accept(new ASTVisitor(this, false, rewriter, pi, parameters){
                            final /* synthetic */ RewriteParameterBody this$1;
                            private final /* synthetic */ ASTRewrite val$rewriter;
                            private final /* synthetic */ ParameterInfo val$pi;
                            private final /* synthetic */ List val$parameters;
                            {
                                this.this$1 = rewriteParameterBody;
                                this.val$rewriter = aSTRewrite;
                                this.val$pi = parameterInfo;
                                this.val$parameters = list;
                            }

                            public boolean visit(SimpleName node) {
                                RewriteParameterBody.access$0(this.this$1, this.val$rewriter, this.val$pi, node, this.val$parameters);
                                return false;
                            }
                        });
                        pi.setInlined(true);
                        continue;
                    }
                    ExpressionStatement initializer = IntroduceParameterObjectRefactoring.this.fParameterObjectFactory.createInitializer(pi, IntroduceParameterObjectRefactoring.this.getParameterName(), cuRewrite);
                    bodyStatements.insertFirst((ASTNode)initializer, null);
                }
            }
        }

        private void updateSimpleName(ASTRewrite rewriter, ParameterInfo pi, SimpleName node, List enclosingParameters) {
            AST ast = rewriter.getAST();
            IBinding binding = node.resolveBinding();
            Expression replacementNode = IntroduceParameterObjectRefactoring.this.fParameterObjectFactory.createFieldReadAccess(pi, IntroduceParameterObjectRefactoring.this.getParameterName(), ast);
            if (binding instanceof IVariableBinding) {
                IVariableBinding variable = (IVariableBinding)binding;
                if (variable.isParameter() && variable.getName().equals(IntroduceParameterObjectRefactoring.this.getNameInScope(pi, enclosingParameters))) {
                    rewriter.replace((ASTNode)node, (ASTNode)replacementNode, null);
                }
            } else {
                ASTNode parent = node.getParent();
                if (!(parent instanceof QualifiedName) && !(parent instanceof FieldAccess) && !(parent instanceof SuperFieldAccess) && node.getIdentifier().equals(IntroduceParameterObjectRefactoring.this.getNameInScope(pi, enclosingParameters))) {
                    rewriter.replace((ASTNode)node, (ASTNode)replacementNode, null);
                }
            }
        }

        private boolean isReadOnly(ParameterInfo pi, Block block, List enclosingMethodParameters, String qualifier) {
            class NotWrittenDetector
            extends ASTVisitor {
                boolean notWritten;
                final /* synthetic */ RewriteParameterBody this$1;
                private final /* synthetic */ ParameterInfo val$pi;
                private final /* synthetic */ List val$enclosingMethodParameters;
                private final /* synthetic */ String val$qualifier;

                NotWrittenDetector(RewriteParameterBody rewriteParameterBody, ParameterInfo parameterInfo, List list, String string) {
                    this.this$1 = rewriteParameterBody;
                    this.val$pi = parameterInfo;
                    this.val$enclosingMethodParameters = list;
                    this.val$qualifier = string;
                    this.notWritten = true;
                }

                public boolean visit(SimpleName node) {
                    if (IntroduceParameterObjectRefactoring.access$3(RewriteParameterBody.access$2(this.this$1), this.val$pi, (ASTNode)node, this.val$enclosingMethodParameters, this.val$qualifier) && ASTResolving.isWriteAccess((Name)node)) {
                        this.notWritten = false;
                    }
                    return false;
                }

                public boolean visit(SuperFieldAccess node) {
                    return false;
                }
            }
            NotWrittenDetector visitor = new NotWrittenDetector(this, pi, enclosingMethodParameters, qualifier);
            block.accept((ASTVisitor)visitor);
            return visitor.notWritten;
        }

        public boolean needsParameterUsedCheck() {
            return false;
        }

        static /* synthetic */ void access$0(RewriteParameterBody rewriteParameterBody, ASTRewrite aSTRewrite, ParameterInfo parameterInfo, SimpleName simpleName, List list) {
            rewriteParameterBody.updateSimpleName(aSTRewrite, parameterInfo, simpleName, list);
        }

        static /* synthetic */ IntroduceParameterObjectRefactoring access$2(RewriteParameterBody rewriteParameterBody) {
            return rewriteParameterBody.IntroduceParameterObjectRefactoring.this;
        }
    }
}

