/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.jarimport;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.filesystem.URIUtil;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaModel;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.filters.EmptyPackageFilter;
import org.eclipse.jdt.internal.ui.jarimport.JarImportData;
import org.eclipse.jdt.internal.ui.jarimport.JarImportMessages;
import org.eclipse.jdt.internal.ui.jarimport.JarImportWizard;
import org.eclipse.jdt.internal.ui.jarimport.RefactoringLocationControl;
import org.eclipse.jdt.internal.ui.jarpackager.JarPackagerUtil;
import org.eclipse.jdt.internal.ui.refactoring.binary.BinaryRefactoringHistoryWizard;
import org.eclipse.jdt.internal.ui.util.SWTUtil;
import org.eclipse.jdt.ui.JavaElementComparator;
import org.eclipse.jdt.ui.JavaElementLabelProvider;
import org.eclipse.jdt.ui.ProblemsLabelDecorator;
import org.eclipse.jdt.ui.StandardJavaElementContentProvider;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.ltk.core.refactoring.RefactoringCore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;

public final class JarImportWizardPage
extends WizardPage {
    private static final String PAGE_NAME = "JarImportWizardPage";
    protected static final String SETTING_HISTORY = "org.eclipse.jdt.ui.refactoring.jarHistory";
    private boolean fFirstTime = true;
    private final boolean fImportWizard;
    private RefactoringLocationControl fLocationControl = null;
    private TreeViewer fTreeViewer = null;
    private final JarImportWizard fWizard;

    public JarImportWizardPage(JarImportWizard wizard, boolean importWizard) {
        super(PAGE_NAME);
        Assert.isNotNull((Object)((Object)wizard));
        this.fWizard = wizard;
        this.fImportWizard = importWizard;
        if (this.fImportWizard) {
            this.setTitle(JarImportMessages.JarImportWizardPage_page_title);
            this.setDescription(JarImportMessages.JarImportWizardPage_page_description);
        } else {
            this.setTitle(JarImportMessages.JarImportWizardPage_page_replace_title);
            this.setDescription(JarImportMessages.JarImportWizardPage_page_replace_description);
        }
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(272));
        this.createLocationGroup(composite);
        if (this.fImportWizard) {
            this.createInputGroup(composite);
        }
        this.createRenameGroup(composite);
        this.setPageComplete(false);
        if (this.fImportWizard && !this.fTreeViewer.getControl().isEnabled()) {
            this.setMessage(JarImportMessages.JarImportWizardPage_no_jar_files, 1);
        }
        this.setControl((Control)composite);
        Dialog.applyDialogFont((Control)composite);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.jdt.ui.jar_import_wizard_page_context");
    }

    protected GridData createGridData(int flag, int hspan, int indent) {
        GridData data = new GridData(flag);
        data.horizontalIndent = indent;
        data.horizontalSpan = hspan;
        return data;
    }

    protected void createInputGroup(Composite parent) {
        Assert.isNotNull((Object)parent);
        new Label(parent, 0);
        Label label = new Label(parent, 0);
        label.setText(JarImportMessages.JarImportWizardPage_import_message);
        StandardJavaElementContentProvider contentProvider = new StandardJavaElementContentProvider(){

            public Object[] getChildren(Object element) {
                if (element instanceof IJavaProject || element instanceof IJavaModel) {
                    return super.getChildren(element);
                }
                return new Object[0];
            }

            protected Object[] getJavaProjects(IJavaModel model) throws JavaModelException {
                HashSet<IJavaProject> set = new HashSet<IJavaProject>();
                IJavaProject[] projects = model.getJavaProjects();
                int index = 0;
                while (index < projects.length) {
                    Object[] roots;
                    if (JarImportWizard.isValidJavaProject(projects[index]) && (roots = this.getPackageFragmentRoots(projects[index])).length > 0) {
                        set.add(projects[index]);
                    }
                    ++index;
                }
                return set.toArray();
            }

            protected Object[] getPackageFragmentRoots(IJavaProject project) throws JavaModelException {
                HashSet<IPackageFragmentRoot> set = new HashSet<IPackageFragmentRoot>();
                IPackageFragmentRoot[] roots = project.getPackageFragmentRoots();
                int offset = 0;
                while (offset < roots.length) {
                    if (JarImportWizard.isValidClassPathEntry(roots[offset].getRawClasspathEntry())) {
                        set.add(roots[offset]);
                    }
                    ++offset;
                }
                return set.toArray();
            }

            public boolean hasChildren(Object element) {
                return element instanceof IJavaProject || element instanceof IJavaModel;
            }
        };
        DecoratingLabelProvider labelProvider = new DecoratingLabelProvider((ILabelProvider)new JavaElementLabelProvider(272), (ILabelDecorator)new ProblemsLabelDecorator(null));
        this.fTreeViewer = new TreeViewer(parent, 2052);
        this.fTreeViewer.getTree().setLayoutData((Object)this.createGridData(1808, 6, 0));
        this.fTreeViewer.setLabelProvider((IBaseLabelProvider)labelProvider);
        this.fTreeViewer.setContentProvider((IContentProvider)contentProvider);
        this.fTreeViewer.addFilter((ViewerFilter)new EmptyPackageFilter());
        this.fTreeViewer.setComparator((ViewerComparator)new JavaElementComparator());
        this.fTreeViewer.setAutoExpandLevel(2);
        this.fTreeViewer.setInput((Object)JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot()));
        IPackageFragmentRoot root = this.fWizard.getPackageFragmentRoot();
        if (root != null) {
            this.fTreeViewer.setSelection((ISelection)new StructuredSelection(new Object[]{root}), true);
            this.fTreeViewer.expandToLevel((Object)root, 1);
        }
        this.fTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                JarImportWizardPage.this.handleInputChanged();
            }
        });
        if (contentProvider.getChildren(JavaCore.create((IWorkspaceRoot)ResourcesPlugin.getWorkspace().getRoot())).length == 0) {
            this.fTreeViewer.getControl().setEnabled(false);
            label.setEnabled(false);
        }
    }

    protected void createLocationGroup(Composite parent) {
        Assert.isNotNull((Object)parent);
        new Label(parent, 0).setText(JarImportMessages.JarImportWizardPage_import_label);
        Composite composite = new Composite(parent, 0);
        composite.setLayoutData((Object)this.createGridData(768, 6, 0));
        composite.setLayout((Layout)new GridLayout(3, false));
        Label label = new Label(composite, 0);
        label.setText(JarImportMessages.JarImportWizardPage_location_label);
        label.setLayoutData((Object)this.createGridData(32, 1, 0));
        this.fLocationControl = new RefactoringLocationControl((IWizard)this.fWizard, composite, SETTING_HISTORY);
        this.fLocationControl.setLayoutData(this.createGridData(768, 1, 0));
        this.fLocationControl.loadHistory();
        this.fLocationControl.getControl().addModifyListener(new ModifyListener(){

            public final void modifyText(ModifyEvent event) {
                JarImportWizardPage.this.handleInputChanged();
            }
        });
        this.fLocationControl.getControl().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public final void widgetSelected(SelectionEvent event) {
                JarImportWizardPage.this.handleInputChanged();
            }
        });
        this.fLocationControl.setFocus();
        Button button = new Button(composite, 8);
        button.setText(JarImportMessages.JarImportWizardPage_browse_button_label);
        button.setLayoutData((Object)this.createGridData(256, 1, 0));
        SWTUtil.setButtonDimensionHint(button);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public final void widgetSelected(SelectionEvent event) {
                JarImportWizardPage.this.handleBrowseButtonSelected();
            }
        });
    }

    protected void createRenameGroup(Composite parent) {
        Assert.isNotNull((Object)parent);
        final JarImportData data = this.fWizard.getImportData();
        final Button button = new Button(parent, 32);
        button.setText(JarImportMessages.JarImportWizardPage_replace_jar_file);
        button.setSelection(!data.isRenameJarFile());
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                data.setRenameJarFile(!button.getSelection());
            }
        });
        if (this.fImportWizard && !this.fTreeViewer.getControl().isEnabled()) {
            button.setEnabled(false);
        }
        if (!this.fImportWizard) {
            GridData gd = new GridData();
            gd.horizontalIndent = 7;
            button.setLayoutData((Object)gd);
        }
    }

    protected void handleBrowseButtonSelected() {
        FileDialog file = new FileDialog(this.getShell(), 4096);
        file.setText(JarImportMessages.JarImportWizardPage_browse_caption);
        file.setFilterNames(new String[]{"*.jar", "*.*"});
        file.setFilterExtensions(new String[]{"*.jar", "*.*"});
        String path = file.open();
        if (path != null) {
            this.fLocationControl.setText(path);
            this.handleInputChanged();
        }
    }

    protected void handleInputChanged() {
        JarImportData data = this.fWizard.getImportData();
        data.setRefactoringHistory(null);
        data.setRefactoringFileLocation(null);
        this.setErrorMessage(null);
        this.setMessage(null, 0);
        this.setPageComplete(true);
        this.handleJarFileChanged();
        if (this.isPageComplete()) {
            this.handlePackageFragmentRootChanged();
        }
        if (this.fImportWizard && !this.fTreeViewer.getControl().isEnabled()) {
            this.setErrorMessage(JarImportMessages.JarImportWizardPage_no_jar_files);
        }
        this.fFirstTime = false;
        this.getContainer().updateButtons();
    }

    /*
     * Unable to fully structure code
     */
    protected void handleJarFileChanged() {
        block33: {
            if (this.fLocationControl == null) break block33;
            path = this.fLocationControl.getText();
            if ("".equals(path)) {
                this.setErrorMessage(JarImportMessages.JarImportWizardPage_empty_location);
                this.setPageComplete(false);
                return;
            }
            file = new File(path);
            if (!file.exists()) {
                this.setErrorMessage(JarImportMessages.JarImportWizardPage_invalid_location);
                this.setPageComplete(false);
                return;
            }
            zip = null;
            try {
                zip = new ZipFile(file, 1);
            }
            catch (IOException v0) {
                this.setErrorMessage(JarImportMessages.JarImportWizardPage_invalid_location);
                this.setPageComplete(false);
lbl20:
                // 5 sources

                while (true) {
                    if (zip != null) {
                        try {
                            zip.close();
                        }
                        catch (IOException v1) {}
                    }
                    return;
                }
            }
            try {
                block35: {
                    block34: {
                        data = this.fWizard.getImportData();
                        data.setRefactoringFileLocation(URIUtil.toURI((String)path));
                        entry = zip.getEntry(JarPackagerUtil.getRefactoringsEntry());
                        if (entry != null) break block34;
                        this.setMessage(JarImportMessages.JarImportWizardPage_no_refactorings, 1);
                        this.setPageComplete(true);
                        ** GOTO lbl20
                    }
                    this.handleTimeStampChanged();
                    if (data.getExistingTimeStamp() <= entry.getTime()) break block35;
                    this.setMessage(JarImportMessages.JarImportWizardPage_version_warning, 2);
                    this.setPageComplete(true);
                    ** GOTO lbl20
                }
                stream = null;
                try {
                    stream = zip.getInputStream(entry);
                    data.setRefactoringHistory(RefactoringCore.getHistoryService().readRefactoringHistory(stream, 589824));
                }
                catch (IOException v2) {
                    this.setErrorMessage(JarImportMessages.JarImportWizardPage_no_refactorings);
                    this.setPageComplete(false);
lbl51:
                    // 2 sources

                    while (true) {
                        if (stream == null) ** GOTO lbl20
                        try {
                            stream.close();
                        }
                        catch (IOException v3) {}
                        ** continue;
                        break;
                    }
                }
                catch (CoreException exception) {
                    try {
                        JavaPlugin.log(exception);
                        this.setErrorMessage(JarImportMessages.JarImportWizardPage_no_refactorings);
                        this.setPageComplete(false);
                        ** continue;
                    }
                    catch (Throwable var8_8) {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (IOException v4) {}
                        }
                        throw var8_8;
                    }
                }
                ** if (stream == null) goto lbl-1000
lbl-1000:
                // 1 sources

                {
                    try {
                        stream.close();
                    }
                    catch (IOException v5) {}
                }
lbl-1000:
                // 2 sources

                {
                }
            }
            catch (Throwable var9_9) {
                if (zip != null) {
                    try {
                        zip.close();
                    }
                    catch (IOException v6) {}
                }
                throw var9_9;
            }
            if (zip != null) {
                try {
                    zip.close();
                }
                catch (IOException v7) {}
            }
        }
    }

    protected void handlePackageFragmentRootChanged() {
        if (this.fTreeViewer != null) {
            IStructuredSelection selection = (IStructuredSelection)this.fTreeViewer.getSelection();
            Object[] elements = selection.toArray();
            if (elements.length != 1) {
                this.setErrorMessage(JarImportMessages.JarImportWizardPage_select_single_jar);
                this.setPageComplete(false);
                return;
            }
            JarImportData data = this.fWizard.getImportData();
            Object element = elements[0];
            if (element instanceof IPackageFragmentRoot) {
                data.setPackageFragmentRoot((IPackageFragmentRoot)element);
            } else if (element instanceof IPackageFragment) {
                data.setPackageFragmentRoot((IPackageFragmentRoot)((IJavaElement)element).getParent());
            } else {
                this.setErrorMessage(JarImportMessages.JarImportWizardPage_select_single_jar);
                this.setPageComplete(false);
            }
        }
    }

    protected void handleTimeStampChanged() {
        block17: {
            IPackageFragmentRoot root = this.fWizard.getPackageFragmentRoot();
            if (root != null) {
                try {
                    File file;
                    URI uri = BinaryRefactoringHistoryWizard.getLocationURI(root.getRawClasspathEntry());
                    if (uri == null || !(file = new File(uri)).exists()) break block17;
                    ZipFile zip = null;
                    try {
                        try {
                            zip = new ZipFile(file, 1);
                            ZipEntry entry = zip.getEntry(JarPackagerUtil.getRefactoringsEntry());
                            if (entry != null) {
                                this.fWizard.getImportData().setExistingTimeStamp(entry.getTime());
                            }
                        }
                        catch (IOException iOException) {
                            if (zip != null) {
                                try {
                                    zip.close();
                                }
                                catch (IOException iOException2) {}
                            }
                            break block17;
                        }
                    }
                    catch (Throwable throwable) {
                        if (zip != null) {
                            try {
                                zip.close();
                            }
                            catch (IOException iOException) {}
                        }
                        throw throwable;
                    }
                    if (zip != null) {
                        try {
                            zip.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                catch (CoreException exception) {
                    JavaPlugin.log(exception);
                }
            }
        }
    }

    public void performFinish() {
        this.fLocationControl.saveHistory();
    }

    public void setErrorMessage(String message) {
        if (!this.fFirstTime) {
            super.setErrorMessage(message);
        } else {
            this.setMessage(message, 0);
        }
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (visible) {
            this.handleInputChanged();
        }
    }
}

