/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.JarImportWizardAction;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.AddArchiveToBuildpathAction;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.AddFolderToBuildpathAction;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.AddLibraryToBuildpathAction;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.AddSelectedLibraryToBuildpathAction;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.ConfigureBuildPathAction;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.CreateLinkedSourceFolderAction;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.CreateSourceFolderAction;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.EditFilterAction;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.EditOutputFolderAction;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.ExcludeFromBuildpathAction;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.IncludeToBuildpathAction;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.newsourcepage.RemoveFromBuildpathAction;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.part.Page;
import org.eclipse.ui.texteditor.IUpdate;

public class GenerateBuildPathActionGroup
extends ActionGroup {
    public static final String MENU_ID = "org.eclipse.jdt.ui.buildpath.menu";
    public static final String GROUP_BUILDPATH = "buildpathGroup";
    public static final String GROUP_FILTER = "filterGroup";
    public static final String GROUP_CUSTOMIZE = "customizeGroup";
    private Action fNoActionAvailable = new NoActionAvailable();
    private IWorkbenchSite fSite;
    private List fActions;
    private String fGroupName = "group.reorganize";

    public GenerateBuildPathActionGroup(Page page) {
        this((IWorkbenchSite)page.getSite());
    }

    public GenerateBuildPathActionGroup(IViewPart part) {
        this((IWorkbenchSite)part.getSite());
    }

    private GenerateBuildPathActionGroup(IWorkbenchSite site) {
        this.fSite = site;
        this.fActions = new ArrayList();
        CreateLinkedSourceFolderAction addLinkedSourceFolderAction = new CreateLinkedSourceFolderAction(site);
        this.fActions.add(addLinkedSourceFolderAction);
        CreateSourceFolderAction addSourceFolderAction = new CreateSourceFolderAction(site);
        this.fActions.add(addSourceFolderAction);
        AddFolderToBuildpathAction addFolder = new AddFolderToBuildpathAction(site);
        this.fActions.add(addFolder);
        AddSelectedLibraryToBuildpathAction addSelectedLibrary = new AddSelectedLibraryToBuildpathAction(site);
        this.fActions.add(addSelectedLibrary);
        RemoveFromBuildpathAction remove = new RemoveFromBuildpathAction(site);
        this.fActions.add(remove);
        AddArchiveToBuildpathAction addArchive = new AddArchiveToBuildpathAction(site);
        this.fActions.add(addArchive);
        AddLibraryToBuildpathAction addLibrary = new AddLibraryToBuildpathAction(site);
        this.fActions.add(addLibrary);
        UpdateJarFileAction updateAction = new UpdateJarFileAction();
        this.fActions.add(updateAction);
        ExcludeFromBuildpathAction exclude = new ExcludeFromBuildpathAction(site);
        this.fActions.add(exclude);
        IncludeToBuildpathAction include = new IncludeToBuildpathAction(site);
        this.fActions.add(include);
        EditFilterAction editFilterAction = new EditFilterAction(site);
        this.fActions.add(editFilterAction);
        EditOutputFolderAction editOutput = new EditOutputFolderAction(site);
        this.fActions.add(editOutput);
        ConfigureBuildPathAction configure = new ConfigureBuildPathAction(site);
        this.fActions.add(configure);
        ISelectionProvider provider = this.fSite.getSelectionProvider();
        Iterator iter = this.fActions.iterator();
        while (iter.hasNext()) {
            Action action = (Action)iter.next();
            if (!(action instanceof ISelectionChangedListener)) continue;
            provider.addSelectionChangedListener((ISelectionChangedListener)action);
        }
    }

    public void fillActionBars(IActionBars actionBar) {
        super.fillActionBars(actionBar);
        this.setGlobalActionHandlers(actionBar);
    }

    public void fillContextMenu(IMenuManager menu) {
        super.fillContextMenu(menu);
        if (!this.canOperateOnSelection()) {
            return;
        }
        String menuText = ActionMessages.BuildPath_label;
        MenuManager subMenu = new MenuManager(menuText, MENU_ID);
        subMenu.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                GenerateBuildPathActionGroup.this.fillViewSubMenu(manager);
            }
        });
        subMenu.setRemoveAllWhenShown(true);
        subMenu.add((IAction)new ConfigureBuildPathAction(this.fSite));
        menu.appendToGroup(this.fGroupName, (IContributionItem)subMenu);
    }

    private void fillViewSubMenu(IMenuManager source) {
        int added = 0;
        int i = 0;
        Iterator iter = this.fActions.iterator();
        while (iter.hasNext()) {
            Action action = (Action)iter.next();
            if (action instanceof IUpdate) {
                ((IUpdate)action).update();
            }
            if (i == 2) {
                source.add((IContributionItem)new Separator(GROUP_BUILDPATH));
            } else if (i == 8) {
                source.add((IContributionItem)new Separator(GROUP_FILTER));
            } else if (i == 10) {
                source.add((IContributionItem)new Separator(GROUP_CUSTOMIZE));
            }
            added += this.addAction(source, (IAction)action);
            ++i;
        }
        if (added == 0) {
            source.add((IAction)this.fNoActionAvailable);
        }
    }

    private void setGlobalActionHandlers(IActionBars actionBar) {
    }

    private int addAction(IMenuManager menu, IAction action) {
        if (action != null && action.isEnabled()) {
            menu.add(action);
            return 1;
        }
        return 0;
    }

    private boolean canOperateOnSelection() {
        ISelection sel = this.fSite.getSelectionProvider().getSelection();
        if (!(sel instanceof IStructuredSelection)) {
            return false;
        }
        IStructuredSelection selection = (IStructuredSelection)sel;
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!(element instanceof IWorkingSet)) continue;
            return false;
        }
        return true;
    }

    public void dispose() {
        if (this.fActions != null) {
            ISelectionProvider provider = this.fSite.getSelectionProvider();
            Iterator iter = this.fActions.iterator();
            while (iter.hasNext()) {
                Action action = (Action)iter.next();
                if (!(action instanceof ISelectionChangedListener)) continue;
                provider.removeSelectionChangedListener((ISelectionChangedListener)action);
            }
        }
        this.fActions = null;
        super.dispose();
    }

    private static class NoActionAvailable
    extends Action {
        public NoActionAvailable() {
            this.setEnabled(false);
            this.setText(NewWizardMessages.GenerateBuildPathActionGroup_no_action_available);
        }
    }

    private class UpdateJarFileAction
    extends JarImportWizardAction
    implements IUpdate {
        public UpdateJarFileAction() {
            this.setText(ActionMessages.GenerateBuildPathActionGroup_update_jar_text);
            this.setDescription(ActionMessages.GenerateBuildPathActionGroup_update_jar_description);
            this.setToolTipText(ActionMessages.GenerateBuildPathActionGroup_update_jar_tooltip);
            this.setImageDescriptor(JavaPluginImages.DESC_OBJS_JAR);
            PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.jar_import_wizard_page_context");
        }

        public void update() {
            IWorkbenchPart part = GenerateBuildPathActionGroup.this.fSite.getPage().getActivePart();
            if (part != null) {
                this.setActivePart((IAction)this, part);
            }
            this.selectionChanged((IAction)this, GenerateBuildPathActionGroup.this.fSite.getSelectionProvider().getSelection());
        }
    }
}

