/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.ui.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.corext.util.Messages;
import org.eclipse.jdt.internal.corext.util.MethodOverrideTester;
import org.eclipse.jdt.internal.corext.util.SuperTypeHierarchyCache;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.actions.SelectionConverter;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;

public class OpenSuperImplementationAction
extends SelectionDispatchAction {
    private JavaEditor fEditor;

    public OpenSuperImplementationAction(IWorkbenchSite site) {
        super(site);
        this.setText(ActionMessages.OpenSuperImplementationAction_label);
        this.setDescription(ActionMessages.OpenSuperImplementationAction_description);
        this.setToolTipText(ActionMessages.OpenSuperImplementationAction_tooltip);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((IAction)this, "org.eclipse.jdt.ui.open_super_implementation_action");
    }

    public OpenSuperImplementationAction(IWorkbenchSite site, ISelectionProvider provider) {
        this(site);
        this.setSpecialSelectionProvider(provider);
    }

    public OpenSuperImplementationAction(JavaEditor editor) {
        this((IWorkbenchSite)editor.getEditorSite());
        this.fEditor = editor;
        this.setEnabled(SelectionConverter.canOperateOn(this.fEditor));
    }

    public void selectionChanged(ITextSelection selection) {
    }

    public void selectionChanged(IStructuredSelection selection) {
        IMethod method = this.getMethod(selection);
        this.setEnabled(method != null && this.checkMethod(method));
    }

    public void run(ITextSelection selection) {
        if (!ActionUtil.isProcessable(this.fEditor)) {
            return;
        }
        IJavaElement element = this.elementAtOffset();
        if (element == null || !(element instanceof IMethod)) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)OpenSuperImplementationAction.getDialogTitle(), (String)ActionMessages.OpenSuperImplementationAction_not_applicable);
            return;
        }
        this.run((IMethod)element);
    }

    public void run(IStructuredSelection selection) {
        this.run(this.getMethod(selection));
    }

    public void run(IMethod method) {
        if (method == null) {
            return;
        }
        if (!ActionUtil.isProcessable(this.getShell(), (IJavaElement)method)) {
            return;
        }
        if (!this.checkMethod(method)) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)OpenSuperImplementationAction.getDialogTitle(), (String)Messages.format(ActionMessages.OpenSuperImplementationAction_no_super_implementation, method.getElementName()));
            return;
        }
        try {
            IMethod impl = this.findSuperImplementation(method);
            if (impl != null) {
                JavaUI.openInEditor((IJavaElement)impl, true, true);
            }
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, OpenSuperImplementationAction.getDialogTitle(), ActionMessages.OpenSuperImplementationAction_error_message);
        }
    }

    private IMethod findSuperImplementation(IMethod method) throws JavaModelException {
        MethodOverrideTester tester = SuperTypeHierarchyCache.getMethodOverrideTester(method.getDeclaringType());
        return tester.findOverriddenMethod(method, false);
    }

    private IMethod getMethod(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return null;
        }
        Object element = selection.getFirstElement();
        if (element instanceof IMethod) {
            return (IMethod)element;
        }
        return null;
    }

    private boolean checkMethod(IMethod method) {
        block3: {
            try {
                int flags = method.getFlags();
                if (!Flags.isStatic((int)flags) && !Flags.isPrivate((int)flags)) {
                    IType declaringType = method.getDeclaringType();
                    return !SuperTypeHierarchyCache.hasInCache(declaringType) || this.findSuperImplementation(method) != null;
                }
            }
            catch (JavaModelException e) {
                if (e.isDoesNotExist()) break block3;
                JavaPlugin.log(e);
            }
        }
        return false;
    }

    private IJavaElement elementAtOffset() {
        try {
            return SelectionConverter.getElementAtOffset(this.fEditor);
        }
        catch (JavaModelException javaModelException) {
            return null;
        }
    }

    private static String getDialogTitle() {
        return ActionMessages.OpenSuperImplementationAction_error_title;
    }
}

