/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.spdy.server;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.net.ssl.SSLEngine;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.server.AbstractConnectionFactory;
import org.eclipse.jetty.server.Connector;

public abstract class NegotiatingServerConnectionFactory
extends AbstractConnectionFactory {
    private final List<String> protocols;
    private String defaultProtocol;

    public NegotiatingServerConnectionFactory(String protocol, String ... protocols) {
        super(protocol);
        this.protocols = Arrays.asList(protocols);
    }

    public String getDefaultProtocol() {
        return this.defaultProtocol;
    }

    public void setDefaultProtocol(String defaultProtocol) {
        this.defaultProtocol = defaultProtocol;
    }

    public List<String> getProtocols() {
        return this.protocols;
    }

    @Override
    public Connection newConnection(Connector connector, EndPoint endPoint) {
        String dft;
        List<String> protocols = this.protocols;
        if (protocols.isEmpty()) {
            protocols = connector.getProtocols();
            Iterator<String> i = protocols.iterator();
            while (i.hasNext()) {
                String prefix;
                String protocol = i.next();
                if (!protocol.regionMatches(true, 0, prefix = "ssl-", 0, prefix.length()) && !protocol.equalsIgnoreCase("alpn")) continue;
                i.remove();
            }
        }
        if ((dft = this.defaultProtocol) == null && !protocols.isEmpty()) {
            dft = protocols.get(0);
        }
        SSLEngine engine = null;
        EndPoint ep = endPoint;
        while (engine == null && ep != null) {
            if (ep instanceof SslConnection.DecryptedEndPoint) {
                engine = ((SslConnection.DecryptedEndPoint)ep).getSslConnection().getSSLEngine();
                continue;
            }
            ep = null;
        }
        return this.configure(this.newServerConnection(connector, endPoint, engine, protocols, dft), connector, endPoint);
    }

    protected abstract AbstractConnection newServerConnection(Connector var1, EndPoint var2, SSLEngine var3, List<String> var4, String var5);

    @Override
    public String toString() {
        return String.format("%s@%x{%s,%s,%s}", this.getClass().getSimpleName(), this.hashCode(), this.getProtocol(), this.getDefaultProtocol(), this.getProtocols());
    }
}

