/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.jsr356.client;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.websocket.ClientEndpoint;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.Decoder;
import javax.websocket.Encoder;
import javax.websocket.Extension;
import org.eclipse.jetty.websocket.api.InvalidWebSocketException;
import org.eclipse.jetty.websocket.jsr356.client.EmptyConfigurator;

public class AnnotatedClientEndpointConfig
implements ClientEndpointConfig {
    private final List<Class<? extends Decoder>> decoders;
    private final List<Class<? extends Encoder>> encoders;
    private final List<Extension> extensions;
    private final List<String> preferredSubprotocols;
    private final ClientEndpointConfig.Configurator configurator;
    private Map<String, Object> userProperties;

    public AnnotatedClientEndpointConfig(ClientEndpoint anno) {
        this.decoders = Collections.unmodifiableList(Arrays.asList(anno.decoders()));
        this.encoders = Collections.unmodifiableList(Arrays.asList(anno.encoders()));
        this.preferredSubprotocols = Collections.unmodifiableList(Arrays.asList(anno.subprotocols()));
        this.extensions = Collections.emptyList();
        this.userProperties = new HashMap<String, Object>();
        if (anno.configurator() == null) {
            this.configurator = EmptyConfigurator.INSTANCE;
        } else {
            try {
                this.configurator = (ClientEndpointConfig.Configurator)anno.configurator().newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                StringBuilder err = new StringBuilder();
                err.append("Unable to instantiate ClientEndpoint.configurator() of ");
                err.append(anno.configurator().getName());
                err.append(" defined as annotation in ");
                err.append(anno.getClass().getName());
                throw new InvalidWebSocketException(err.toString(), e);
            }
        }
    }

    public ClientEndpointConfig.Configurator getConfigurator() {
        return this.configurator;
    }

    public List<Class<? extends Decoder>> getDecoders() {
        return this.decoders;
    }

    public List<Class<? extends Encoder>> getEncoders() {
        return this.encoders;
    }

    public List<Extension> getExtensions() {
        return this.extensions;
    }

    public List<String> getPreferredSubprotocols() {
        return this.preferredSubprotocols;
    }

    public Map<String, Object> getUserProperties() {
        return this.userProperties;
    }
}

