/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import java.io.IOException;
import java.util.regex.Matcher;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.rewrite.handler.RedirectUtil;
import org.eclipse.jetty.rewrite.handler.RegexRule;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.annotation.Name;

public class RedirectRegexRule
extends RegexRule {
    protected String _location;
    private int _statusCode = 302;

    public RedirectRegexRule() {
        this(null, null);
    }

    public RedirectRegexRule(@Name(value="regex") String regex, @Name(value="location") String location) {
        super(regex);
        this.setHandling(true);
        this.setTerminating(true);
        this.setLocation(location);
    }

    @Deprecated
    public void setReplacement(String replacement) {
        this.setLocation(replacement);
    }

    public void setLocation(String location) {
        this._location = location;
    }

    public void setStatusCode(int statusCode) {
        if (statusCode < 300 || statusCode > 399) {
            throw new IllegalArgumentException("Invalid redirect status code " + statusCode + " (must be a value between 300 and 399)");
        }
        this._statusCode = statusCode;
    }

    @Override
    protected String apply(String target, HttpServletRequest request, HttpServletResponse response, Matcher matcher) throws IOException {
        target = this._location;
        for (int g = 1; g <= matcher.groupCount(); ++g) {
            String group = matcher.group(g);
            target = StringUtil.replace(target, "$" + g, group);
        }
        target = response.encodeRedirectURL(target);
        response.setHeader("Location", RedirectUtil.toRedirectURL(request, target));
        response.setStatus(this._statusCode);
        response.getOutputStream().flush();
        response.getOutputStream().close();
        return target;
    }

    @Override
    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append(super.toString());
        str.append('[').append(this._statusCode);
        str.append('>').append(this._location);
        str.append(']');
        return str.toString();
    }
}

