/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.rewrite.handler;

import java.io.IOException;
import java.util.regex.Matcher;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.rewrite.handler.RegexRule;
import org.eclipse.jetty.rewrite.handler.Rule;
import org.eclipse.jetty.server.Request;

public class RewriteRegexRule
extends RegexRule
implements Rule.ApplyURI {
    private String _replacement;

    public RewriteRegexRule() {
        this._handling = false;
        this._terminating = false;
    }

    public void setReplacement(String replacement) {
        this._replacement = replacement;
    }

    public String apply(String target, HttpServletRequest request, HttpServletResponse response, Matcher matcher) throws IOException {
        target = this._replacement;
        for (int g = 1; g <= matcher.groupCount(); ++g) {
            String group = matcher.group(g);
            target = target.replaceAll("\\$" + g, group);
        }
        return target;
    }

    public void applyURI(Request request, String oldTarget, String newTarget) throws IOException {
        Matcher matcher = this._regex.matcher(request.getRequestURI());
        boolean matches = matcher.matches();
        if (matches) {
            String uri = this._replacement;
            for (int g = 1; g <= matcher.groupCount(); ++g) {
                String group = matcher.group(g);
                uri = uri.replaceAll("\\$" + g, group);
            }
            request.setRequestURI(uri);
        } else {
            request.setRequestURI(newTarget);
        }
    }

    public String toString() {
        return super.toString() + "[" + this._replacement + "]";
    }
}

