/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.io.AbstractConnection;
import org.eclipse.jetty.io.AsyncEndPoint;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.ByteArrayBuffer;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.nio.SelectChannelEndPoint;
import org.eclipse.jetty.util.B64Code;
import org.eclipse.jetty.util.Utf8StringBuilder;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.websocket.Extension;
import org.eclipse.jetty.websocket.MaskGen;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketBuffers;
import org.eclipse.jetty.websocket.WebSocketConnection;
import org.eclipse.jetty.websocket.WebSocketGenerator;
import org.eclipse.jetty.websocket.WebSocketGeneratorD08;
import org.eclipse.jetty.websocket.WebSocketParser;
import org.eclipse.jetty.websocket.WebSocketParserD08;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebSocketConnectionD08
extends AbstractConnection
implements WebSocketConnection {
    private static final Logger LOG = Log.getLogger(WebSocketConnectionD08.class);
    static final byte OP_CONTINUATION = 0;
    static final byte OP_TEXT = 1;
    static final byte OP_BINARY = 2;
    static final byte OP_EXT_DATA = 3;
    static final byte OP_CONTROL = 8;
    static final byte OP_CLOSE = 8;
    static final byte OP_PING = 9;
    static final byte OP_PONG = 10;
    static final byte OP_EXT_CTRL = 11;
    static final int CLOSE_NORMAL = 1000;
    static final int CLOSE_SHUTDOWN = 1001;
    static final int CLOSE_PROTOCOL = 1002;
    static final int CLOSE_BADDATA = 1003;
    static final int CLOSE_NOCODE = 1005;
    static final int CLOSE_NOCLOSE = 1006;
    static final int CLOSE_NOTUTF8 = 1007;
    static final int FLAG_FIN = 8;
    static final int VERSION = 8;
    private static final byte[] MAGIC;
    private final IdleCheck _idle;
    private final List<Extension> _extensions;
    private final WebSocketParserD08 _parser;
    private final WebSocketParser.FrameHandler _inbound;
    private final WebSocketGeneratorD08 _generator;
    private final WebSocketGenerator _outbound;
    private final WebSocket _webSocket;
    private final WebSocket.OnFrame _onFrame;
    private final WebSocket.OnBinaryMessage _onBinaryMessage;
    private final WebSocket.OnTextMessage _onTextMessage;
    private final WebSocket.OnControl _onControl;
    private final String _protocol;
    private final int _draft;
    private final ClassLoader _context;
    private volatile int _closeCode;
    private volatile String _closeMessage;
    private volatile boolean _closedIn;
    private volatile boolean _closedOut;
    private int _maxTextMessageSize = -1;
    private int _maxBinaryMessageSize = -1;
    private final WebSocketParser.FrameHandler _frameHandler = new WSFrameHandler();
    private final WebSocket.FrameConnection _connection = new WSFrameConnection();

    static boolean isLastFrame(byte flags) {
        return (flags & 8) != 0;
    }

    static boolean isControlFrame(byte opcode) {
        return (opcode & 8) != 0;
    }

    public WebSocketConnectionD08(WebSocket websocket, EndPoint endpoint, WebSocketBuffers buffers, long timestamp, int maxIdleTime, String protocol, List<Extension> extensions, int draft) throws IOException {
        this(websocket, endpoint, buffers, timestamp, maxIdleTime, protocol, extensions, draft, null);
    }

    public WebSocketConnectionD08(WebSocket websocket, EndPoint endpoint, WebSocketBuffers buffers, long timestamp, int maxIdleTime, String protocol, List<Extension> extensions, int draft, MaskGen maskgen) throws IOException {
        super(endpoint, timestamp);
        this._context = Thread.currentThread().getContextClassLoader();
        if (endpoint instanceof AsyncEndPoint) {
            ((AsyncEndPoint)endpoint).cancelIdle();
        }
        this._draft = draft;
        this._endp.setMaxIdleTime(maxIdleTime);
        this._webSocket = websocket;
        this._onFrame = this._webSocket instanceof WebSocket.OnFrame ? (WebSocket.OnFrame)this._webSocket : null;
        this._onTextMessage = this._webSocket instanceof WebSocket.OnTextMessage ? (WebSocket.OnTextMessage)this._webSocket : null;
        this._onBinaryMessage = this._webSocket instanceof WebSocket.OnBinaryMessage ? (WebSocket.OnBinaryMessage)this._webSocket : null;
        this._onControl = this._webSocket instanceof WebSocket.OnControl ? (WebSocket.OnControl)this._webSocket : null;
        this._generator = new WebSocketGeneratorD08(buffers, this._endp, maskgen);
        this._extensions = extensions;
        if (this._extensions != null) {
            int e = 0;
            for (Extension extension : this._extensions) {
                extension.bind(this._connection, e == extensions.size() - 1 ? this._frameHandler : (WebSocketParser.FrameHandler)extensions.get(e + 1), e == 0 ? this._generator : (WebSocketGenerator)extensions.get(e - 1));
                ++e;
            }
        }
        this._outbound = this._extensions == null || this._extensions.size() == 0 ? this._generator : (WebSocketGenerator)extensions.get(extensions.size() - 1);
        this._inbound = this._extensions == null || this._extensions.size() == 0 ? this._frameHandler : (WebSocketParser.FrameHandler)extensions.get(0);
        this._parser = new WebSocketParserD08(buffers, endpoint, this._inbound, maskgen == null);
        this._protocol = protocol;
        if (this._endp instanceof SelectChannelEndPoint) {
            final SelectChannelEndPoint scep = (SelectChannelEndPoint)this._endp;
            scep.cancelIdle();
            this._idle = new IdleCheck(){

                public void access(EndPoint endp) {
                    scep.scheduleIdle();
                }
            };
            scep.scheduleIdle();
        } else {
            this._idle = new IdleCheck(){

                public void access(EndPoint endp) {
                }
            };
        }
    }

    @Override
    public WebSocket.Connection getConnection() {
        return this._connection;
    }

    @Override
    public List<Extension> getExtensions() {
        if (this._extensions == null) {
            return Collections.emptyList();
        }
        return this._extensions;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Connection handle() throws IOException {
        block11: {
            Thread current = Thread.currentThread();
            ClassLoader oldcontext = current.getContextClassLoader();
            current.setContextClassLoader(this._context);
            try {
                try {
                    boolean progress = true;
                    while (progress) {
                        int flushed = this._generator.flushBuffer();
                        int filled = this._parser.parseNext();
                        boolean bl = progress = flushed > 0 || filled > 0;
                        if (filled >= 0 && flushed >= 0) continue;
                        this._endp.close();
                        break;
                    }
                    Object var7_8 = null;
                    current.setContextClassLoader(oldcontext);
                    this._parser.returnBuffer();
                    this._generator.returnBuffer();
                    if (!this._endp.isOpen()) return this;
                    this._idle.access(this._endp);
                    if (!this._closedIn || !this._closedOut || !this._outbound.isBufferEmpty()) break block11;
                }
                catch (IOException e) {
                    try {
                        this._endp.close();
                        throw e;
                    }
                    catch (IOException e2) {
                        LOG.ignore(e2);
                    }
                    throw e;
                }
            }
            catch (Throwable throwable) {
                Object var7_9 = null;
                current.setContextClassLoader(oldcontext);
                this._parser.returnBuffer();
                this._generator.returnBuffer();
                if (!this._endp.isOpen()) throw throwable;
                this._idle.access(this._endp);
                if (this._closedIn && this._closedOut && this._outbound.isBufferEmpty()) {
                    this._endp.close();
                    throw throwable;
                }
                if (this._endp.isInputShutdown() && !this._closedIn) {
                    this.closeIn(1006, null);
                    throw throwable;
                }
                this.checkWriteable();
                throw throwable;
            }
            this._endp.close();
            return this;
        }
        if (this._endp.isInputShutdown() && !this._closedIn) {
            this.closeIn(1006, null);
            return this;
        }
        this.checkWriteable();
        return this;
    }

    @Override
    public boolean isIdle() {
        return this._parser.isBufferEmpty() && this._outbound.isBufferEmpty();
    }

    @Override
    public void idleExpired() {
        long idle = System.currentTimeMillis() - ((SelectChannelEndPoint)this._endp).getIdleTimestamp();
        this.closeOut(1000, "Idle for " + idle + "ms > " + this._endp.getMaxIdleTime() + "ms");
    }

    @Override
    public boolean isSuspended() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void closed() {
        boolean closed;
        WebSocketConnectionD08 webSocketConnectionD08 = this;
        synchronized (webSocketConnectionD08) {
            boolean bl = closed = this._closeCode == 0;
            if (closed) {
                this._closeCode = 1006;
            }
        }
        if (closed) {
            this._webSocket.onClose(1006, "closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeIn(int code, String message) {
        block13: {
            boolean closed;
            boolean closedOut;
            LOG.debug("ClosedIn {} {}", this, message);
            WebSocketConnectionD08 webSocketConnectionD08 = this;
            synchronized (webSocketConnectionD08) {
                closedOut = this._closedOut;
                this._closedIn = true;
                boolean bl = closed = this._closeCode == 0;
                if (closed) {
                    this._closeCode = code;
                    this._closeMessage = message;
                }
            }
            try {
                if (closed) {
                    this._webSocket.onClose(code, message);
                }
                Object var8_7 = null;
            }
            catch (Throwable throwable) {
                Object var8_8 = null;
                try {
                    if (closedOut) {
                        this._endp.close();
                    } else {
                        this.closeOut(code, message);
                    }
                }
                catch (IOException e) {
                    LOG.ignore(e);
                }
                throw throwable;
            }
            try {
                if (closedOut) {
                    this._endp.close();
                    break block13;
                }
                this.closeOut(code, message);
            }
            catch (IOException e) {
                LOG.ignore(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeOut(int code, String message) {
        boolean closed;
        boolean close;
        LOG.debug("ClosedOut {} {}", this, message);
        WebSocketConnectionD08 webSocketConnectionD08 = this;
        synchronized (webSocketConnectionD08) {
            close = this._closedIn || this._closedOut;
            this._closedOut = true;
            boolean bl = closed = this._closeCode == 0;
            if (closed) {
                this._closeCode = code;
                this._closeMessage = message;
            }
        }
        try {
            if (closed) {
                this._webSocket.onClose(code, message);
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                if (close) {
                    this._endp.close();
                } else {
                    if (code <= 0) {
                        code = 1000;
                    }
                    byte[] bytes = ("xx" + (message == null ? "" : message)).getBytes("ISO-8859-1");
                    bytes[0] = (byte)(code / 256);
                    bytes[1] = (byte)(code % 256);
                    this._outbound.addFrame((byte)8, (byte)8, bytes, 0, bytes.length);
                }
                this._outbound.flush();
            }
            catch (IOException e) {
                LOG.ignore(e);
            }
            throw throwable;
        }
        try {
            if (close) {
                this._endp.close();
            } else {
                if (code <= 0) {
                    code = 1000;
                }
                byte[] bytes = ("xx" + (message == null ? "" : message)).getBytes("ISO-8859-1");
                bytes[0] = (byte)(code / 256);
                bytes[1] = (byte)(code % 256);
                this._outbound.addFrame((byte)8, (byte)8, bytes, 0, bytes.length);
            }
            this._outbound.flush();
        }
        catch (IOException e) {
            LOG.ignore(e);
        }
    }

    @Override
    public void fillBuffersFrom(Buffer buffer) {
        this._parser.fill(buffer);
    }

    private void checkWriteable() {
        if (!this._outbound.isBufferEmpty() && this._endp instanceof AsyncEndPoint) {
            ((AsyncEndPoint)this._endp).scheduleWrite();
        }
    }

    @Override
    public void handshake(HttpServletRequest request, HttpServletResponse response, String subprotocol) throws IOException {
        String key = request.getHeader("Sec-WebSocket-Key");
        response.setHeader("Upgrade", "WebSocket");
        response.addHeader("Connection", "Upgrade");
        response.addHeader("Sec-WebSocket-Accept", WebSocketConnectionD08.hashKey(key));
        if (subprotocol != null) {
            response.addHeader("Sec-WebSocket-Protocol", subprotocol);
        }
        for (Extension ext : this._extensions) {
            response.addHeader("Sec-WebSocket-Extensions", ext.getParameterizedName());
        }
        response.sendError(101);
        if (this._onFrame != null) {
            this._onFrame.onHandshake(this._connection);
        }
        this._webSocket.onOpen(this._connection);
    }

    public static String hashKey(String key) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(key.getBytes("UTF-8"));
            md.update(MAGIC);
            return new String(B64Code.encode(md.digest()));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String toString() {
        return "WS/D" + this._draft + "-" + this._endp;
    }

    static {
        try {
            MAGIC = "258EAFA5-E914-47DA-95CA-C5AB0DC85B11".getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    private static interface IdleCheck {
        public void access(EndPoint var1);
    }

    private class WSFrameHandler
    implements WebSocketParser.FrameHandler {
        private final Utf8StringBuilder _utf8 = new Utf8StringBuilder();
        private ByteArrayBuffer _aggregate;
        private byte _opcode = (byte)-1;

        private WSFrameHandler() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void onFrame(byte flags, byte opcode, Buffer buffer) {
            boolean lastFrame = WebSocketConnectionD08.isLastFrame(flags);
            WebSocketConnectionD08 webSocketConnectionD08 = WebSocketConnectionD08.this;
            synchronized (webSocketConnectionD08) {
                if (WebSocketConnectionD08.this._closedIn) {
                    return;
                }
            }
            try {
                byte[] array = buffer.array();
                if (WebSocketConnectionD08.this._onFrame != null && WebSocketConnectionD08.this._onFrame.onFrame(flags, opcode, array, buffer.getIndex(), buffer.length())) {
                    return;
                }
                if (WebSocketConnectionD08.this._onControl != null && WebSocketConnectionD08.isControlFrame(opcode) && WebSocketConnectionD08.this._onControl.onControl(opcode, array, buffer.getIndex(), buffer.length())) {
                    return;
                }
                switch (opcode) {
                    case 0: {
                        if (WebSocketConnectionD08.this._onTextMessage != null && this._opcode == 1) {
                            if (this._utf8.append(buffer.array(), buffer.getIndex(), buffer.length(), WebSocketConnectionD08.this._connection.getMaxTextMessageSize())) {
                                if (lastFrame) {
                                    this._opcode = (byte)-1;
                                    String msg = this._utf8.toString();
                                    this._utf8.reset();
                                    WebSocketConnectionD08.this._onTextMessage.onMessage(msg);
                                }
                            } else {
                                this.textMessageTooLarge();
                            }
                        }
                        if (this._opcode < 0 || WebSocketConnectionD08.this._connection.getMaxBinaryMessageSize() < 0 || !this.checkBinaryMessageSize(this._aggregate.length(), buffer.length())) return;
                        this._aggregate.put(buffer);
                        if (!lastFrame || WebSocketConnectionD08.this._onBinaryMessage == null) return;
                        try {
                            WebSocketConnectionD08.this._onBinaryMessage.onMessage(this._aggregate.array(), this._aggregate.getIndex(), this._aggregate.length());
                            return;
                        }
                        finally {
                            this._opcode = (byte)-1;
                            this._aggregate.clear();
                        }
                    }
                    case 9: {
                        LOG.debug("PING {}", this);
                        if (WebSocketConnectionD08.this._closedOut) return;
                        WebSocketConnectionD08.this._connection.sendControl((byte)10, buffer.array(), buffer.getIndex(), buffer.length());
                        return;
                    }
                    case 10: {
                        LOG.debug("PONG {}", this);
                        return;
                    }
                    case 8: {
                        int code = 1005;
                        String message = null;
                        if (buffer.length() >= 2) {
                            code = buffer.array()[buffer.getIndex()] * 256 + buffer.array()[buffer.getIndex() + 1];
                            if (buffer.length() > 2) {
                                message = new String(buffer.array(), buffer.getIndex() + 2, buffer.length() - 2, "UTF-8");
                            }
                        }
                        WebSocketConnectionD08.this.closeIn(code, message);
                        return;
                    }
                    case 1: {
                        if (WebSocketConnectionD08.this._onTextMessage == null) return;
                        if (WebSocketConnectionD08.this._connection.getMaxTextMessageSize() <= 0) {
                            if (lastFrame) {
                                WebSocketConnectionD08.this._onTextMessage.onMessage(buffer.toString("UTF-8"));
                                return;
                            }
                            LOG.warn("Frame discarded. Text aggregation disabled for {}", WebSocketConnectionD08.this._endp);
                            WebSocketConnectionD08.this._connection.close(1003, "Text frame aggregation disabled");
                            return;
                        }
                        if (this._utf8.append(buffer.array(), buffer.getIndex(), buffer.length(), WebSocketConnectionD08.this._connection.getMaxTextMessageSize())) {
                            if (lastFrame) {
                                String msg = this._utf8.toString();
                                this._utf8.reset();
                                WebSocketConnectionD08.this._onTextMessage.onMessage(msg);
                                return;
                            }
                            this._opcode = 1;
                            return;
                        }
                        this.textMessageTooLarge();
                        return;
                    }
                    default: {
                        if (WebSocketConnectionD08.this._onBinaryMessage == null || !this.checkBinaryMessageSize(0, buffer.length())) return;
                        if (lastFrame) {
                            WebSocketConnectionD08.this._onBinaryMessage.onMessage(array, buffer.getIndex(), buffer.length());
                            return;
                        }
                        if (WebSocketConnectionD08.this._connection.getMaxBinaryMessageSize() >= 0) {
                            this._opcode = opcode;
                            if (this._aggregate == null) {
                                this._aggregate = new ByteArrayBuffer(WebSocketConnectionD08.this._connection.getMaxBinaryMessageSize());
                            }
                            this._aggregate.put(buffer);
                            return;
                        }
                        LOG.warn("Frame discarded. Binary aggregation disabed for {}", WebSocketConnectionD08.this._endp);
                        WebSocketConnectionD08.this._connection.close(1003, "Binary frame aggregation disabled");
                    }
                }
                return;
            }
            catch (ThreadDeath th) {
                throw th;
            }
            catch (Throwable th) {
                LOG.warn(th);
            }
        }

        private boolean checkBinaryMessageSize(int bufferLen, int length) {
            int max = WebSocketConnectionD08.this._connection.getMaxBinaryMessageSize();
            if (max > 0 && bufferLen + length > max) {
                LOG.warn("Binary message too large > {}B for {}", WebSocketConnectionD08.this._connection.getMaxBinaryMessageSize(), WebSocketConnectionD08.this._endp);
                WebSocketConnectionD08.this._connection.close(1003, "Message size > " + WebSocketConnectionD08.this._connection.getMaxBinaryMessageSize());
                this._opcode = (byte)-1;
                if (this._aggregate != null) {
                    this._aggregate.clear();
                }
                return false;
            }
            return true;
        }

        private void textMessageTooLarge() {
            LOG.warn("Text message too large > {} chars for {}", WebSocketConnectionD08.this._connection.getMaxTextMessageSize(), WebSocketConnectionD08.this._endp);
            WebSocketConnectionD08.this._connection.close(1003, "Text message size > " + WebSocketConnectionD08.this._connection.getMaxTextMessageSize() + " chars");
            this._opcode = (byte)-1;
            this._utf8.reset();
        }

        public void close(int code, String message) {
            if (code != 1000) {
                LOG.warn("Close: " + code + " " + message, new Object[0]);
            }
            WebSocketConnectionD08.this._connection.close(code, message);
        }

        public String toString() {
            return WebSocketConnectionD08.this.toString() + "FH";
        }
    }

    private class WSFrameConnection
    implements WebSocket.FrameConnection {
        volatile boolean _disconnecting;

        private WSFrameConnection() {
        }

        public void sendMessage(String content) throws IOException {
            if (WebSocketConnectionD08.this._closedOut) {
                throw new IOException("closedOut " + WebSocketConnectionD08.this._closeCode + ":" + WebSocketConnectionD08.this._closeMessage);
            }
            byte[] data = content.getBytes("UTF-8");
            WebSocketConnectionD08.this._outbound.addFrame((byte)8, (byte)1, data, 0, data.length);
            WebSocketConnectionD08.this.checkWriteable();
            WebSocketConnectionD08.this._idle.access(WebSocketConnectionD08.this._endp);
        }

        public void sendMessage(byte[] content, int offset, int length) throws IOException {
            if (WebSocketConnectionD08.this._closedOut) {
                throw new IOException("closedOut " + WebSocketConnectionD08.this._closeCode + ":" + WebSocketConnectionD08.this._closeMessage);
            }
            WebSocketConnectionD08.this._outbound.addFrame((byte)8, (byte)2, content, offset, length);
            WebSocketConnectionD08.this.checkWriteable();
            WebSocketConnectionD08.this._idle.access(WebSocketConnectionD08.this._endp);
        }

        public void sendFrame(byte flags, byte opcode, byte[] content, int offset, int length) throws IOException {
            if (WebSocketConnectionD08.this._closedOut) {
                throw new IOException("closedOut " + WebSocketConnectionD08.this._closeCode + ":" + WebSocketConnectionD08.this._closeMessage);
            }
            WebSocketConnectionD08.this._outbound.addFrame(flags, opcode, content, offset, length);
            WebSocketConnectionD08.this.checkWriteable();
            WebSocketConnectionD08.this._idle.access(WebSocketConnectionD08.this._endp);
        }

        public void sendControl(byte ctrl, byte[] data, int offset, int length) throws IOException {
            if (WebSocketConnectionD08.this._closedOut) {
                throw new IOException("closedOut " + WebSocketConnectionD08.this._closeCode + ":" + WebSocketConnectionD08.this._closeMessage);
            }
            WebSocketConnectionD08.this._outbound.addFrame((byte)8, ctrl, data, offset, length);
            WebSocketConnectionD08.this.checkWriteable();
            WebSocketConnectionD08.this._idle.access(WebSocketConnectionD08.this._endp);
        }

        public boolean isMessageComplete(byte flags) {
            return WebSocketConnectionD08.isLastFrame(flags);
        }

        public boolean isOpen() {
            return WebSocketConnectionD08.this._endp != null && WebSocketConnectionD08.this._endp.isOpen();
        }

        public void close(int code, String message) {
            if (this._disconnecting) {
                return;
            }
            this._disconnecting = true;
            WebSocketConnectionD08.this.closeOut(code, message);
        }

        public void setMaxIdleTime(int ms) {
            try {
                WebSocketConnectionD08.this._endp.setMaxIdleTime(ms);
            }
            catch (IOException e) {
                LOG.warn(e);
            }
        }

        public void setMaxTextMessageSize(int size) {
            WebSocketConnectionD08.this._maxTextMessageSize = size;
        }

        public void setMaxBinaryMessageSize(int size) {
            WebSocketConnectionD08.this._maxBinaryMessageSize = size;
        }

        public int getMaxIdleTime() {
            return WebSocketConnectionD08.this._endp.getMaxIdleTime();
        }

        public int getMaxTextMessageSize() {
            return WebSocketConnectionD08.this._maxTextMessageSize;
        }

        public int getMaxBinaryMessageSize() {
            return WebSocketConnectionD08.this._maxBinaryMessageSize;
        }

        public String getProtocol() {
            return WebSocketConnectionD08.this._protocol;
        }

        public byte binaryOpcode() {
            return 2;
        }

        public byte textOpcode() {
            return 1;
        }

        public byte continuationOpcode() {
            return 0;
        }

        public byte finMask() {
            return 8;
        }

        public boolean isControl(byte opcode) {
            return WebSocketConnectionD08.isControlFrame(opcode);
        }

        public boolean isText(byte opcode) {
            return opcode == 1;
        }

        public boolean isBinary(byte opcode) {
            return opcode == 2;
        }

        public boolean isContinuation(byte opcode) {
            return opcode == 0;
        }

        public boolean isClose(byte opcode) {
            return opcode == 8;
        }

        public boolean isPing(byte opcode) {
            return opcode == 9;
        }

        public boolean isPong(byte opcode) {
            return opcode == 10;
        }

        public void disconnect() {
            this.close(1000, null);
        }

        public void setAllowFrameFragmentation(boolean allowFragmentation) {
            WebSocketConnectionD08.this._parser.setFakeFragments(allowFragmentation);
        }

        public boolean isAllowFrameFragmentation() {
            return WebSocketConnectionD08.this._parser.isFakeFragments();
        }

        public String toString() {
            return this.getClass().getSimpleName() + "D08@" + WebSocketConnectionD08.this._endp.getLocalAddr() + ":" + WebSocketConnectionD08.this._endp.getLocalPort() + "<->" + WebSocketConnectionD08.this._endp.getRemoteAddr() + ":" + WebSocketConnectionD08.this._endp.getRemotePort();
        }
    }
}

