/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket;

import java.io.IOException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.websocket.MaskGen;
import org.eclipse.jetty.websocket.WebSocketBuffers;
import org.eclipse.jetty.websocket.WebSocketConnectionD08;
import org.eclipse.jetty.websocket.WebSocketGenerator;

public class WebSocketGeneratorD08
implements WebSocketGenerator {
    private final Lock _lock = new ReentrantLock();
    private final WebSocketBuffers _buffers;
    private final EndPoint _endp;
    private final byte[] _mask = new byte[4];
    private final MaskGen _maskGen;
    private Buffer _buffer;
    private int _m;
    private boolean _opsent;
    private boolean _closed;

    public WebSocketGeneratorD08(WebSocketBuffers buffers, EndPoint endp) {
        this(buffers, endp, null);
    }

    public WebSocketGeneratorD08(WebSocketBuffers buffers, EndPoint endp, MaskGen maskGen) {
        this._buffers = buffers;
        this._endp = endp;
        this._maskGen = maskGen;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Buffer getBuffer() {
        this._lock.lock();
        try {
            Buffer buffer = this._buffer;
            return buffer;
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFrame(byte flags, byte opcode, byte[] content, int offset, int length) throws IOException {
        this._lock.lock();
        try {
            int payload;
            boolean mask;
            if (this._closed) {
                throw new EofException("Closed");
            }
            if (opcode == 8) {
                this._closed = true;
            }
            boolean bl = mask = this._maskGen != null;
            if (this._buffer == null) {
                this._buffer = mask ? this._buffers.getBuffer() : this._buffers.getDirectBuffer();
            }
            boolean last = WebSocketConnectionD08.isLastFrame(flags);
            int space = mask ? 14 : 10;
            do {
                int chunk;
                opcode = this._opsent ? (byte)0 : opcode;
                opcode = (byte)(((0xF & flags) << 4) + (0xF & opcode));
                this._opsent = true;
                payload = length;
                if (payload + space > this._buffer.capacity()) {
                    opcode = (byte)(opcode & 0x7F);
                    payload = this._buffer.capacity() - space;
                } else if (last) {
                    opcode = (byte)(opcode | 0x80);
                }
                if (this._buffer.space() <= space) {
                    this.flushBuffer();
                    if (this._buffer.space() <= space) {
                        this.flush();
                    }
                }
                if (payload > 65535) {
                    this._buffer.put(new byte[]{opcode, mask ? (byte)-1 : 127, 0, 0, 0, 0, (byte)(payload >> 24 & 0xFF), (byte)(payload >> 16 & 0xFF), (byte)(payload >> 8 & 0xFF), (byte)(payload & 0xFF)});
                } else if (payload >= 126) {
                    this._buffer.put(new byte[]{opcode, mask ? (byte)-2 : 126, (byte)(payload >> 8), (byte)(payload & 0xFF)});
                } else {
                    this._buffer.put(new byte[]{opcode, (byte)(mask ? 0x80 | payload : payload)});
                }
                if (mask) {
                    this._maskGen.genMask(this._mask);
                    this._m = 0;
                    this._buffer.put(this._mask);
                }
                for (int remaining = payload; remaining > 0; remaining -= chunk) {
                    this._buffer.compact();
                    int n = chunk = remaining < this._buffer.space() ? remaining : this._buffer.space();
                    if (mask) {
                        for (int i = 0; i < chunk; ++i) {
                            this._buffer.put((byte)(content[offset + (payload - remaining) + i] ^ this._mask[this._m++ % 4]));
                        }
                    } else {
                        this._buffer.put(content, offset + (payload - remaining), chunk);
                    }
                    if (this._buffer.space() > 0) {
                        this.flushBuffer();
                        continue;
                    }
                    this.flush();
                    if (remaining != 0) continue;
                    this.flushBuffer();
                }
                offset += payload;
            } while ((length -= payload) > 0);
            boolean bl2 = this._opsent = !last;
            if (this._buffer != null && this._buffer.length() == 0) {
                this._buffers.returnBuffer(this._buffer);
                this._buffer = null;
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int flushBuffer() throws IOException {
        if (!this._lock.tryLock()) {
            return 0;
        }
        try {
            if (!this._endp.isOpen()) {
                throw new EofException();
            }
            if (this._buffer != null) {
                int flushed;
                int n = flushed = this._buffer.hasContent() ? this._endp.flush(this._buffer) : 0;
                if (this._closed && this._buffer.length() == 0) {
                    this._endp.shutdownOutput();
                }
                int n2 = flushed;
                return n2;
            }
            int n = 0;
            return n;
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int flush() throws IOException {
        if (!this._lock.tryLock()) {
            return 0;
        }
        try {
            if (this._buffer == null) {
                int n = 0;
                return n;
            }
            int result = this.flushBuffer();
            if (!this._endp.isBlocking()) {
                long now = System.currentTimeMillis();
                long end = now + (long)this._endp.getMaxIdleTime();
                while (this._buffer.length() > 0) {
                    boolean ready = this._endp.blockWritable(end - now);
                    if (!ready) {
                        now = System.currentTimeMillis();
                        if (now < end) continue;
                        throw new IOException("Write timeout");
                    }
                    result += this.flushBuffer();
                }
            }
            this._buffer.compact();
            int n = result;
            return n;
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isBufferEmpty() {
        this._lock.lock();
        try {
            boolean bl = this._buffer == null || this._buffer.length() == 0;
            return bl;
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void returnBuffer() {
        this._lock.lock();
        try {
            if (this._buffer != null && this._buffer.length() == 0) {
                this._buffers.returnBuffer(this._buffer);
                this._buffer = null;
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    public String toString() {
        Buffer buffer = this._buffer;
        return String.format("%s@%x closed=%b buffer=%d", this.getClass().getSimpleName(), this.hashCode(), this._closed, buffer == null ? -1 : buffer.length());
    }
}

