/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.jndi.factories;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import javax.mail.Authenticator;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.naming.Context;
import javax.naming.Name;
import javax.naming.RefAddr;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.naming.spi.ObjectFactory;
import org.eclipse.jetty.util.security.Password;

public class MailSessionReference
extends Reference
implements ObjectFactory {
    public MailSessionReference() {
        super("javax.mail.Session", MailSessionReference.class.getName(), null);
    }

    public Object getObjectInstance(Object ref, Name arg1, Context arg2, Hashtable arg3) throws Exception {
        if (ref == null) {
            return null;
        }
        Reference reference = (Reference)ref;
        Properties props = new Properties();
        String user = null;
        String password = null;
        Enumeration<RefAddr> refs = reference.getAll();
        while (refs.hasMoreElements()) {
            RefAddr refAddr = refs.nextElement();
            String name = refAddr.getType();
            String value = (String)refAddr.getContent();
            if (name.equalsIgnoreCase("user")) {
                user = value;
                continue;
            }
            if (name.equalsIgnoreCase("pwd")) {
                password = value;
                continue;
            }
            props.put(name, value);
        }
        if (password == null) {
            return Session.getInstance((Properties)props);
        }
        return Session.getInstance((Properties)props, (Authenticator)new PasswordAuthenticator(user, password));
    }

    public void setUser(String user) {
        StringRefAddr addr = (StringRefAddr)this.get("user");
        if (addr != null) {
            throw new RuntimeException("user already set on SessionReference, can't be changed");
        }
        this.add(new StringRefAddr("user", user));
    }

    public void setPassword(String password) {
        StringRefAddr addr = (StringRefAddr)this.get("pwd");
        if (addr != null) {
            throw new RuntimeException("password already set on SessionReference, can't be changed");
        }
        this.add(new StringRefAddr("pwd", password));
    }

    public void setProperties(Properties properties) {
        for (Map.Entry<Object, Object> e : properties.entrySet()) {
            StringRefAddr sref = (StringRefAddr)this.get((String)e.getKey());
            if (sref != null) {
                throw new RuntimeException("property " + e.getKey() + " already set on Session reference, can't be changed");
            }
            this.add(new StringRefAddr((String)e.getKey(), (String)e.getValue()));
        }
    }

    public static class PasswordAuthenticator
    extends Authenticator {
        PasswordAuthentication passwordAuthentication;
        private String user;
        private String password;

        public PasswordAuthenticator() {
        }

        public PasswordAuthenticator(String user, String password) {
            this.passwordAuthentication = new PasswordAuthentication(user, password.startsWith("OBF:") ? Password.deobfuscate(password) : password);
        }

        public PasswordAuthentication getPasswordAuthentication() {
            return this.passwordAuthentication;
        }

        public void setUser(String user) {
            this.user = user;
        }

        public String getUser() {
            return this.user;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }
}

