/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.HandlerWrapper;
import org.eclipse.jetty.websocket.WebSocket;
import org.eclipse.jetty.websocket.WebSocketFactory;

public abstract class WebSocketHandler
extends HandlerWrapper {
    private WebSocketFactory _websocket;
    private int _bufferSize = 8192;
    private int _maxIdleTime = -1;

    public int getBufferSize() {
        return this._bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this._bufferSize = bufferSize;
    }

    public int getMaxIdleTime() {
        return (int)(this._websocket == null ? (long)this._maxIdleTime : this._websocket.getMaxIdleTime());
    }

    public void setMaxIdleTime(int maxIdleTime) {
        this._maxIdleTime = maxIdleTime;
        if (this._websocket != null) {
            this._websocket.setMaxIdleTime(maxIdleTime);
        }
    }

    @Override
    protected void doStart() throws Exception {
        this._websocket = new WebSocketFactory(this._bufferSize);
        if (this._maxIdleTime >= 0) {
            this._websocket.setMaxIdleTime(this._maxIdleTime);
        }
        super.doStart();
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        this._websocket = null;
    }

    @Override
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if ("WebSocket".equals(request.getHeader("Upgrade"))) {
            String subprotocol = request.getHeader(request.getHeader("Sec-WebSocket-Key1") != null ? "Sec-WebSocket-Protocol" : "WebSocket-Protocol");
            WebSocket websocket = this.doWebSocketConnect(request, subprotocol);
            String host = request.getHeader("Host");
            String origin = request.getHeader("Origin");
            origin = this.checkOrigin(request, host, origin);
            if (websocket != null) {
                this._websocket.upgrade(request, response, websocket, origin, subprotocol);
            } else {
                response.sendError(503);
            }
        } else {
            super.handle(target, baseRequest, request, response);
        }
    }

    protected String checkOrigin(HttpServletRequest request, String host, String origin) {
        if (origin == null) {
            origin = host;
        }
        return origin;
    }

    protected abstract WebSocket doWebSocketConnect(HttpServletRequest var1, String var2);
}

