/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.osgi.annotations;

import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.eclipse.jetty.ee10.annotations.AnnotationParser;
import org.eclipse.jetty.osgi.util.BundleFileLocatorHelperFactory;
import org.eclipse.jetty.util.FileID;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.ResourceFactory;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnnotationParser
extends org.eclipse.jetty.ee10.annotations.AnnotationParser {
    private static final Logger LOG = LoggerFactory.getLogger(AnnotationParser.class);
    private Set<URI> _parsed = ConcurrentHashMap.newKeySet();
    private ConcurrentHashMap<URI, Bundle> _uriToBundle = new ConcurrentHashMap();
    private ConcurrentHashMap<Bundle, Resource> _bundleToResource = new ConcurrentHashMap();
    private ConcurrentHashMap<Resource, Bundle> _resourceToBundle = new ConcurrentHashMap();
    private ConcurrentHashMap<Bundle, URI> _bundleToUri = new ConcurrentHashMap();

    public AnnotationParser() {
    }

    public AnnotationParser(int platform) {
        super(platform);
    }

    public Resource indexBundle(ResourceFactory resourceFactory, Bundle bundle) throws Exception {
        File bundleFile = BundleFileLocatorHelperFactory.getFactory().getHelper().getBundleInstallLocation(bundle);
        Resource resource = resourceFactory.newResource(bundleFile.toURI());
        URI uri = resource.getURI();
        this._uriToBundle.putIfAbsent(uri, bundle);
        this._bundleToUri.putIfAbsent(bundle, uri);
        this._bundleToResource.putIfAbsent(bundle, resource);
        this._resourceToBundle.putIfAbsent(resource, bundle);
        return resource;
    }

    protected URI getURI(Bundle bundle) {
        return this._bundleToUri.get(bundle);
    }

    protected Resource getResource(Bundle bundle) {
        return this._bundleToResource.get(bundle);
    }

    protected Bundle getBundle(Resource resource) {
        return this._resourceToBundle.get(resource);
    }

    public void parse(Set<? extends AnnotationParser.Handler> handlers, Bundle bundle) throws Exception {
        Resource bundleResource = this._bundleToResource.get(bundle);
        if (bundleResource == null) {
            return;
        }
        if (!this._parsed.add(this._bundleToUri.get(bundle))) {
            return;
        }
        this.parse(handlers, bundleResource);
    }

    public void parse(Set<? extends AnnotationParser.Handler> handlers, Resource r) throws Exception {
        block7: {
            if (r == null) {
                return;
            }
            if (!r.exists()) {
                return;
            }
            if (FileID.isJavaArchive((Path)r.getPath())) {
                this.parseJar(handlers, r);
                return;
            }
            if (r.isDirectory()) {
                this.parseDir(handlers, r);
                return;
            }
            if (FileID.isClassFile((Path)r.getPath())) {
                this.parseClass(handlers, null, r.getPath());
            }
            try {
                this.parseJar(handlers, r);
            }
            catch (Exception e) {
                if (!LOG.isDebugEnabled()) break block7;
                LOG.warn("Resource not able to be scanned for classes: {}", (Object)r);
            }
        }
    }
}

