/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.server.internal;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritePendingException;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.atomic.LongAdder;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.ComplianceViolation;
import org.eclipse.jetty.http.HostPortHttpField;
import org.eclipse.jetty.http.HttpCompliance;
import org.eclipse.jetty.http.HttpException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpGenerator;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpHeaderValue;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.HttpParser;
import org.eclipse.jetty.http.HttpScheme;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http.Trailers;
import org.eclipse.jetty.http.UriCompliance;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.io.RuntimeIOException;
import org.eclipse.jetty.io.WriteFlusher;
import org.eclipse.jetty.io.ssl.SslConnection;
import org.eclipse.jetty.server.AbstractMetaDataConnection;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.ConnectionMetaData;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpChannel;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpStream;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.TunnelSupport;
import org.eclipse.jetty.server.internal.HttpChannelState;
import org.eclipse.jetty.util.Attributes;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.HostPort;
import org.eclipse.jetty.util.IteratingCallback;
import org.eclipse.jetty.util.StringUtil;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.URIUtil;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConnection
extends AbstractMetaDataConnection
implements Runnable,
WriteFlusher.Listener,
Connection.UpgradeFrom,
Connection.UpgradeTo,
ConnectionMetaData {
    private static final Logger LOG = LoggerFactory.getLogger(HttpConnection.class);
    private static final HttpField PREAMBLE_UPGRADE_H2C = new HttpField(HttpHeader.UPGRADE, "h2c");
    private static final ThreadLocal<HttpConnection> __currentConnection = new ThreadLocal();
    private static final AtomicLong __connectionIdGenerator = new AtomicLong();
    private final TunnelSupport _tunnelSupport = new TunnelSupportOverHTTP1();
    private final AtomicLong _streamIdGenerator = new AtomicLong();
    private final long _id;
    private final HttpChannel _httpChannel;
    private final RequestHandler _requestHandler;
    private final HttpParser _parser;
    private final HttpGenerator _generator;
    private final ByteBufferPool _bufferPool;
    private final AtomicReference<HttpStreamOverHTTP1> _stream = new AtomicReference();
    private final Attributes.Lazy _attributes = new Attributes.Lazy();
    private final DemandContentCallback _demandContentCallback = new DemandContentCallback();
    private final SendCallback _sendCallback = new SendCallback();
    private final LongAdder bytesIn = new LongAdder();
    private final LongAdder bytesOut = new LongAdder();
    private final AtomicBoolean _handling = new AtomicBoolean(false);
    private final HttpFields.Mutable _headerBuilder = HttpFields.build();
    private volatile RetainableByteBuffer _retainableByteBuffer;
    private HttpFields.Mutable _trailers;
    private Runnable _onRequest;
    private long _requests;
    private boolean _useInputDirectByteBuffers;
    private boolean _useOutputDirectByteBuffers;

    public static HttpConnection getCurrentConnection() {
        return __currentConnection.get();
    }

    protected static HttpConnection setCurrentConnection(HttpConnection connection) {
        HttpConnection last = __currentConnection.get();
        __currentConnection.set(connection);
        return last;
    }

    @Deprecated(since="12.0.6", forRemoval=true)
    public HttpConnection(HttpConfiguration configuration, Connector connector, EndPoint endPoint, boolean recordComplianceViolations) {
        this(configuration, connector, endPoint);
    }

    public HttpConnection(HttpConfiguration configuration, Connector connector, EndPoint endPoint) {
        super(connector, configuration, endPoint);
        this._id = __connectionIdGenerator.getAndIncrement();
        this._bufferPool = connector.getByteBufferPool();
        this._generator = this.newHttpGenerator();
        this._httpChannel = this.newHttpChannel(connector.getServer(), configuration);
        this._requestHandler = this.newRequestHandler();
        this._parser = this.newHttpParser(configuration.getHttpCompliance());
        if (LOG.isDebugEnabled()) {
            LOG.debug("New HTTP Connection {}", (Object)this);
        }
    }

    @Override
    public Invocable.InvocationType getInvocationType() {
        return this.getServer().getInvocationType();
    }

    @Deprecated(since="12.0.6", forRemoval=true)
    public boolean isRecordHttpComplianceViolations() {
        return false;
    }

    protected HttpGenerator newHttpGenerator() {
        return new HttpGenerator();
    }

    protected HttpParser newHttpParser(HttpCompliance compliance) {
        HttpParser parser = new HttpParser(this._requestHandler, this.getHttpConfiguration().getRequestHeaderSize(), compliance);
        parser.setHeaderCacheSize(this.getHttpConfiguration().getHeaderCacheSize());
        parser.setHeaderCacheCaseSensitive(this.getHttpConfiguration().isHeaderCacheCaseSensitive());
        return parser;
    }

    protected HttpChannel newHttpChannel(Server server, HttpConfiguration configuration) {
        return new HttpChannelState(this);
    }

    protected HttpStreamOverHTTP1 newHttpStream(String method, String uri, HttpVersion version) {
        return new HttpStreamOverHTTP1(method, uri, version);
    }

    protected RequestHandler newRequestHandler() {
        return new RequestHandler();
    }

    public Server getServer() {
        return this.getConnector().getServer();
    }

    public HttpChannel getHttpChannel() {
        return this._httpChannel;
    }

    public HttpParser getParser() {
        return this._parser;
    }

    public HttpGenerator getGenerator() {
        return this._generator;
    }

    @Override
    public String getId() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.getRemoteSocketAddress()).append('@');
        try {
            TypeUtil.toHex(this.hashCode(), (Appendable)builder);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        builder.append('#').append(this._id);
        return builder.toString();
    }

    @Override
    public HttpVersion getHttpVersion() {
        HttpStreamOverHTTP1 stream = this._stream.get();
        return stream != null ? stream._version : HttpVersion.HTTP_1_1;
    }

    @Override
    public String getProtocol() {
        return this.getHttpVersion().asString();
    }

    @Override
    public boolean isPersistent() {
        return this._generator.isPersistent(this.getHttpVersion());
    }

    @Override
    public Object removeAttribute(String name) {
        return this._attributes.removeAttribute(name);
    }

    @Override
    public Object setAttribute(String name, Object attribute) {
        return this._attributes.setAttribute(name, attribute);
    }

    @Override
    public Object getAttribute(String name) {
        return this._attributes.getAttribute(name);
    }

    @Override
    public Set<String> getAttributeNameSet() {
        return this._attributes.getAttributeNameSet();
    }

    @Override
    public void clearAttributes() {
        this._attributes.clearAttributes();
    }

    @Override
    public long getMessagesIn() {
        return this._requests;
    }

    @Override
    public long getMessagesOut() {
        return this._requests;
    }

    public boolean isUseInputDirectByteBuffers() {
        return this._useInputDirectByteBuffers;
    }

    public void setUseInputDirectByteBuffers(boolean useInputDirectByteBuffers) {
        this._useInputDirectByteBuffers = useInputDirectByteBuffers;
    }

    public boolean isUseOutputDirectByteBuffers() {
        return this._useOutputDirectByteBuffers;
    }

    public void setUseOutputDirectByteBuffers(boolean useOutputDirectByteBuffers) {
        this._useOutputDirectByteBuffers = useOutputDirectByteBuffers;
    }

    @Override
    public ByteBuffer onUpgradeFrom() {
        if (!this.isRequestBufferEmpty()) {
            ByteBuffer unconsumed = ByteBuffer.allocateDirect(this._retainableByteBuffer.remaining());
            unconsumed.put(this._retainableByteBuffer.getByteBuffer());
            unconsumed.flip();
            this.releaseRequestBuffer();
            return unconsumed;
        }
        return null;
    }

    @Override
    public void onUpgradeTo(ByteBuffer buffer) {
        BufferUtil.append(this.getRequestBuffer(), buffer);
    }

    @Override
    public void onFlushed(long bytes) throws IOException {
    }

    void releaseRequestBuffer() {
        if (this._retainableByteBuffer != null && !this._retainableByteBuffer.hasRemaining()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("releaseRequestBuffer {}", (Object)this);
            }
            if (this._retainableByteBuffer.release()) {
                this._retainableByteBuffer = null;
            } else {
                throw new IllegalStateException("unreleased buffer " + String.valueOf(this._retainableByteBuffer));
            }
        }
    }

    private ByteBuffer getRequestBuffer() {
        if (this._retainableByteBuffer == null) {
            this._retainableByteBuffer = this._bufferPool.acquire(this.getInputBufferSize(), this.isUseInputDirectByteBuffers());
        }
        return this._retainableByteBuffer.getByteBuffer();
    }

    public boolean isRequestBufferEmpty() {
        return this._retainableByteBuffer == null || !this._retainableByteBuffer.hasRemaining();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onFillable() {
        if (LOG.isDebugEnabled()) {
            LOG.debug(">>onFillable enter {} {} {}", this, this._httpChannel, this._retainableByteBuffer);
        }
        HttpConnection last = HttpConnection.setCurrentConnection(this);
        try {
            while (this.getEndPoint().isOpen()) {
                int filled;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("onFillable fill and parse {} {} {}", this, this._httpChannel, this._retainableByteBuffer);
                }
                if ((filled = this.fillRequestBuffer()) < 0 && this.getEndPoint().isOutputShutdown()) {
                    this.close();
                }
                boolean handle = this.parseRequestBuffer();
                if (this.getEndPoint().getConnection() != this) break;
                if (handle) {
                    Request request = this._httpChannel.getRequest();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("HANDLE {} {}", (Object)request, (Object)this);
                    }
                    this._handling.set(true);
                    Runnable onRequest = this._onRequest;
                    this._onRequest = null;
                    onRequest.run();
                    if (this._handling.compareAndSet(true, false)) {
                        if (!LOG.isDebugEnabled()) break;
                        LOG.debug("request !complete {} {}", (Object)request, (Object)this);
                        break;
                    }
                    if (this.getEndPoint().getConnection() == this) continue;
                    if (!LOG.isDebugEnabled()) break;
                    LOG.debug("upgraded {} -> {}", (Object)this, (Object)this.getEndPoint().getConnection());
                    break;
                }
                if (filled < 0) {
                    this.getEndPoint().shutdownOutput();
                    break;
                }
                if (this._requestHandler._failure != null) break;
                if (filled != 0) continue;
                this.fillInterested();
                break;
            }
        }
        catch (Throwable x) {
            try {
                try {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("caught exception {} {}", this, this._httpChannel, x);
                    }
                    if (this._retainableByteBuffer != null) {
                        this._retainableByteBuffer.clear();
                        this.releaseRequestBuffer();
                    }
                }
                finally {
                    this.getEndPoint().close(x);
                }
            }
            catch (Throwable throwable) {
                HttpConnection.setCurrentConnection(last);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("<<onFillable exit {} {} {}", this, this._httpChannel, this._retainableByteBuffer);
                }
                throw throwable;
            }
            HttpConnection.setCurrentConnection(last);
            if (LOG.isDebugEnabled()) {
                LOG.debug("<<onFillable exit {} {} {}", this, this._httpChannel, this._retainableByteBuffer);
            }
        }
        HttpConnection.setCurrentConnection(last);
        if (LOG.isDebugEnabled()) {
            LOG.debug("<<onFillable exit {} {} {}", this, this._httpChannel, this._retainableByteBuffer);
        }
    }

    void parseAndFillForContent() {
        if (this._parser.isTerminated()) {
            this._requestHandler.messageComplete();
            return;
        }
        while (!(!this._parser.inContentState() || this.parseRequestBuffer() || this._parser.inContentState() && this.fillRequestBuffer() <= 0)) {
        }
    }

    private int fillRequestBuffer() {
        if (this._retainableByteBuffer != null && this._retainableByteBuffer.isRetained()) {
            RetainableByteBuffer newBuffer = this._bufferPool.acquire(this.getInputBufferSize(), this.isUseInputDirectByteBuffers());
            if (LOG.isDebugEnabled()) {
                LOG.debug("replace buffer {} <- {} in {}", this._retainableByteBuffer, newBuffer, this);
            }
            this._retainableByteBuffer.release();
            this._retainableByteBuffer = newBuffer;
        }
        if (!this.isRequestBufferEmpty()) {
            return this._retainableByteBuffer.remaining();
        }
        ByteBuffer requestBuffer = this.getRequestBuffer();
        try {
            int filled = this.getEndPoint().fill(requestBuffer);
            if (filled == 0) {
                filled = this.getEndPoint().fill(requestBuffer);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} filled {} {}", this, filled, this._retainableByteBuffer);
            }
            if (filled > 0) {
                this.bytesIn.add(filled);
            } else {
                if (filled < 0) {
                    this._parser.atEOF();
                }
                this.releaseRequestBuffer();
            }
            return filled;
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unable to fill from endpoint {}", (Object)this.getEndPoint(), (Object)x);
            }
            this._parser.atEOF();
            if (this._retainableByteBuffer != null) {
                this._retainableByteBuffer.clear();
                this.releaseRequestBuffer();
            }
            return -1;
        }
    }

    private boolean parseRequestBuffer() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} parse {}", (Object)this, (Object)this._retainableByteBuffer);
        }
        if (this._parser.isTerminated()) {
            throw new RuntimeIOException("Parser is terminated");
        }
        boolean handle = this._parser.parseNext(this._retainableByteBuffer == null ? BufferUtil.EMPTY_BUFFER : this._retainableByteBuffer.getByteBuffer());
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} parsed {} {}", this, handle, this._parser);
        }
        if (this._retainableByteBuffer != null && !this._retainableByteBuffer.isRetained()) {
            this.releaseRequestBuffer();
        }
        return handle;
    }

    private boolean upgrade(HttpStreamOverHTTP1 stream) {
        if (stream.upgrade()) {
            this._httpChannel.recycle();
            this._parser.close();
            this._generator.reset();
            return true;
        }
        return false;
    }

    @Override
    protected void onFillInterestedFailed(Throwable cause) {
        this._parser.close();
        super.onFillInterestedFailed(cause);
    }

    @Override
    public boolean onIdleExpired(TimeoutException timeout) {
        if (this._httpChannel.getRequest() == null) {
            return true;
        }
        Runnable task = this._httpChannel.onIdleTimeout(timeout);
        if (task != null) {
            this.getExecutor().execute(task);
        }
        return false;
    }

    @Override
    public void onOpen() {
        super.onOpen();
        if (this.isRequestBufferEmpty()) {
            this.fillInterested();
        } else {
            this.getExecutor().execute(this);
        }
    }

    @Override
    public void onClose(Throwable cause) {
        if (cause == null) {
            this._sendCallback.close();
        } else {
            this._sendCallback.abort(cause);
        }
        super.onClose(cause);
    }

    @Override
    public void run() {
        this.onFillable();
    }

    public void asyncReadFillInterested() {
        this.getEndPoint().tryFillInterested(this._demandContentCallback);
    }

    @Override
    public long getBytesIn() {
        return this.bytesIn.longValue();
    }

    @Override
    public long getBytesOut() {
        return this.bytesOut.longValue();
    }

    @Override
    public String toConnectionString() {
        return String.format("%s@%x[p=%s,g=%s]=>%s", this.getClass().getSimpleName(), this.hashCode(), this._parser, this._generator, this._httpChannel);
    }

    private class TunnelSupportOverHTTP1
    implements TunnelSupport {
        private TunnelSupportOverHTTP1() {
        }

        @Override
        public String getProtocol() {
            return null;
        }

        @Override
        public EndPoint getEndPoint() {
            return HttpConnection.this.getEndPoint();
        }
    }

    private class DemandContentCallback
    implements Callback {
        private DemandContentCallback() {
        }

        @Override
        public void succeeded() {
            Runnable task = HttpConnection.this._httpChannel.onContentAvailable();
            if (LOG.isDebugEnabled()) {
                LOG.debug("demand succeeded {}", (Object)task);
            }
            if (task != null) {
                task.run();
            }
        }

        @Override
        public void failed(Throwable x) {
            Runnable task = HttpConnection.this._httpChannel.onFailure(x);
            if (LOG.isDebugEnabled()) {
                LOG.debug("demand failed {}", (Object)task, (Object)x);
            }
            if (task != null) {
                HttpConnection.this.getConnector().getExecutor().execute(task);
            }
        }

        @Override
        public Invocable.InvocationType getInvocationType() {
            return Invocable.getInvocationType(HttpConnection.this._httpChannel);
        }
    }

    private class SendCallback
    extends IteratingCallback {
        private MetaData.Response _info;
        private boolean _head;
        private ByteBuffer _content;
        private boolean _lastContent;
        private Callback _callback;
        private RetainableByteBuffer _header;
        private RetainableByteBuffer _chunk;
        private boolean _shutdownOut;

        private SendCallback() {
            super(true);
        }

        @Override
        public Invocable.InvocationType getInvocationType() {
            return this._callback.getInvocationType();
        }

        private boolean reset(MetaData.Request request, MetaData.Response response, ByteBuffer content, boolean last, Callback callback) {
            if (this.reset()) {
                this._info = response;
                this._head = request != null && HttpMethod.HEAD.is(request.getMethod());
                this._content = content;
                this._lastContent = last;
                this._callback = callback;
                this._header = null;
                if (HttpConnection.this.getConnector().isShutdown()) {
                    HttpConnection.this._generator.setPersistent(false);
                }
                return true;
            }
            if (this.isClosed()) {
                callback.failed(new EofException());
            } else {
                callback.failed(new WritePendingException());
            }
            return false;
        }

        @Override
        public IteratingCallback.Action process() throws Exception {
            HttpGenerator.Result result;
            if (this._callback == null) {
                throw new IllegalStateException();
            }
            boolean useDirectByteBuffers = HttpConnection.this.isUseOutputDirectByteBuffers();
            block20: while (true) {
                ByteBuffer headerByteBuffer = this._header == null ? null : this._header.getByteBuffer();
                ByteBuffer chunkByteBuffer = this._chunk == null ? null : this._chunk.getByteBuffer();
                result = HttpConnection.this._generator.generateResponse(this._info, this._head, headerByteBuffer, chunkByteBuffer, this._content, this._lastContent);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("generate: {} for {} ({},{},{})@{}", new Object[]{result, this, BufferUtil.toSummaryString(headerByteBuffer), BufferUtil.toSummaryString(this._content), this._lastContent, HttpConnection.this._generator.getState()});
                }
                switch (result) {
                    case NEED_INFO: {
                        throw new EofException("request lifecycle violation");
                    }
                    case NEED_HEADER: {
                        this._header = HttpConnection.this._bufferPool.acquire(Math.min(HttpConnection.this.getHttpConfiguration().getResponseHeaderSize(), HttpConnection.this.getHttpConfiguration().getOutputBufferSize()), useDirectByteBuffers);
                        continue block20;
                    }
                    case HEADER_OVERFLOW: {
                        if (this._header.capacity() >= HttpConnection.this.getHttpConfiguration().getResponseHeaderSize()) {
                            throw new HttpException.RuntimeException(500, "Response header too large");
                        }
                        this.releaseHeader();
                        this._header = HttpConnection.this._bufferPool.acquire(HttpConnection.this.getHttpConfiguration().getResponseHeaderSize(), useDirectByteBuffers);
                        continue block20;
                    }
                    case NEED_CHUNK: {
                        this._chunk = HttpConnection.this._bufferPool.acquire(12, useDirectByteBuffers);
                        continue block20;
                    }
                    case NEED_CHUNK_TRAILER: {
                        this.releaseChunk();
                        this._chunk = HttpConnection.this._bufferPool.acquire(HttpConnection.this.getHttpConfiguration().getResponseHeaderSize(), useDirectByteBuffers);
                        continue block20;
                    }
                    case FLUSH: {
                        if (this._head || HttpConnection.this._generator.isNoContent()) {
                            if (this._chunk != null) {
                                this._chunk.clear();
                            }
                            BufferUtil.clear(this._content);
                        }
                        int gatherWrite = 0;
                        long bytes = 0L;
                        if (BufferUtil.hasContent(headerByteBuffer)) {
                            gatherWrite += 4;
                            bytes += (long)this._header.remaining();
                        }
                        if (BufferUtil.hasContent(chunkByteBuffer)) {
                            gatherWrite += 2;
                            bytes += (long)this._chunk.remaining();
                        }
                        if (BufferUtil.hasContent(this._content)) {
                            ++gatherWrite;
                            bytes += (long)this._content.remaining();
                        }
                        HttpConnection.this.bytesOut.add(bytes);
                        switch (gatherWrite) {
                            case 7: {
                                HttpConnection.this.getEndPoint().write((Callback)this, headerByteBuffer, chunkByteBuffer, this._content);
                                break;
                            }
                            case 6: {
                                HttpConnection.this.getEndPoint().write((Callback)this, headerByteBuffer, chunkByteBuffer);
                                break;
                            }
                            case 5: {
                                HttpConnection.this.getEndPoint().write((Callback)this, headerByteBuffer, this._content);
                                break;
                            }
                            case 4: {
                                HttpConnection.this.getEndPoint().write((Callback)this, headerByteBuffer);
                                break;
                            }
                            case 3: {
                                HttpConnection.this.getEndPoint().write((Callback)this, chunkByteBuffer, this._content);
                                break;
                            }
                            case 2: {
                                HttpConnection.this.getEndPoint().write((Callback)this, chunkByteBuffer);
                                break;
                            }
                            case 1: {
                                HttpConnection.this.getEndPoint().write((Callback)this, this._content);
                                break;
                            }
                            default: {
                                this.succeeded();
                            }
                        }
                        return IteratingCallback.Action.SCHEDULED;
                    }
                    case SHUTDOWN_OUT: {
                        this._shutdownOut = true;
                        continue block20;
                    }
                    case DONE: {
                        if (HttpConnection.this.getConnector().isShutdown() && HttpConnection.this._generator.isEnd() && HttpConnection.this._generator.isPersistent()) {
                            this._shutdownOut = true;
                        }
                        return IteratingCallback.Action.SUCCEEDED;
                    }
                    case CONTINUE: {
                        continue block20;
                    }
                }
                break;
            }
            throw new IllegalStateException("generateResponse=" + String.valueOf((Object)result));
        }

        private Callback release() {
            Callback complete = this._callback;
            this._callback = null;
            this._info = null;
            this._content = null;
            this.releaseHeader();
            this.releaseChunk();
            return complete;
        }

        private void releaseHeader() {
            if (this._header != null) {
                this._header.release();
            }
            this._header = null;
        }

        private void releaseChunk() {
            if (this._chunk != null) {
                this._chunk.release();
            }
            this._chunk = null;
        }

        @Override
        protected void onCompleteSuccess() {
            this.release().succeeded();
        }

        @Override
        public void onCompleteFailure(Throwable x) {
            HttpConnection.this.failedCallback(this.release(), x);
        }

        @Override
        public String toString() {
            return String.format("%s[i=%s,cb=%s]", super.toString(), this._info, this._callback);
        }
    }

    protected class RequestHandler
    implements HttpParser.RequestHandler {
        private Throwable _failure;

        protected RequestHandler() {
        }

        @Override
        public void messageBegin() {
            HttpConnection.this._httpChannel.initialize();
        }

        @Override
        public void startRequest(String method, String uri, HttpVersion version) {
            HttpStreamOverHTTP1 stream = HttpConnection.this.newHttpStream(method, uri, version);
            if (!HttpConnection.this._stream.compareAndSet(null, stream)) {
                throw new IllegalStateException("Stream pending");
            }
            HttpConnection.this._headerBuilder.clear();
            HttpConnection.this._httpChannel.setHttpStream(stream);
        }

        @Override
        public void parsedHeader(HttpField field) {
            HttpConnection.this._stream.get().parsedHeader(field);
        }

        @Override
        public boolean headerComplete() {
            HttpConnection.this._onRequest = HttpConnection.this._stream.get().headerComplete();
            return true;
        }

        @Override
        public boolean content(ByteBuffer buffer) {
            HttpStreamOverHTTP1 stream = HttpConnection.this._stream.get();
            if (stream == null || stream._chunk != null || HttpConnection.this._retainableByteBuffer == null) {
                throw new IllegalStateException();
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("content {}/{} for {}", BufferUtil.toDetailString(buffer), HttpConnection.this._retainableByteBuffer, HttpConnection.this);
            }
            HttpConnection.this._retainableByteBuffer.retain();
            stream._chunk = Content.Chunk.asChunk(buffer, false, HttpConnection.this._retainableByteBuffer);
            return true;
        }

        @Override
        public boolean contentComplete() {
            return false;
        }

        @Override
        public void onViolation(ComplianceViolation.Event event) {
            HttpConnection.this.getHttpChannel().getComplianceViolationListener().onComplianceViolation(event);
        }

        @Override
        public void parsedTrailer(HttpField field) {
            if (HttpConnection.this._trailers == null) {
                HttpConnection.this._trailers = HttpFields.build();
            }
            HttpConnection.this._trailers.add(field);
        }

        @Override
        public boolean messageComplete() {
            HttpStreamOverHTTP1 stream = HttpConnection.this._stream.get();
            if (stream._chunk != null) {
                throw new IllegalStateException();
            }
            stream._chunk = HttpConnection.this._trailers != null ? new Trailers(HttpConnection.this._trailers.asImmutable()) : Content.Chunk.EOF;
            HttpConnection.this.getHttpChannel().getComplianceViolationListener().onRequestBegin(HttpConnection.this.getHttpChannel().getRequest());
            return false;
        }

        @Override
        public void badMessage(HttpException failure) {
            Runnable task;
            if (LOG.isDebugEnabled()) {
                LOG.debug("badMessage {} {}", (Object)HttpConnection.this, (Object)failure);
            }
            HttpConnection.this.getHttpChannel().getComplianceViolationListener().onRequestEnd(HttpConnection.this.getHttpChannel().getRequest());
            this._failure = (Throwable)((Object)failure);
            HttpConnection.this._generator.setPersistent(false);
            HttpStreamOverHTTP1 stream = HttpConnection.this._stream.get();
            if (stream == null) {
                stream = HttpConnection.this.newHttpStream("GET", "/badMessage", HttpVersion.HTTP_1_0);
                HttpConnection.this._stream.set(stream);
                HttpConnection.this._httpChannel.setHttpStream(stream);
            }
            if (HttpConnection.this._httpChannel.getRequest() == null) {
                HttpURI uri = stream._uri;
                if (uri.hasViolations()) {
                    uri = HttpURI.from("/badURI");
                }
                HttpConnection.this._httpChannel.onRequest(new MetaData.Request(HttpConnection.this._parser.getBeginNanoTime(), stream._method, uri, stream._version, HttpFields.EMPTY));
            }
            if ((task = HttpConnection.this._httpChannel.onFailure(this._failure)) != null) {
                HttpConnection.this.getServer().getThreadPool().execute(task);
            }
        }

        @Override
        public void earlyEOF() {
            if (LOG.isDebugEnabled()) {
                LOG.debug("early EOF {}", (Object)HttpConnection.this);
            }
            HttpConnection.this._generator.setPersistent(false);
            HttpStreamOverHTTP1 stream = HttpConnection.this._stream.get();
            if (stream != null) {
                BadMessageException bad = new BadMessageException("Early EOF");
                Content.Chunk chunk = stream._chunk;
                if (Content.Chunk.isFailure(chunk)) {
                    if (chunk.isLast()) {
                        chunk.getFailure().addSuppressed(bad);
                    } else {
                        bad.addSuppressed(chunk.getFailure());
                        stream._chunk = Content.Chunk.from(bad);
                    }
                } else {
                    if (chunk != null) {
                        chunk.release();
                    }
                    stream._chunk = Content.Chunk.from(bad);
                }
                Runnable todo = HttpConnection.this._httpChannel.onFailure(bad);
                if (todo != null) {
                    HttpConnection.this.getServer().getThreadPool().execute(todo);
                }
            }
        }
    }

    protected class HttpStreamOverHTTP1
    implements HttpStream {
        private final long _id;
        private final String _method;
        private final HttpURI.Mutable _uri;
        private final HttpVersion _version;
        private long _contentLength = -1L;
        private HostPortHttpField _hostField;
        private MetaData.Request _request;
        private HttpField _upgrade = null;
        private Content.Chunk _chunk;
        private boolean _connectionClose = false;
        private boolean _connectionKeepAlive = false;
        private boolean _connectionUpgrade = false;
        private boolean _unknownExpectation = false;
        private boolean _expects100Continue = false;
        private List<String> _complianceViolations;

        protected HttpStreamOverHTTP1(String method, String uri, HttpVersion version) {
            this._id = HttpConnection.this._streamIdGenerator.getAndIncrement();
            this._method = method;
            this._uri = uri == null ? null : HttpURI.build(method, uri);
            this._version = Objects.requireNonNull(version);
            if (this._uri != null && this._uri.getPath() == null && this._uri.getScheme() != null && this._uri.hasAuthority()) {
                this._uri.path("/");
            }
        }

        @Override
        public Throwable consumeAvailable() {
            Throwable result = HttpStream.consumeAvailable(this, HttpConnection.this.getHttpConfiguration());
            if (result != null) {
                HttpConnection.this._generator.setPersistent(false);
                if (this._chunk != null) {
                    this._chunk.release();
                }
                this._chunk = Content.Chunk.from(result, true);
            }
            return result;
        }

        public void parsedHeader(HttpField field) {
            HttpHeader header = field.getHeader();
            String value = field.getValue();
            if (header != null) {
                switch (header) {
                    case CONNECTION: {
                        this._connectionClose |= field.contains(HttpHeaderValue.CLOSE.asString());
                        if (HttpVersion.HTTP_1_0.equals((Object)this._version)) {
                            this._connectionKeepAlive |= field.contains(HttpHeader.KEEP_ALIVE.asString());
                        }
                        this._connectionUpgrade |= field.contains(HttpHeaderValue.UPGRADE.asString());
                        break;
                    }
                    case HOST: {
                        if (value == null) {
                            value = "";
                        }
                        if (field instanceof HostPortHttpField) {
                            this._hostField = (HostPortHttpField)field;
                            break;
                        }
                        this._hostField = new HostPortHttpField(value);
                        field = this._hostField;
                        break;
                    }
                    case EXPECT: {
                        if (HttpHeaderValue.parseCsvIndex(value, t -> {
                            if (t == HttpHeaderValue.CONTINUE) {
                                this._expects100Continue = true;
                                return true;
                            }
                            return false;
                        }, s -> false)) break;
                        this._unknownExpectation = true;
                        this._expects100Continue = false;
                        break;
                    }
                    case UPGRADE: {
                        this._upgrade = field;
                        break;
                    }
                    case CONTENT_LENGTH: {
                        this._contentLength = field.getLongValue();
                        break;
                    }
                }
            }
            HttpConnection.this._headerBuilder.add(field);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Runnable headerComplete() {
            boolean persistent;
            UriCompliance compliance;
            String badMessage;
            if (this._uri.hasViolations() && (badMessage = UriCompliance.checkUriCompliance(compliance = HttpConnection.this.getHttpConfiguration().getUriCompliance(), this._uri, HttpConnection.this.getHttpChannel().getComplianceViolationListener())) != null) {
                throw new BadMessageException(badMessage);
            }
            if (this._hostField != null) {
                if (this._uri.isAbsolute()) {
                    if (!this._hostField.getValue().equals(this._uri.getAuthority())) {
                        HttpCompliance httpCompliance = HttpConnection.this.getHttpConfiguration().getHttpCompliance();
                        if (!httpCompliance.allows(HttpCompliance.Violation.MISMATCHED_AUTHORITY)) throw new BadMessageException("Authority!=Host");
                        HttpConnection.this.getHttpChannel().getComplianceViolationListener().onComplianceViolation(new ComplianceViolation.Event(httpCompliance, HttpCompliance.Violation.MISMATCHED_AUTHORITY, this._uri.asString()));
                    }
                } else if (StringUtil.isBlank(this._hostField.getHostPort().getHost())) {
                    throw new BadMessageException("Blank Host");
                }
            }
            if (!this._uri.isAbsolute()) {
                this._uri.scheme(HttpConnection.this.getEndPoint() instanceof SslConnection.SslEndPoint ? HttpScheme.HTTPS : HttpScheme.HTTP);
            }
            if (this._uri.getAuthority() == null && !HttpMethod.CONNECT.is(this._method)) {
                HostPort hostPort = this._hostField == null ? HttpConnection.this.getServerAuthority() : this._hostField.getHostPort();
                int port = hostPort.getPort();
                if (port == URIUtil.getDefaultPortForScheme(this._uri.getScheme())) {
                    port = -1;
                }
                this._uri.authority(hostPort.getHost(), port);
            }
            if (this._uri.getPath() == null) {
                this._uri.path("/");
            }
            this._request = new MetaData.Request(HttpConnection.this._parser.getBeginNanoTime(), this._method, this._uri.asImmutable(), this._version, (HttpFields)HttpConnection.this._headerBuilder, this._contentLength){

                @Override
                public boolean is100ContinueExpected() {
                    return HttpStreamOverHTTP1.this._expects100Continue;
                }
            };
            Runnable handle = HttpConnection.this._httpChannel.onRequest(this._request);
            ++HttpConnection.this._requests;
            Request request = HttpConnection.this._httpChannel.getRequest();
            HttpConnection.this.getHttpChannel().getComplianceViolationListener().onRequestBegin(request);
            if (this._complianceViolations != null && !this._complianceViolations.isEmpty()) {
                HttpConnection.this._httpChannel.getRequest().setAttribute("org.eclipse.jetty.http.compliance.violations", this._complianceViolations);
                this._complianceViolations = null;
            }
            switch (this._request.getHttpVersion()) {
                case HTTP_0_9: {
                    persistent = false;
                    break;
                }
                case HTTP_1_0: {
                    persistent = HttpConnection.this.getHttpConfiguration().isPersistentConnectionsEnabled() && this._connectionKeepAlive && !this._connectionClose || HttpMethod.CONNECT.is(this._method);
                    HttpConnection.this._generator.setPersistent(persistent);
                    if (persistent) break;
                    this._connectionKeepAlive = false;
                    break;
                }
                case HTTP_1_1: {
                    if (this._unknownExpectation) {
                        HttpConnection.this._requestHandler.badMessage(new BadMessageException(417));
                        return null;
                    }
                    persistent = HttpConnection.this.getHttpConfiguration().isPersistentConnectionsEnabled() && !this._connectionClose || HttpMethod.CONNECT.is(this._method);
                    HttpConnection.this._generator.setPersistent(persistent);
                    if (this._upgrade == null || !HttpConnection.this.upgrade(HttpConnection.this._stream.get())) break;
                    return null;
                }
                case HTTP_2: {
                    this._upgrade = PREAMBLE_UPGRADE_H2C;
                    if (HttpMethod.PRI.is(this._method) && "*".equals(this._uri.getPath()) && HttpConnection.this._headerBuilder.size() == 0 && HttpConnection.this.upgrade(HttpConnection.this._stream.get())) {
                        return null;
                    }
                    HttpConnection.this._parser.close();
                    throw new BadMessageException(426, "Upgrade Required");
                }
                default: {
                    throw new IllegalStateException("unsupported version " + String.valueOf((Object)this._version));
                }
            }
            if (persistent) return handle;
            HttpConnection.this._generator.setPersistent(false);
            return handle;
        }

        @Override
        public String getId() {
            return Long.toString(this._id);
        }

        @Override
        public Content.Chunk read() {
            if (this._chunk == null) {
                if (HttpConnection.this._parser.isTerminated()) {
                    this._chunk = Content.Chunk.EOF;
                } else {
                    HttpConnection.this.parseAndFillForContent();
                }
            }
            Content.Chunk content = this._chunk;
            this._chunk = Content.Chunk.next(content);
            if (content != null && this._expects100Continue && content.hasRemaining()) {
                this._expects100Continue = false;
            }
            return content;
        }

        @Override
        public void demand() {
            if (this._chunk != null) {
                Runnable onContentAvailable = HttpConnection.this._httpChannel.onContentAvailable();
                if (onContentAvailable != null) {
                    onContentAvailable.run();
                }
                return;
            }
            HttpConnection.this.parseAndFillForContent();
            if (this._chunk != null) {
                Runnable onContentAvailable = HttpConnection.this._httpChannel.onContentAvailable();
                if (onContentAvailable != null) {
                    onContentAvailable.run();
                }
                return;
            }
            HttpConnection.this.tryFillInterested(HttpConnection.this._demandContentCallback);
        }

        @Override
        public void prepareResponse(HttpFields.Mutable headers) {
            if (this._connectionKeepAlive && this._version == HttpVersion.HTTP_1_0 && !headers.contains(HttpHeader.CONNECTION, HttpHeaderValue.CLOSE.asString())) {
                headers.add(HttpFields.CONNECTION_KEEPALIVE);
            }
        }

        @Override
        public void send(MetaData.Request request, MetaData.Response response, boolean last, ByteBuffer content, Callback callback) {
            if (response == null) {
                if (!last && BufferUtil.isEmpty(content)) {
                    callback.succeeded();
                    return;
                }
            } else if (HttpConnection.this._generator.isCommitted()) {
                callback.failed(new IllegalStateException("Committed"));
            } else if (this._expects100Continue) {
                if (response.getStatus() == 100) {
                    this._expects100Continue = false;
                } else {
                    HttpConnection.this._generator.setPersistent(false);
                }
            }
            if (HttpConnection.this._sendCallback.reset(this._request, response, content, last, callback)) {
                HttpConnection.this._sendCallback.iterate();
            }
        }

        @Override
        public long getIdleTimeout() {
            return HttpConnection.this.getEndPoint().getIdleTimeout();
        }

        @Override
        public void setIdleTimeout(long idleTimeoutMs) {
            HttpConnection.this.getEndPoint().setIdleTimeout(idleTimeoutMs);
        }

        @Override
        public boolean isCommitted() {
            return HttpConnection.this._stream.get() != this || HttpConnection.this._generator.isCommitted();
        }

        private boolean upgrade() {
            boolean isPriorKnowledgeH2C;
            if (LOG.isDebugEnabled()) {
                LOG.debug("upgrade {} {}", (Object)this, (Object)this._upgrade);
            }
            if (!this._connectionUpgrade && this._upgrade == null) {
                return false;
            }
            boolean bl = isPriorKnowledgeH2C = this._upgrade == PREAMBLE_UPGRADE_H2C;
            if (!isPriorKnowledgeH2C && !this._connectionUpgrade) {
                throw new BadMessageException(400);
            }
            ConnectionFactory.Upgrading factory = HttpConnection.this.getConnector().getConnectionFactories().stream().filter(f -> f instanceof ConnectionFactory.Upgrading).map(ConnectionFactory.Upgrading.class::cast).filter(f -> f.getProtocols().contains(this._upgrade.getValue())).findAny().orElse(null);
            if (factory == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("No factory for {} in {}", (Object)this._upgrade, (Object)HttpConnection.this.getConnector());
                }
                return false;
            }
            HttpFields.Mutable response101 = HttpFields.build();
            Connection upgradeConnection = factory.upgradeConnection(HttpConnection.this.getConnector(), HttpConnection.this.getEndPoint(), this._request, response101);
            if (upgradeConnection == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Upgrade ignored for {} by {}", (Object)this._upgrade, (Object)factory);
                }
                return false;
            }
            if (!isPriorKnowledgeH2C) {
                this.send(this._request, new MetaData.Response(101, null, HttpVersion.HTTP_1_1, response101, 0L), false, null, Callback.NOOP);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Upgrading from {} to {}", (Object)HttpConnection.this.getEndPoint().getConnection(), (Object)upgradeConnection);
            }
            HttpConnection.this.getEndPoint().upgrade(upgradeConnection);
            return true;
        }

        @Override
        public TunnelSupport getTunnelSupport() {
            return HttpConnection.this._tunnelSupport;
        }

        @Override
        public void succeeded() {
            HttpStreamOverHTTP1 stream = HttpConnection.this._stream.getAndSet(null);
            if (stream == null) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("succeeded {}", (Object)HttpConnection.this);
            }
            if (HttpConnection.this.isFillInterested()) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("abort due to pending read {} {} ", (Object)this, (Object)HttpConnection.this.getEndPoint());
                }
                this.abort(new IOException("Pending read in onCompleted"));
                return;
            }
            Connection upgradeConnection = (Connection)HttpConnection.this._httpChannel.getRequest().getAttribute(HttpStream.UPGRADE_CONNECTION_ATTRIBUTE);
            if (upgradeConnection != null) {
                HttpConnection.this.getEndPoint().upgrade(upgradeConnection);
                HttpConnection.this._httpChannel.recycle();
                HttpConnection.this._parser.close();
                HttpConnection.this._generator.reset();
                return;
            }
            HttpConnection.this._httpChannel.recycle();
            if (this._expects100Continue) {
                this._expects100Continue = false;
                HttpConnection.this._parser.close();
            }
            if (!HttpConnection.this._parser.isClosed()) {
                if (HttpConnection.this._generator.isPersistent()) {
                    HttpConnection.this._parser.reset();
                } else {
                    HttpConnection.this._parser.close();
                }
            }
            HttpConnection.this._generator.reset();
            if (HttpConnection.this._handling.compareAndSet(true, false)) {
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("non-current completion {}", (Object)this);
            }
            if (HttpConnection.this._sendCallback._shutdownOut) {
                HttpConnection.this.getEndPoint().shutdownOutput();
            }
            if (HttpConnection.this._parser.isStart()) {
                if (HttpConnection.this.isRequestBufferEmpty()) {
                    HttpConnection.this.fillInterested();
                } else if (HttpConnection.this.getConnector().isRunning()) {
                    try {
                        HttpConnection.this.getExecutor().execute(HttpConnection.this);
                    }
                    catch (RejectedExecutionException e) {
                        if (HttpConnection.this.getConnector().isRunning()) {
                            LOG.warn("Failed dispatch of {}", (Object)this, (Object)e);
                        } else {
                            LOG.trace("IGNORED", e);
                        }
                        HttpConnection.this.getEndPoint().close();
                    }
                } else {
                    HttpConnection.this.getEndPoint().close();
                }
            } else if (HttpConnection.this.getEndPoint().isOpen()) {
                HttpConnection.this.fillInterested();
            }
        }

        @Override
        public void failed(Throwable x) {
            HttpStreamOverHTTP1 stream = HttpConnection.this._stream.getAndSet(null);
            if (stream == null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("ignored", x);
                }
                return;
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("aborting", x);
            }
            this.abort(x);
        }

        private void abort(Throwable failure) {
            HttpConnection.this.getEndPoint().close(failure);
        }

        @Override
        public Invocable.InvocationType getInvocationType() {
            return HttpStream.super.getInvocationType();
        }
    }
}

