/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.websocket.core.server;

import java.util.function.Consumer;
import org.eclipse.jetty.http.pathmap.PathSpec;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.websocket.core.Configuration;
import org.eclipse.jetty.websocket.core.WebSocketComponents;
import org.eclipse.jetty.websocket.core.server.WebSocketMappings;
import org.eclipse.jetty.websocket.core.server.WebSocketNegotiator;

public class WebSocketUpgradeHandler
extends Handler.Wrapper {
    private final WebSocketMappings _mappings;
    private final Configuration.ConfigurationCustomizer _customizer = new Configuration.ConfigurationCustomizer();
    private final Consumer<WebSocketUpgradeHandler> _configurator;

    public WebSocketUpgradeHandler() {
        this(null, null);
    }

    public WebSocketUpgradeHandler(WebSocketComponents components) {
        this(components, null);
    }

    public WebSocketUpgradeHandler(Consumer<WebSocketUpgradeHandler> configurator) {
        this(null, configurator);
    }

    public WebSocketUpgradeHandler(WebSocketComponents components, Consumer<WebSocketUpgradeHandler> configurator) {
        this._mappings = new WebSocketMappings(components == null ? new WebSocketComponents() : components);
        this._configurator = configurator;
        this.addBean(this._mappings);
        this.setHandler(new Handler.Abstract.NonBlocking(){

            @Override
            public boolean handle(Request request, Response response, Callback callback) {
                Response.writeError(request, response, callback, 404);
                return true;
            }
        });
    }

    public void addMapping(String pathSpec, WebSocketNegotiator negotiator) {
        this._mappings.addMapping(WebSocketMappings.parsePathSpec(pathSpec), negotiator);
    }

    public void addMapping(PathSpec pathSpec, WebSocketNegotiator negotiator) {
        this._mappings.addMapping(pathSpec, negotiator);
    }

    @Override
    protected void doStart() throws Exception {
        if (this._configurator != null) {
            this._configurator.accept(this);
        }
        super.doStart();
    }

    public Configuration getConfiguration() {
        return this._customizer;
    }

    @Override
    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        try {
            if (this._mappings.upgrade(request, response, callback, this._customizer)) {
                return true;
            }
            return super.handle(request, response, callback);
        }
        catch (Throwable x) {
            Response.writeError(request, response, callback, x);
            return true;
        }
    }
}

