/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.plus.webapp;

import java.util.Set;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.eclipse.jetty.ee10.plus.webapp.PlusConfiguration;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.webapp.AbstractConfiguration;
import org.eclipse.jetty.ee10.webapp.FragmentConfiguration;
import org.eclipse.jetty.ee10.webapp.JettyWebXmlConfiguration;
import org.eclipse.jetty.ee10.webapp.MetaInfConfiguration;
import org.eclipse.jetty.ee10.webapp.WebAppClassLoader;
import org.eclipse.jetty.ee10.webapp.WebAppContext;
import org.eclipse.jetty.ee10.webapp.WebXmlConfiguration;
import org.eclipse.jetty.plus.jndi.EnvEntry;
import org.eclipse.jetty.plus.jndi.NamingEntryUtil;
import org.eclipse.jetty.util.jndi.NamingDump;
import org.eclipse.jetty.util.jndi.NamingUtil;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.resource.Resources;
import org.eclipse.jetty.xml.XmlConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvConfiguration
extends AbstractConfiguration {
    public static final String JETTY_ENV_XML = "org.eclipse.jetty.jndi.JettyEnvXml";
    private static final Logger LOG = LoggerFactory.getLogger(EnvConfiguration.class);
    private static final String JETTY_ENV_BINDINGS = "org.eclipse.jetty.jndi.EnvConfiguration";

    public EnvConfiguration() {
        super(new AbstractConfiguration.Builder().addDependencies(WebXmlConfiguration.class, MetaInfConfiguration.class, FragmentConfiguration.class).addDependents(PlusConfiguration.class, JettyWebXmlConfiguration.class).protectAndExpose("org.eclipse.jetty.jndi."));
    }

    @Override
    public void preConfigure(WebAppContext context) throws Exception {
        this.createEnvContext(context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void configure(WebAppContext context) throws Exception {
        Resource jettyEnv;
        Resource webInf;
        Resource jettyEnvXmlResource;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Created java:comp/env for webapp {}", (Object)context.getContextPath());
        }
        if ((jettyEnvXmlResource = (Resource)context.getAttribute(JETTY_ENV_XML)) == null && (webInf = context.getWebInf()) != null && webInf.isDirectory() && Resources.exists(jettyEnv = webInf.resolve("jetty-env.xml"))) {
            jettyEnvXmlResource = jettyEnv;
        }
        if (jettyEnvXmlResource != null) {
            Set<String> boundNamesBefore = NamingUtil.flattenBindings(new InitialContext(), "").keySet();
            try {
                XmlConfiguration configuration = new XmlConfiguration(jettyEnvXmlResource);
                configuration.setJettyStandardIdsAndProperties(context.getServer(), null);
                WebAppClassLoader.runWithServerClassAccess(() -> {
                    configuration.configure(context);
                    return null;
                });
            }
            finally {
                Set<String> boundNamesAfter = NamingUtil.flattenBindings(new InitialContext(), "").keySet();
                boundNamesAfter.removeAll(boundNamesBefore);
                context.setAttribute(JETTY_ENV_BINDINGS, boundNamesAfter);
            }
        }
        this.bindEnvEntries(context);
        context.addBean(new NamingDump(context.getClassLoader(), "java:comp"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deconfigure(WebAppContext context) throws Exception {
        Dumper dumper = context.getBean(Dumper.class);
        if (dumper != null) {
            context.removeBean(dumper);
        }
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(context.getClassLoader());
        try {
            InitialContext ic = new InitialContext();
            Context compCtx = (Context)ic.lookup("java:comp");
            compCtx.destroySubcontext("env");
            Set jettyEnvBoundNames = (Set)context.getAttribute(JETTY_ENV_BINDINGS);
            context.setAttribute(JETTY_ENV_BINDINGS, null);
            if (jettyEnvBoundNames != null) {
                for (String name : jettyEnvBoundNames) {
                    NamingUtil.unbind(ic, name, true);
                }
            }
        }
        catch (NameNotFoundException e) {
            LOG.warn("Unable to destroy InitialContext", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    @Override
    public void destroy(WebAppContext context) throws Exception {
        try {
            NamingEntryUtil.destroyContextForScope(context);
        }
        catch (NameNotFoundException e) {
            LOG.trace("IGNORED", e);
            LOG.debug("No jndi entries scoped to webapp {}", (Object)context);
        }
        catch (NamingException e) {
            LOG.debug("Error unbinding jndi entries scoped to webapp {}", (Object)context, (Object)e);
        }
    }

    public void bindEnvEntries(WebAppContext context) throws NamingException {
        InitialContext ic = new InitialContext();
        Context envCtx = (Context)ic.lookup("java:comp/env");
        LOG.debug("Binding env entries from the jvm scope");
        this.doBindings(envCtx, null);
        LOG.debug("Binding env entries from the server scope");
        this.doBindings(envCtx, context.getServer());
        LOG.debug("Binding env entries from environment {} scope", (Object)ServletContextHandler.__environment.getName());
        this.doBindings(envCtx, ServletContextHandler.__environment.getName());
        LOG.debug("Binding env entries from the context scope");
        this.doBindings(envCtx, context);
    }

    private void doBindings(Context envCtx, Object scope) throws NamingException {
        for (EnvEntry ee : NamingEntryUtil.lookupNamingEntries(scope, EnvEntry.class)) {
            ee.bindToENC(ee.getJndiName());
            Name namingEntryName = NamingEntryUtil.makeNamingEntryName(null, ee);
            NamingUtil.bind(envCtx, namingEntryName.toString(), ee);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createEnvContext(WebAppContext wac) throws NamingException {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(wac.getClassLoader());
        try {
            InitialContext context = new InitialContext();
            Context compCtx = (Context)context.lookup("java:comp");
            compCtx.createSubcontext("env");
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
    }

    private static class Dumper
    extends NamingDump {
        Dumper(ClassLoader loader, String name) {
            super(loader, name);
        }
    }
}

