/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.ee10.webapp;

import jakarta.servlet.Servlet;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jetty.ee10.servlet.ServletContextHandler;
import org.eclipse.jetty.ee10.webapp.Descriptor;
import org.eclipse.jetty.ee10.webapp.MetaData;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.xml.XmlParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebDescriptor
extends Descriptor {
    private static final Logger LOG = LoggerFactory.getLogger(WebDescriptor.class);
    public static XmlParser __nonValidatingStaticParser = WebDescriptor.newParser(false);
    protected MetaData.Complete _metaDataComplete;
    protected int _majorVersion = 4;
    protected int _minorVersion = 0;
    protected ArrayList<String> _classNames = new ArrayList();
    protected boolean _distributable;
    protected boolean _isOrdered = false;
    protected List<String> _ordering = new ArrayList<String>();

    public static boolean isMetaDataComplete(WebDescriptor d) {
        return d != null && d.getMetaDataComplete() == MetaData.Complete.True;
    }

    public static XmlParser getParser(boolean validating) {
        if (!validating) {
            return __nonValidatingStaticParser;
        }
        return WebDescriptor.newParser(true);
    }

    public static XmlParser newParser(boolean validating) {
        try {
            return new WebDescriptorParser(validating);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to instantiate WebDescriptorParser", e);
        }
    }

    public WebDescriptor(Resource xml) {
        super(xml);
    }

    @Override
    public void parse(XmlParser parser) throws Exception {
        super.parse(parser);
        this.processVersion();
        this.processOrdering();
        this.processDistributable();
    }

    public MetaData.Complete getMetaDataComplete() {
        return this._metaDataComplete;
    }

    public int getMajorVersion() {
        return this._majorVersion;
    }

    public int getMinorVersion() {
        return this._minorVersion;
    }

    public void processVersion() {
        String version = this._root.getAttribute("version", "DTD");
        if ("DTD".equals(version)) {
            this._majorVersion = 2;
            this._minorVersion = 3;
            if (this._dtd != null && this._dtd.indexOf("web-app_2_2") >= 0) {
                this._majorVersion = 2;
                this._minorVersion = 2;
            }
        } else {
            int dot = version.indexOf(".");
            if (dot > 0) {
                this._majorVersion = Integer.parseInt(version.substring(0, dot));
                this._minorVersion = Integer.parseInt(version.substring(dot + 1));
            }
        }
        if (this._majorVersion <= 2 && this._minorVersion < 5) {
            this._metaDataComplete = MetaData.Complete.True;
        } else {
            String s = this._root.getAttribute("metadata-complete");
            if (s == null) {
                this._metaDataComplete = MetaData.Complete.NotSet;
            } else {
                MetaData.Complete complete = this._metaDataComplete = Boolean.valueOf(s) != false ? MetaData.Complete.True : MetaData.Complete.False;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{}: Calculated metadatacomplete = {} with version = {}", new Object[]{this._xml.toString(), this._metaDataComplete, version});
        }
    }

    public void processOrdering() {
        XmlParser.Node ordering = this._root.get("absolute-ordering");
        if (ordering == null) {
            return;
        }
        this._isOrdered = true;
        Iterator iter = ordering.iterator();
        XmlParser.Node node = null;
        while (iter.hasNext()) {
            Object o = iter.next();
            if (!(o instanceof XmlParser.Node)) continue;
            node = (XmlParser.Node)o;
            if (node.getTag().equalsIgnoreCase("others")) {
                this._ordering.add("others");
                continue;
            }
            if (!node.getTag().equalsIgnoreCase("name")) continue;
            this._ordering.add(node.toString(false, true));
        }
    }

    public void processDistributable() {
        XmlParser.Node distributable = this._root.get("distributable");
        if (distributable == null) {
            return;
        }
        this._distributable = true;
    }

    public void addClassName(String className) {
        if (!this._classNames.contains(className)) {
            this._classNames.add(className);
        }
    }

    public ArrayList<String> getClassNames() {
        return this._classNames;
    }

    public boolean isDistributable() {
        return this._distributable;
    }

    public boolean isOrdered() {
        return this._isOrdered;
    }

    public List<String> getOrdering() {
        return this._ordering;
    }

    private static class WebDescriptorParser
    extends XmlParser {
        public WebDescriptorParser(boolean validating) throws IOException {
            super(validating);
            String catalogName = "catalog-%s.xml".formatted(ServletContextHandler.__environment.getName());
            URL url = WebDescriptor.class.getResource(catalogName);
            if (url == null) {
                throw new IllegalStateException("Catalog not found: %s/%s".formatted(WebDescriptor.class.getPackageName(), catalogName));
            }
            this.addCatalog(URI.create(url.toExternalForm()), Servlet.class);
        }
    }
}

