/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi;

public class FCGI {
    private FCGI() {
    }

    public static class Headers {
        public static final String AUTH_TYPE = "AUTH_TYPE";
        public static final String CONTENT_LENGTH = "CONTENT_LENGTH";
        public static final String CONTENT_TYPE = "CONTENT_TYPE";
        public static final String DOCUMENT_ROOT = "DOCUMENT_ROOT";
        public static final String DOCUMENT_URI = "DOCUMENT_URI";
        public static final String GATEWAY_INTERFACE = "GATEWAY_INTERFACE";
        public static final String HTTPS = "HTTPS";
        public static final String PATH_INFO = "PATH_INFO";
        public static final String QUERY_STRING = "QUERY_STRING";
        public static final String REMOTE_ADDR = "REMOTE_ADDR";
        public static final String REMOTE_PORT = "REMOTE_PORT";
        public static final String REQUEST_METHOD = "REQUEST_METHOD";
        public static final String REQUEST_URI = "REQUEST_URI";
        public static final String SCRIPT_FILENAME = "SCRIPT_FILENAME";
        public static final String SCRIPT_NAME = "SCRIPT_NAME";
        public static final String SERVER_ADDR = "SERVER_ADDR";
        public static final String SERVER_NAME = "SERVER_NAME";
        public static final String SERVER_PORT = "SERVER_PORT";
        public static final String SERVER_PROTOCOL = "SERVER_PROTOCOL";
        public static final String SERVER_SOFTWARE = "SERVER_SOFTWARE";

        private Headers() {
        }
    }

    public static enum StreamType {
        STD_IN,
        STD_OUT,
        STD_ERR;

    }

    public static enum FrameType {
        BEGIN_REQUEST(1),
        ABORT_REQUEST(2),
        END_REQUEST(3),
        PARAMS(4),
        STDIN(5),
        STDOUT(6),
        STDERR(7),
        DATA(8),
        GET_VALUES(9),
        GET_VALUES_RESULT(10);

        public final int code;

        public static FrameType from(int code) {
            return switch (code) {
                case 1 -> BEGIN_REQUEST;
                case 2 -> ABORT_REQUEST;
                case 3 -> END_REQUEST;
                case 4 -> PARAMS;
                case 5 -> STDIN;
                case 6 -> STDOUT;
                case 7 -> STDERR;
                case 8 -> DATA;
                case 9 -> GET_VALUES;
                case 10 -> GET_VALUES_RESULT;
                default -> throw new IllegalArgumentException("unknown frame type " + code);
            };
        }

        private FrameType(int code) {
            this.code = code;
        }
    }

    public static enum Role {
        RESPONDER(1),
        AUTHORIZER(2),
        FILTER(3);

        public final int code;

        public static Role from(int code) {
            return switch (code) {
                case 1 -> RESPONDER;
                case 2 -> AUTHORIZER;
                case 3 -> FILTER;
                default -> throw new IllegalArgumentException();
            };
        }

        private Role(int code) {
            this.code = code;
        }
    }
}

