/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.fcgi.client.transport.internal;

import org.eclipse.jetty.client.Connection;
import org.eclipse.jetty.client.Result;
import org.eclipse.jetty.client.transport.HttpChannel;
import org.eclipse.jetty.client.transport.HttpExchange;
import org.eclipse.jetty.client.transport.HttpReceiver;
import org.eclipse.jetty.client.transport.HttpSender;
import org.eclipse.jetty.fcgi.client.transport.internal.HttpConnectionOverFCGI;
import org.eclipse.jetty.fcgi.client.transport.internal.HttpReceiverOverFCGI;
import org.eclipse.jetty.fcgi.client.transport.internal.HttpSenderOverFCGI;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;

public class HttpChannelOverFCGI
extends HttpChannel {
    private final HttpConnectionOverFCGI connection;
    private final HttpSenderOverFCGI sender;
    private final HttpReceiverOverFCGI receiver;
    private int request;
    private HttpVersion version;

    public HttpChannelOverFCGI(HttpConnectionOverFCGI connection) {
        super(connection.getHttpDestination());
        this.connection = connection;
        this.sender = new HttpSenderOverFCGI(this);
        this.receiver = new HttpReceiverOverFCGI(this);
    }

    public HttpConnectionOverFCGI getHttpConnection() {
        return this.connection;
    }

    protected int getRequest() {
        return this.request;
    }

    void setRequest(int request) {
        this.request = request;
    }

    protected Connection getConnection() {
        return this.connection;
    }

    protected HttpSender getHttpSender() {
        return this.sender;
    }

    protected HttpReceiver getHttpReceiver() {
        return this.receiver;
    }

    public void send(HttpExchange exchange) {
        this.version = exchange.getRequest().getVersion();
        this.sender.send(exchange);
    }

    public void release() {
        this.connection.release();
    }

    protected void responseBegin(int code, String reason) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            return;
        }
        exchange.getResponse().version(this.version).status(code).reason(reason);
        this.receiver.responseBegin(exchange);
    }

    protected void responseHeader(HttpField field) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange != null) {
            this.receiver.responseHeader(exchange, field);
        }
    }

    protected void responseHeaders() {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange != null) {
            this.receiver.responseHeaders(exchange);
        }
    }

    protected void content(Content.Chunk chunk) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange != null) {
            this.receiver.content(chunk);
        }
    }

    protected void responseContentAvailable() {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange != null) {
            this.receiver.responseContentAvailable(exchange);
        }
    }

    protected void end() {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange != null) {
            this.receiver.end();
        }
    }

    protected void responseSuccess() {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange != null) {
            this.receiver.responseSuccess(exchange);
        }
    }

    protected void responseFailure(Throwable failure, Promise<Boolean> promise) {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange != null) {
            this.receiver.responseFailure(failure, promise);
        } else {
            promise.succeeded((Object)false);
        }
    }

    void eof() {
        HttpExchange exchange = this.getHttpExchange();
        if (exchange == null) {
            this.connection.close();
        }
    }

    public void exchangeTerminated(HttpExchange exchange, Result result) {
        super.exchangeTerminated(exchange, result);
        HttpFields responseHeaders = result.getResponse().getHeaders();
        if (result.isFailed()) {
            this.connection.close(result.getFailure());
        } else if (this.connection.isShutdown() || this.connection.isCloseByHTTP(responseHeaders)) {
            this.connection.close();
        } else {
            this.release();
        }
    }

    protected void flush(ByteBufferPool.Accumulator accumulator, Callback callback) {
        this.connection.getFlusher().flush(accumulator, callback);
    }

    void receive() {
        this.receiver.receive();
    }
}

