/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.client.http;

import java.net.URI;
import java.util.function.Supplier;
import org.eclipse.jetty.client.HttpChannel;
import org.eclipse.jetty.client.HttpContent;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.client.HttpRequest;
import org.eclipse.jetty.client.HttpSender;
import org.eclipse.jetty.client.api.Request;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.client.http.HttpChannelOverHTTP2;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;

public class HttpSenderOverHTTP2
extends HttpSender {
    public HttpSenderOverHTTP2(HttpChannelOverHTTP2 channel) {
        super((HttpChannel)channel);
    }

    protected HttpChannelOverHTTP2 getHttpChannel() {
        return (HttpChannelOverHTTP2)super.getHttpChannel();
    }

    protected void sendHeaders(HttpExchange exchange, final HttpContent content, final Callback callback) {
        final HttpRequest request = exchange.getRequest();
        String path = this.relativize(request.getPath());
        HttpURI uri = HttpURI.createHttpURI((String)request.getScheme(), (String)request.getHost(), (int)request.getPort(), (String)path, null, (String)request.getQuery(), null);
        MetaData.Request metaData = new MetaData.Request(request.getMethod(), uri, HttpVersion.HTTP_2, request.getHeaders());
        final Supplier trailers = request.getTrailers();
        metaData.setTrailerSupplier(trailers);
        HeadersFrame headersFrame = new HeadersFrame((MetaData)metaData, null, trailers == null && !content.hasContent());
        HttpChannelOverHTTP2 channel = this.getHttpChannel();
        Promise<Stream> promise = new Promise<Stream>(){

            public void succeeded(Stream stream) {
                HttpSenderOverHTTP2.this.getHttpChannel().setStream(stream);
                stream.setIdleTimeout(request.getIdleTimeout());
                if (content.hasContent() && !HttpSenderOverHTTP2.this.expects100Continue((Request)request)) {
                    boolean lastContent;
                    boolean advanced = content.advance();
                    boolean bl = lastContent = trailers == null && content.isLast();
                    if (advanced || lastContent) {
                        DataFrame dataFrame = new DataFrame(stream.getId(), content.getByteBuffer(), lastContent);
                        stream.data(dataFrame, callback);
                        return;
                    }
                }
                callback.succeeded();
            }

            public void failed(Throwable failure) {
                callback.failed(failure);
            }
        };
        channel.getSession().newStream(headersFrame, (Promise)promise, channel.getStreamListener());
    }

    private String relativize(String path) {
        try {
            String result = path;
            URI uri = URI.create(result);
            if (uri.isAbsolute()) {
                result = uri.getPath();
            }
            return result.isEmpty() ? "/" : result;
        }
        catch (Throwable x) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Could not relativize " + path, new Object[0]);
            }
            return path;
        }
    }

    protected void sendContent(HttpExchange exchange, HttpContent content, Callback callback) {
        if (content.isConsumed()) {
            callback.succeeded();
        } else {
            Stream stream = this.getHttpChannel().getStream();
            Supplier trailers = exchange.getRequest().getTrailers();
            DataFrame frame = new DataFrame(stream.getId(), content.getByteBuffer(), trailers == null && content.isLast());
            stream.data(frame, callback);
        }
    }

    protected void sendTrailers(HttpExchange exchange, Callback callback) {
        Supplier trailers = exchange.getRequest().getTrailers();
        MetaData metaData = new MetaData(HttpVersion.HTTP_2, (HttpFields)trailers.get());
        Stream stream = this.getHttpChannel().getStream();
        HeadersFrame trailersFrame = new HeadersFrame(stream.getId(), metaData, null, true);
        stream.headers(trailersFrame, callback);
    }
}

