/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.server;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import org.eclipse.jetty.http.BadMessageException;
import org.eclipse.jetty.http.HttpField;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.ErrorCode;
import org.eclipse.jetty.http2.HTTP2Connection;
import org.eclipse.jetty.http2.ISession;
import org.eclipse.jetty.http2.IStream;
import org.eclipse.jetty.http2.api.Session;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.api.server.ServerSessionListener;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.Frame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PrefaceFrame;
import org.eclipse.jetty.http2.frames.ResetFrame;
import org.eclipse.jetty.http2.frames.SettingsFrame;
import org.eclipse.jetty.http2.parser.Parser;
import org.eclipse.jetty.http2.parser.ServerParser;
import org.eclipse.jetty.http2.parser.SettingsBodyParser;
import org.eclipse.jetty.http2.server.HttpChannelOverHTTP2;
import org.eclipse.jetty.http2.server.HttpTransportOverHTTP2;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.util.B64Code;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.TypeUtil;
import org.eclipse.jetty.util.thread.ExecutionStrategy;

public class HTTP2ServerConnection
extends HTTP2Connection
implements Connection.UpgradeTo {
    private final Queue<HttpChannelOverHTTP2> channels = new ArrayDeque<HttpChannelOverHTTP2>();
    private final List<Frame> upgradeFrames = new ArrayList<Frame>();
    private final AtomicLong totalRequests = new AtomicLong();
    private final AtomicLong totalResponses = new AtomicLong();
    private final ServerSessionListener listener;
    private final HttpConfiguration httpConfig;

    public HTTP2ServerConnection(ByteBufferPool byteBufferPool, Executor executor, EndPoint endPoint, HttpConfiguration httpConfig, ServerParser parser, ISession session, int inputBufferSize, ServerSessionListener listener) {
        this(byteBufferPool, executor, endPoint, httpConfig, parser, session, inputBufferSize, ExecutionStrategy.Factory.getDefault(), listener);
    }

    public HTTP2ServerConnection(ByteBufferPool byteBufferPool, Executor executor, EndPoint endPoint, HttpConfiguration httpConfig, ServerParser parser, ISession session, int inputBufferSize, ExecutionStrategy.Factory executionFactory, ServerSessionListener listener) {
        super(byteBufferPool, executor, endPoint, (Parser)parser, session, inputBufferSize, executionFactory);
        this.listener = listener;
        this.httpConfig = httpConfig;
    }

    public int getMessagesIn() {
        return this.totalRequests.intValue();
    }

    public int getMessagesOut() {
        return this.totalResponses.intValue();
    }

    protected ServerParser getParser() {
        return (ServerParser)super.getParser();
    }

    public void onUpgradeTo(ByteBuffer buffer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("HTTP2 onUpgradeTo {} {}", new Object[]{this, BufferUtil.toDetailString((ByteBuffer)buffer)});
        }
        this.setInputBuffer(buffer);
    }

    public void onOpen() {
        this.notifyAccept(this.getSession());
        for (Frame frame : this.upgradeFrames) {
            this.getSession().onFrame(frame);
        }
        super.onOpen();
    }

    private void notifyAccept(ISession session) {
        try {
            this.listener.onAccept((Session)session);
        }
        catch (Throwable x) {
            LOG.info("Failure while notifying listener " + this.listener, x);
        }
    }

    public void onNewStream(Connector connector, IStream stream, HeadersFrame frame) {
        HttpChannelOverHTTP2 channel;
        Runnable task;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing {} on {}", new Object[]{frame, stream});
        }
        if ((task = (channel = this.provideHttpChannel(connector, stream)).onRequest(frame)) != null) {
            this.offerTask(task, false);
        }
    }

    public void onData(IStream stream, DataFrame frame, Callback callback) {
        HttpChannelOverHTTP2 channel;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing {} on {}", new Object[]{frame, stream});
        }
        if ((channel = (HttpChannelOverHTTP2)((Object)stream.getAttribute(IStream.CHANNEL_ATTRIBUTE))) != null) {
            Runnable task = channel.onRequestContent(frame, callback);
            if (task != null) {
                this.offerTask(task, false);
            }
        } else {
            callback.failed((Throwable)new IOException("channel_not_found"));
        }
    }

    public boolean onStreamTimeout(IStream stream, Throwable failure) {
        boolean result;
        HttpChannelOverHTTP2 channel = (HttpChannelOverHTTP2)((Object)stream.getAttribute(IStream.CHANNEL_ATTRIBUTE));
        boolean bl = result = channel != null && channel.onStreamTimeout(failure);
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} idle timeout on {}: {}", new Object[]{result ? "Processed" : "Ignored", stream, failure});
        }
        return result;
    }

    public void onStreamFailure(IStream stream, Throwable failure) {
        HttpChannelOverHTTP2 channel;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing failure on {}: {}", new Object[]{stream, failure});
        }
        if ((channel = (HttpChannelOverHTTP2)((Object)stream.getAttribute(IStream.CHANNEL_ATTRIBUTE))) != null) {
            channel.onFailure(failure);
        }
    }

    public boolean onSessionTimeout(Throwable failure) {
        ISession session = this.getSession();
        boolean result = true;
        for (Stream stream : session.getStreams()) {
            HttpChannelOverHTTP2 channel = (HttpChannelOverHTTP2)((Object)stream.getAttribute(IStream.CHANNEL_ATTRIBUTE));
            if (channel == null) continue;
            result &= !channel.isRequestExecuting();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("{} idle timeout on {}: {}", new Object[]{result ? "Processed" : "Ignored", session, failure});
        }
        return result;
    }

    public void onSessionFailure(Throwable failure) {
        ISession session = this.getSession();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing failure on {}: {}", new Object[]{session, failure});
        }
        for (Stream stream : session.getStreams()) {
            this.onStreamFailure((IStream)stream, failure);
        }
    }

    public void push(Connector connector, IStream stream, MetaData.Request request) {
        HttpChannelOverHTTP2 channel;
        Runnable task;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Processing push {} on {}", new Object[]{request, stream});
        }
        if ((task = (channel = this.provideHttpChannel(connector, stream)).onPushRequest(request)) != null) {
            this.offerTask(task, true);
        }
    }

    private HttpChannelOverHTTP2 provideHttpChannel(Connector connector, IStream stream) {
        HttpChannelOverHTTP2 channel = this.pollChannel();
        if (channel != null) {
            channel.getHttpTransport().setStream(stream);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Recycling channel {} for {}", new Object[]{channel, this});
            }
        } else {
            HttpTransportOverHTTP2 transport = new HttpTransportOverHTTP2(connector, this);
            transport.setStream(stream);
            channel = this.newServerHttpChannelOverHTTP2(connector, this.httpConfig, transport);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Creating channel {} for {}", new Object[]{channel, this});
            }
        }
        stream.setAttribute(IStream.CHANNEL_ATTRIBUTE, (Object)channel);
        return channel;
    }

    protected ServerHttpChannelOverHTTP2 newServerHttpChannelOverHTTP2(Connector connector, HttpConfiguration httpConfig, HttpTransportOverHTTP2 transport) {
        return new ServerHttpChannelOverHTTP2(connector, httpConfig, this.getEndPoint(), transport);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void offerChannel(HttpChannelOverHTTP2 channel) {
        HTTP2ServerConnection hTTP2ServerConnection = this;
        synchronized (hTTP2ServerConnection) {
            this.channels.offer(channel);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpChannelOverHTTP2 pollChannel() {
        HTTP2ServerConnection hTTP2ServerConnection = this;
        synchronized (hTTP2ServerConnection) {
            return this.channels.poll();
        }
    }

    public boolean upgrade(MetaData.Request request) {
        if (HttpMethod.PRI.is(request.getMethod())) {
            this.getParser().directUpgrade();
        } else {
            SettingsFrame settingsFrame;
            HttpField settingsField = request.getFields().getField(HttpHeader.HTTP2_SETTINGS);
            if (settingsField == null) {
                throw new BadMessageException("Missing " + HttpHeader.HTTP2_SETTINGS + " header");
            }
            String value = settingsField.getValue();
            byte[] settings = B64Code.decodeRFC4648URL((String)(value == null ? "" : value));
            if (LOG.isDebugEnabled()) {
                LOG.debug("{} settings {}", new Object[]{this, TypeUtil.toHexString((byte[])settings)});
            }
            if ((settingsFrame = SettingsBodyParser.parseBody((ByteBuffer)BufferUtil.toBuffer((byte[])settings))) == null) {
                LOG.warn("Invalid {} header value: {}", new Object[]{HttpHeader.HTTP2_SETTINGS, value});
                throw new BadMessageException();
            }
            this.getParser().standardUpgrade();
            this.upgradeFrames.add((Frame)new PrefaceFrame());
            this.upgradeFrames.add((Frame)settingsFrame);
            this.upgradeFrames.add((Frame)new HeadersFrame(1, (MetaData)new MetaData.Request(request), null, true));
        }
        return true;
    }

    protected class ServerHttpChannelOverHTTP2
    extends HttpChannelOverHTTP2
    implements ExecutionStrategy.Rejectable {
        public ServerHttpChannelOverHTTP2(Connector connector, HttpConfiguration configuration, EndPoint endPoint, HttpTransportOverHTTP2 transport) {
            super(connector, configuration, endPoint, transport);
        }

        @Override
        public Runnable onRequest(HeadersFrame frame) {
            HTTP2ServerConnection.this.totalRequests.incrementAndGet();
            return super.onRequest(frame);
        }

        public void onCompleted() {
            HTTP2ServerConnection.this.totalResponses.incrementAndGet();
            super.onCompleted();
            if (!this.getStream().isReset()) {
                this.recycle();
            }
        }

        @Override
        public void recycle() {
            this.getStream().removeAttribute(IStream.CHANNEL_ATTRIBUTE);
            super.recycle();
            HTTP2ServerConnection.this.offerChannel(this);
        }

        public void reject() {
            IStream stream = this.getStream();
            if (LOG.isDebugEnabled()) {
                LOG.debug("HTTP2 Request #{}/{} rejected", new Object[]{stream.getId(), Integer.toHexString(stream.getSession().hashCode())});
            }
            stream.reset(new ResetFrame(stream.getId(), ErrorCode.ENHANCE_YOUR_CALM_ERROR.code), Callback.NOOP);
            this.consumeInput();
        }
    }
}

