/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.api;

import java.util.concurrent.CompletableFuture;
import org.eclipse.jetty.http2.api.Session;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PushPromiseFrame;
import org.eclipse.jetty.http2.frames.ResetFrame;
import org.eclipse.jetty.io.Retainable;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.Promise;

public interface Stream {
    public int getId();

    public Listener getListener();

    public Session getSession();

    default public CompletableFuture<Stream> headers(HeadersFrame frame) {
        Promise.Completable result = new Promise.Completable();
        this.headers(frame, Callback.from(() -> result.succeeded((Object)this), arg_0 -> ((Promise.Completable)result).failed(arg_0)));
        return result;
    }

    public void headers(HeadersFrame var1, Callback var2);

    default public CompletableFuture<Stream> push(PushPromiseFrame frame, Listener listener) {
        Promise.Completable result = new Promise.Completable();
        this.push(frame, (Promise<Stream>)result, listener);
        return result;
    }

    public void push(PushPromiseFrame var1, Promise<Stream> var2, Listener var3);

    public Data readData();

    default public CompletableFuture<Stream> data(DataFrame frame) {
        Promise.Completable result = new Promise.Completable();
        this.data(frame, Callback.from(() -> result.succeeded((Object)this), arg_0 -> ((Promise.Completable)result).failed(arg_0)));
        return result;
    }

    public void data(DataFrame var1, Callback var2);

    public void reset(ResetFrame var1, Callback var2);

    public Object getAttribute(String var1);

    public void setAttribute(String var1, Object var2);

    public Object removeAttribute(String var1);

    public boolean isLocal();

    public boolean isReset();

    public boolean isRemotelyClosed();

    public boolean isClosed();

    public long getIdleTimeout();

    public void setIdleTimeout(long var1);

    public void demand();

    public static interface Listener {
        default public void onNewStream(Stream stream) {
        }

        default public void onHeaders(Stream stream, HeadersFrame frame) {
            stream.demand();
        }

        default public Listener onPush(Stream stream, PushPromiseFrame frame) {
            return null;
        }

        default public void onDataAvailable(Stream stream) {
        }

        default public void onReset(Stream stream, ResetFrame frame, Callback callback) {
            callback.succeeded();
        }

        default public boolean onIdleTimeout(Stream stream, Throwable x) {
            return true;
        }

        default public void onFailure(Stream stream, int error, String reason, Throwable failure, Callback callback) {
            callback.succeeded();
        }

        default public void onClosed(Stream stream) {
        }
    }

    public static abstract class Data
    implements Retainable {
        private final DataFrame frame;

        public static Data eof(int streamId) {
            return new EOF(streamId);
        }

        public Data(DataFrame frame) {
            this.frame = frame;
        }

        public DataFrame frame() {
            return this.frame;
        }

        public void retain() {
            throw new UnsupportedOperationException();
        }

        public boolean release() {
            return true;
        }

        public String toString() {
            return "%s@%x[%s]".formatted(this.getClass().getSimpleName(), this.hashCode(), this.frame());
        }

        private static class EOF
        extends Data {
            public EOF(int streamId) {
                super(new DataFrame(streamId, BufferUtil.EMPTY_BUFFER, true));
            }
        }
    }
}

