/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadPendingException;
import java.nio.channels.WritePendingException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.http2.HTTP2Stream;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.io.EndPoint;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.util.BufferUtil;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.IO;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HTTP2StreamEndPoint
implements EndPoint {
    private static final Logger LOG = LoggerFactory.getLogger(HTTP2StreamEndPoint.class);
    private final AtomicReference<WriteState> writeState = new AtomicReference<WriteState>(WriteState.IDLE);
    private final AtomicReference<Callback> readCallback = new AtomicReference();
    private final long created = System.currentTimeMillis();
    private final HTTP2Stream stream;
    private final AtomicBoolean eof = new AtomicBoolean();
    private final AtomicBoolean closed = new AtomicBoolean();
    private final AtomicReference<Throwable> failure = new AtomicReference();
    private final AtomicReference<Stream.Data> data = new AtomicReference();
    private Connection connection;

    public HTTP2StreamEndPoint(HTTP2Stream stream) {
        this.stream = stream;
    }

    public InetSocketAddress getLocalAddress() {
        SocketAddress local = this.getLocalSocketAddress();
        if (local instanceof InetSocketAddress) {
            return (InetSocketAddress)local;
        }
        return null;
    }

    public SocketAddress getLocalSocketAddress() {
        return this.stream.getSession().getLocalSocketAddress();
    }

    public InetSocketAddress getRemoteAddress() {
        SocketAddress remote = this.getRemoteSocketAddress();
        if (remote instanceof InetSocketAddress) {
            return (InetSocketAddress)remote;
        }
        return null;
    }

    public SocketAddress getRemoteSocketAddress() {
        return this.stream.getSession().getRemoteSocketAddress();
    }

    public boolean isOpen() {
        return !this.closed.get();
    }

    public long getCreatedTimeStamp() {
        return this.created;
    }

    public void shutdownOutput() {
        block5: while (true) {
            WriteState current = this.writeState.get();
            switch (current.state) {
                case IDLE: 
                case OSHUTTING: {
                    if (!this.writeState.compareAndSet(current, WriteState.OSHUT)) continue block5;
                    Callback oshutCallback = Callback.from((Invocable.InvocationType)Invocable.InvocationType.NON_BLOCKING, this::oshutSuccess, this::oshutFailure);
                    this.stream.data(new DataFrame(this.stream.getId(), BufferUtil.EMPTY_BUFFER, true), oshutCallback);
                    return;
                }
                case PENDING: {
                    if (!this.writeState.compareAndSet(current, WriteState.OSHUTTING)) continue block5;
                    return;
                }
                case OSHUT: 
                case FAILED: {
                    return;
                }
            }
        }
    }

    private void oshutSuccess() {
        WriteState current = this.writeState.get();
        switch (current.state) {
            case IDLE: 
            case OSHUTTING: 
            case PENDING: {
                throw new IllegalStateException();
            }
        }
    }

    private void oshutFailure(Throwable failure) {
        block5: while (true) {
            WriteState current = this.writeState.get();
            switch (current.state) {
                case IDLE: 
                case OSHUTTING: 
                case PENDING: {
                    throw new IllegalStateException();
                }
                case OSHUT: {
                    if (!this.writeState.compareAndSet(current, new WriteState(WriteState.State.FAILED, failure))) continue block5;
                    return;
                }
                case FAILED: {
                    return;
                }
            }
        }
    }

    public boolean isOutputShutdown() {
        WriteState.State state = this.writeState.get().state;
        return state == WriteState.State.OSHUTTING || state == WriteState.State.OSHUT;
    }

    public boolean isInputShutdown() {
        return this.eof.get();
    }

    public void close(Throwable cause) {
        if (this.closed.compareAndSet(false, true)) {
            Stream.Data data;
            if (LOG.isDebugEnabled()) {
                LOG.debug("closing {}", (Object)this, (Object)cause);
            }
            if ((data = (Stream.Data)this.data.getAndSet(null)) != null) {
                data.release();
            }
            this.shutdownOutput();
            this.stream.close();
            this.onClose(cause);
        }
    }

    public int fill(ByteBuffer sink) throws IOException {
        Stream.Data data = this.data.get();
        if (data != null) {
            return this.fillFromData(data, sink);
        }
        Throwable failure = this.failure.get();
        if (failure != null) {
            throw IO.rethrow((Throwable)failure);
        }
        if (this.eof.get()) {
            return -1;
        }
        data = this.stream.readData();
        this.data.set(data);
        if (LOG.isDebugEnabled()) {
            LOG.debug("filled {} on {}", (Object)data, (Object)this);
        }
        if (data == null) {
            return 0;
        }
        return this.fillFromData(data, sink);
    }

    private int fillFromData(Stream.Data data, ByteBuffer sink) {
        int length = 0;
        ByteBuffer source = data.frame().getByteBuffer();
        boolean hasContent = source.hasRemaining();
        if (hasContent) {
            int sinkPosition = BufferUtil.flipToFill((ByteBuffer)sink);
            int sourceLength = source.remaining();
            length = Math.min(sourceLength, sink.remaining());
            int sourceLimit = source.limit();
            source.limit(source.position() + length);
            sink.put(source);
            source.limit(sourceLimit);
            BufferUtil.flipToFlush((ByteBuffer)sink, (int)sinkPosition);
        }
        if (!source.hasRemaining()) {
            boolean endStream = data.frame().isEndStream();
            this.eof.set(endStream);
            data.release();
            this.data.set(null);
            if (!endStream) {
                this.stream.demand();
            }
            if (!hasContent) {
                length = endStream ? -1 : 0;
            }
        }
        return length;
    }

    public boolean flush(ByteBuffer ... buffers) throws IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("flushing {} on {}", (Object)BufferUtil.toDetailString((ByteBuffer[])buffers), (Object)this);
        }
        if (buffers == null || buffers.length == 0 || this.remaining(buffers) == 0L) {
            return true;
        }
        WriteState current = this.writeState.get();
        switch (current.state) {
            case IDLE: 
            case PENDING: {
                return false;
            }
            case OSHUTTING: 
            case OSHUT: {
                throw new EofException("Output shutdown");
            }
            case FAILED: {
                Throwable failure = current.failure;
                if (failure instanceof IOException) {
                    throw (IOException)failure;
                }
                throw new IOException(failure);
            }
        }
        throw new IllegalStateException("Unexpected state: " + String.valueOf((Object)current.state));
    }

    public Object getTransport() {
        return this.stream;
    }

    public long getIdleTimeout() {
        return this.stream.getIdleTimeout();
    }

    public void setIdleTimeout(long idleTimeout) {
        this.stream.setIdleTimeout(idleTimeout);
    }

    public void fillInterested(Callback callback) throws ReadPendingException {
        if (!this.tryFillInterested(callback)) {
            throw new ReadPendingException();
        }
    }

    public boolean tryFillInterested(Callback callback) {
        boolean result = this.readCallback.compareAndSet(null, callback);
        if (result) {
            if (this.data.get() != null) {
                this.process();
            } else {
                this.stream.demand();
            }
        }
        return result;
    }

    public boolean isFillInterested() {
        return this.readCallback.get() != null;
    }

    public void write(Callback callback, ByteBuffer ... buffers) throws WritePendingException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("writing {} on {}", (Object)BufferUtil.toDetailString((ByteBuffer[])buffers), (Object)this);
        }
        if (buffers != null && buffers.length != 0 && this.remaining(buffers) != 0L) {
            block6: while (true) {
                WriteState current = this.writeState.get();
                switch (current.state) {
                    case IDLE: {
                        if (!this.writeState.compareAndSet(current, WriteState.PENDING)) continue block6;
                        ByteBuffer result = this.coalesce(buffers);
                        Callback dataCallback = Callback.from((Invocable.InvocationType)Invocable.getInvocationType((Object)callback), () -> this.writeSuccess(callback), x -> this.writeFailure((Throwable)x, callback));
                        this.stream.data(new DataFrame(this.stream.getId(), result, false), dataCallback);
                        break block6;
                    }
                    case PENDING: {
                        callback.failed((Throwable)new WritePendingException());
                        break block6;
                    }
                    case OSHUTTING: 
                    case OSHUT: {
                        callback.failed((Throwable)new EofException("Output shutdown"));
                        break block6;
                    }
                    case FAILED: {
                        callback.failed(current.failure);
                        break block6;
                    }
                    default: {
                        callback.failed((Throwable)new IllegalStateException("Unexpected state: " + String.valueOf((Object)current.state)));
                    }
                }
                break;
            }
            return;
        }
        callback.succeeded();
    }

    private void writeSuccess(Callback callback) {
        block6: while (true) {
            WriteState current = this.writeState.get();
            switch (current.state) {
                case IDLE: 
                case OSHUT: {
                    callback.failed((Throwable)new IllegalStateException());
                    break block6;
                }
                case PENDING: {
                    if (!this.writeState.compareAndSet(current, WriteState.IDLE)) continue block6;
                    callback.succeeded();
                    break block6;
                }
                case OSHUTTING: {
                    callback.succeeded();
                    this.shutdownOutput();
                    break block6;
                }
                case FAILED: {
                    callback.failed(current.failure);
                    break block6;
                }
                default: {
                    callback.failed((Throwable)new IllegalStateException("Unexpected state: " + String.valueOf((Object)current.state)));
                }
            }
            break;
        }
    }

    private void writeFailure(Throwable failure, Callback callback) {
        block5: while (true) {
            WriteState current = this.writeState.get();
            switch (current.state) {
                case IDLE: 
                case OSHUT: {
                    callback.failed((Throwable)new IllegalStateException(failure));
                    break block5;
                }
                case OSHUTTING: 
                case PENDING: {
                    if (!this.writeState.compareAndSet(current, new WriteState(WriteState.State.FAILED, failure))) continue block5;
                    callback.failed(failure);
                    break block5;
                }
                case FAILED: {
                    break block5;
                }
                default: {
                    callback.failed((Throwable)new IllegalStateException("Unexpected state: " + String.valueOf((Object)current.state)));
                }
            }
            break;
        }
    }

    private long remaining(ByteBuffer ... buffers) {
        return BufferUtil.remaining((ByteBuffer[])buffers);
    }

    private ByteBuffer coalesce(ByteBuffer[] buffers) {
        if (buffers.length == 1) {
            return buffers[0];
        }
        long capacity = this.remaining(buffers);
        if (capacity > Integer.MAX_VALUE) {
            throw new BufferOverflowException();
        }
        ByteBuffer result = BufferUtil.allocateDirect((int)((int)capacity));
        for (ByteBuffer buffer : buffers) {
            BufferUtil.append((ByteBuffer)result, (ByteBuffer)buffer);
        }
        return result;
    }

    public Connection getConnection() {
        return this.connection;
    }

    public void setConnection(Connection connection) {
        this.connection = connection;
    }

    public void onOpen() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onOpen {}", (Object)this);
        }
    }

    public void onClose(Throwable cause) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("onClose {}", (Object)this);
        }
    }

    public void upgrade(Connection newConnection) {
        Connection oldConnection = this.getConnection();
        ByteBuffer buffer = null;
        if (oldConnection instanceof Connection.UpgradeFrom) {
            buffer = ((Connection.UpgradeFrom)oldConnection).onUpgradeFrom();
        }
        if (oldConnection != null) {
            oldConnection.onClose(null);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("upgrading from {} to {} with data {} on {}", new Object[]{oldConnection, newConnection, BufferUtil.toDetailString((ByteBuffer)buffer), this});
        }
        this.setConnection(newConnection);
        if (newConnection instanceof Connection.UpgradeTo && buffer != null) {
            ((Connection.UpgradeTo)newConnection).onUpgradeTo(buffer);
        }
        newConnection.onOpen();
    }

    protected void processDataAvailable() {
        this.process();
    }

    protected void processFailure(Throwable failure) {
        if (this.failure.compareAndSet(null, failure)) {
            this.process();
        }
    }

    private void process() {
        Callback callback = this.readCallback.getAndSet(null);
        if (callback != null) {
            callback.succeeded();
        }
    }

    public String toString() {
        return String.format("%s@%x[%s@%x#%d][w=%s]", this.getClass().getSimpleName(), this.hashCode(), this.stream.getClass().getSimpleName(), this.stream.hashCode(), this.stream.getId(), this.writeState);
    }

    private static class WriteState {
        public static final WriteState IDLE = new WriteState(State.IDLE);
        public static final WriteState PENDING = new WriteState(State.PENDING);
        public static final WriteState OSHUTTING = new WriteState(State.OSHUTTING);
        public static final WriteState OSHUT = new WriteState(State.OSHUT);
        private final State state;
        private final Throwable failure;

        private WriteState(State state) {
            this(state, null);
        }

        private WriteState(State state, Throwable failure) {
            this.state = state;
            this.failure = failure;
        }

        public String toString() {
            return this.state.toString();
        }

        private static enum State {
            IDLE,
            PENDING,
            OSHUTTING,
            OSHUT,
            FAILED;

        }
    }
}

