/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.parser;

import java.nio.ByteBuffer;
import org.eclipse.jetty.http2.frames.PriorityFrame;
import org.eclipse.jetty.io.ByteBufferPool;
import org.eclipse.jetty.io.RetainableByteBuffer;
import org.eclipse.jetty.util.BufferUtil;

public class HeaderBlockFragments {
    private final ByteBufferPool bufferPool;
    private PriorityFrame priorityFrame;
    private boolean endStream;
    private int streamId;
    private RetainableByteBuffer storage;

    public HeaderBlockFragments(ByteBufferPool bufferPool) {
        this.bufferPool = bufferPool;
    }

    public void storeFragment(ByteBuffer fragment, int length, boolean last) {
        if (this.storage == null) {
            int space = last ? length : length * 2;
            this.storage = this.bufferPool.acquire(space, fragment.isDirect());
            BufferUtil.flipToFill((ByteBuffer)this.storage.getByteBuffer());
        }
        if (this.storage.remaining() < length) {
            ByteBuffer byteBuffer = this.storage.getByteBuffer();
            int space = last ? length : length * 2;
            int capacity = byteBuffer.position() + space;
            RetainableByteBuffer newStorage = this.bufferPool.acquire(capacity, this.storage.isDirect());
            BufferUtil.flipToFill((ByteBuffer)newStorage.getByteBuffer());
            byteBuffer.flip();
            newStorage.getByteBuffer().put(byteBuffer);
            this.storage.release();
            this.storage = newStorage;
        }
        int limit = fragment.limit();
        fragment.limit(fragment.position() + length);
        this.storage.getByteBuffer().put(fragment);
        fragment.limit(limit);
    }

    public PriorityFrame getPriorityFrame() {
        return this.priorityFrame;
    }

    public void setPriorityFrame(PriorityFrame priorityFrame) {
        this.priorityFrame = priorityFrame;
    }

    public boolean isEndStream() {
        return this.endStream;
    }

    public void setEndStream(boolean endStream) {
        this.endStream = endStream;
    }

    public RetainableByteBuffer complete() {
        RetainableByteBuffer result = this.storage;
        this.storage = null;
        result.getByteBuffer().flip();
        return result;
    }

    public int getStreamId() {
        return this.streamId;
    }

    public void setStreamId(int streamId) {
        this.streamId = streamId;
    }
}

