/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.nio.channels.WritePendingException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.jetty.http.HttpFields;
import org.eclipse.jetty.http.HttpHeader;
import org.eclipse.jetty.http.HttpMethod;
import org.eclipse.jetty.http.MetaData;
import org.eclipse.jetty.http2.CloseState;
import org.eclipse.jetty.http2.ErrorCode;
import org.eclipse.jetty.http2.HTTP2Session;
import org.eclipse.jetty.http2.api.Stream;
import org.eclipse.jetty.http2.frames.DataFrame;
import org.eclipse.jetty.http2.frames.FailureFrame;
import org.eclipse.jetty.http2.frames.Frame;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.http2.frames.PushPromiseFrame;
import org.eclipse.jetty.http2.frames.ResetFrame;
import org.eclipse.jetty.http2.frames.StreamFrame;
import org.eclipse.jetty.http2.frames.WindowUpdateFrame;
import org.eclipse.jetty.io.CyclicTimeouts;
import org.eclipse.jetty.io.EofException;
import org.eclipse.jetty.util.Attachable;
import org.eclipse.jetty.util.Callback;
import org.eclipse.jetty.util.NanoTime;
import org.eclipse.jetty.util.Promise;
import org.eclipse.jetty.util.component.Dumpable;
import org.eclipse.jetty.util.thread.AutoLock;
import org.eclipse.jetty.util.thread.Invocable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTP2Stream
implements Stream,
Attachable,
Closeable,
Callback,
Dumpable,
CyclicTimeouts.Expirable {
    private static final Logger LOG = LoggerFactory.getLogger(HTTP2Stream.class);
    private final AutoLock lock = new AutoLock();
    private final Deque<Stream.Data> dataQueue = new ArrayDeque<Stream.Data>(1);
    private final AtomicReference<Object> attachment = new AtomicReference();
    private final AtomicReference<ConcurrentMap<String, Object>> attributes = new AtomicReference();
    private final AtomicReference<CloseState> closeState = new AtomicReference<CloseState>(CloseState.NOT_CLOSED);
    private final AtomicInteger sendWindow = new AtomicInteger();
    private final AtomicInteger recvWindow = new AtomicInteger();
    private final long creationNanoTime = NanoTime.now();
    private final HTTP2Session session;
    private final int streamId;
    private final MetaData.Request request;
    private final boolean local;
    private Callback sendCallback;
    private Throwable failure;
    private boolean localReset;
    private boolean remoteReset;
    private Stream.Listener listener;
    private long dataLength;
    private boolean dataDemand;
    private boolean dataStalled;
    private boolean committed;
    private long idleTimeout;
    private long expireNanoTime = Long.MAX_VALUE;

    public HTTP2Stream(HTTP2Session session, int streamId, MetaData.Request request, boolean local) {
        this.session = session;
        this.streamId = streamId;
        this.request = request;
        this.local = local;
        this.dataLength = -1L;
        this.dataStalled = true;
    }

    @Override
    public int getId() {
        return this.streamId;
    }

    public boolean equals(Object o) {
        return this == o;
    }

    public int hashCode() {
        return this.streamId;
    }

    public Object getAttachment() {
        return this.attachment.get();
    }

    public void setAttachment(Object attachment) {
        this.attachment.set(attachment);
    }

    @Override
    public boolean isLocal() {
        return this.local;
    }

    @Override
    public HTTP2Session getSession() {
        return this.session;
    }

    @Override
    public void headers(HeadersFrame frame, Callback callback) {
        this.send(new FrameList(frame), callback);
    }

    public void send(FrameList frameList, Callback callback) {
        if (this.startWrite(callback)) {
            this.session.frames(this, frameList.getFrames(), this);
        }
    }

    @Override
    public void push(PushPromiseFrame frame, Promise<Stream> promise, Stream.Listener listener) {
        this.session.push(this, promise, frame, listener);
    }

    @Override
    public void data(DataFrame frame, Callback callback) {
        if (this.startWrite(callback)) {
            this.session.data(this, frame, this);
        }
    }

    @Override
    public void reset(ResetFrame frame, Callback callback) {
        int flowControlLength;
        Throwable resetFailure = null;
        try (AutoLock ignored = this.lock.lock();){
            if (this.isReset()) {
                resetFailure = this.failure;
            } else {
                this.localReset = true;
                this.failure = new EOFException("reset");
            }
            flowControlLength = this.drain();
        }
        this.session.dataConsumed(this, flowControlLength);
        if (resetFailure != null) {
            callback.failed(resetFailure);
        } else {
            this.session.reset(this, frame, callback);
        }
    }

    private boolean startWrite(Callback callback) {
        Throwable failure;
        try (AutoLock ignored = this.lock.lock();){
            failure = this.failure;
            if (failure == null && this.sendCallback == null) {
                this.sendCallback = callback;
                boolean bl = true;
                return bl;
            }
        }
        if (failure == null) {
            failure = new WritePendingException();
        }
        callback.failed(failure);
        return false;
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes().get(key);
    }

    @Override
    public void setAttribute(String key, Object value) {
        this.attributes().put(key, value);
    }

    @Override
    public Object removeAttribute(String key) {
        return this.attributes().remove(key);
    }

    @Override
    public boolean isReset() {
        try (AutoLock ignored = this.lock.lock();){
            boolean bl = this.localReset || this.remoteReset;
            return bl;
        }
    }

    private boolean isFailed() {
        try (AutoLock ignored = this.lock.lock();){
            boolean bl = this.failure != null;
            return bl;
        }
    }

    public boolean isResetOrFailed() {
        try (AutoLock ignored = this.lock.lock();){
            boolean bl = this.isReset() || this.isFailed();
            return bl;
        }
    }

    @Override
    public boolean isClosed() {
        return this.closeState.get() == CloseState.CLOSED;
    }

    @Override
    public boolean isRemotelyClosed() {
        CloseState state = this.closeState.get();
        return state == CloseState.REMOTELY_CLOSED || state == CloseState.CLOSING || state == CloseState.CLOSED;
    }

    public boolean isLocallyClosed() {
        return this.closeState.get() == CloseState.LOCALLY_CLOSED;
    }

    public void commit() {
        this.committed = true;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public boolean isOpen() {
        return !this.isClosed();
    }

    public void notIdle() {
        long idleTimeout = this.getIdleTimeout();
        if (idleTimeout > 0L) {
            this.expireNanoTime = NanoTime.now() + TimeUnit.MILLISECONDS.toNanos(idleTimeout);
        }
    }

    public long getExpireNanoTime() {
        return this.expireNanoTime;
    }

    @Override
    public long getIdleTimeout() {
        return this.idleTimeout;
    }

    @Override
    public void setIdleTimeout(long idleTimeout) {
        this.idleTimeout = idleTimeout;
        this.notIdle();
        this.session.scheduleTimeout(this);
    }

    protected void onIdleTimeout(TimeoutException timeout) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Idle timeout {}ms expired on {}", (Object)this.getIdleTimeout(), (Object)this);
        }
        this.notifyIdleTimeout(this, timeout, (Promise<Boolean>)Promise.from(timedOut -> {
            if (timedOut.booleanValue()) {
                this.reset(new ResetFrame(this.getId(), ErrorCode.CANCEL_STREAM_ERROR.code), Callback.NOOP);
            } else {
                this.notIdle();
            }
        }, x -> this.reset(new ResetFrame(this.getId(), ErrorCode.INTERNAL_ERROR.code), Callback.NOOP)));
    }

    private ConcurrentMap<String, Object> attributes() {
        ConcurrentMap<String, Object> map = this.attributes.get();
        if (map == null && !this.attributes.compareAndSet(null, map = new ConcurrentHashMap<String, Object>())) {
            map = this.attributes.get();
        }
        return map;
    }

    @Override
    public Stream.Listener getListener() {
        return this.listener;
    }

    public void setListener(Stream.Listener listener) {
        this.listener = listener;
        if (listener == null) {
            this.demand();
        }
    }

    public void process(Frame frame, Callback callback) {
        this.notIdle();
        switch (frame.getType()) {
            case PREFACE: {
                this.onNewStream(callback);
                break;
            }
            case HEADERS: {
                this.onHeaders((HeadersFrame)frame, callback);
                break;
            }
            case RST_STREAM: {
                this.onReset((ResetFrame)frame, callback);
                break;
            }
            case PUSH_PROMISE: {
                this.onPush((PushPromiseFrame)frame, callback);
                break;
            }
            case WINDOW_UPDATE: {
                this.onWindowUpdate((WindowUpdateFrame)frame, callback);
                break;
            }
            case FAILURE: {
                this.onFailure((FailureFrame)frame, callback);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    public void process(Stream.Data data) {
        this.notIdle();
        this.onData(data);
    }

    private void onNewStream(Callback callback) {
        this.notifyNewStream(this);
        callback.succeeded();
    }

    private void onHeaders(HeadersFrame frame, Callback callback) {
        boolean isTrailer;
        boolean offered = false;
        MetaData metaData = frame.getMetaData();
        boolean bl = isTrailer = !metaData.isRequest() && !metaData.isResponse();
        if (isTrailer) {
            boolean closed = this.updateClose(true, CloseState.Event.RECEIVED);
            this.notifyHeaders(this, frame);
            if (closed) {
                this.getSession().removeStream(this);
            }
            offered = this.offer(Stream.Data.eof(this.getId()));
        } else {
            HttpFields fields = metaData.getHttpFields();
            long length = -1L;
            if (fields != null && !HttpMethod.CONNECT.is(this.request.getMethod())) {
                length = fields.getLongField(HttpHeader.CONTENT_LENGTH);
            }
            this.dataLength = length;
            if (frame.isEndStream()) {
                offered = this.offer(Stream.Data.eof(this.getId()));
            }
            if (metaData.isResponse()) {
                boolean closed = this.updateClose(frame.isEndStream(), CloseState.Event.RECEIVED);
                this.notifyHeaders(this, frame);
                if (closed) {
                    this.getSession().removeStream(this);
                }
            }
        }
        if (offered) {
            this.processData();
        }
        callback.succeeded();
    }

    private void onData(Stream.Data data) {
        DataFrame frame = data.frame();
        if (this.isRemotelyClosed()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Data {} for already closed {}", (Object)data, (Object)this);
            }
            this.session.dataConsumed(this, data.frame().flowControlLength());
            this.reset(new ResetFrame(this.streamId, ErrorCode.STREAM_CLOSED_ERROR.code), Callback.NOOP);
            return;
        }
        if (this.isReset()) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Data {} for already reset {}", (Object)data, (Object)this);
            }
            this.session.dataConsumed(this, data.frame().flowControlLength());
            return;
        }
        if (this.dataLength >= 0L) {
            this.dataLength -= (long)frame.remaining();
            if (this.dataLength < 0L || frame.isEndStream() && this.dataLength != 0L) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Invalid data length {} for {}", (Object)data, (Object)this);
                }
                this.session.dataConsumed(this, data.frame().flowControlLength());
                this.reset(new ResetFrame(this.streamId, ErrorCode.PROTOCOL_ERROR.code), Callback.NOOP);
                return;
            }
        }
        if (this.offer(data)) {
            this.processData();
        }
    }

    private boolean offer(Stream.Data data) {
        boolean process;
        data.retain();
        try (AutoLock ignored = this.lock.lock();){
            process = this.dataQueue.isEmpty() && this.dataDemand;
            this.dataQueue.offer(data);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Data {} notifying onDataAvailable() {} for {}", new Object[]{data, process, this});
        }
        return process;
    }

    @Override
    public Stream.Data readData() {
        Stream.Data data;
        try (AutoLock ignored = this.lock.lock();){
            if (this.dataQueue.isEmpty()) {
                Stream.Data data2 = null;
                return data2;
            }
            data = this.dataQueue.poll();
            if (data.frame().isEndStream()) {
                this.dataQueue.offer(Stream.Data.eof(this.getId()));
            }
        }
        if (this.updateClose(data.frame().isEndStream(), CloseState.Event.RECEIVED)) {
            this.session.removeStream(this);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Reading {} for {}", (Object)data, (Object)this);
        }
        this.notIdle();
        this.session.dataConsumed(this, data.frame().flowControlLength());
        return data;
    }

    @Override
    public void demand() {
        boolean process = false;
        try (AutoLock ignored = this.lock.lock();){
            this.dataDemand = true;
            if (this.dataStalled && !this.dataQueue.isEmpty()) {
                this.dataStalled = false;
                process = true;
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Demand, {} data processing for {}", (Object)(process ? "proceeding" : "stalling"), (Object)this);
        }
        if (process) {
            this.processData();
        }
    }

    public void processData() {
        while (true) {
            try (AutoLock ignored = this.lock.lock();){
                if (this.dataQueue.isEmpty() || !this.dataDemand) {
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Stalling data processing for {}", (Object)this);
                    }
                    this.dataStalled = true;
                    return;
                }
                this.dataDemand = false;
                this.dataStalled = false;
            }
            this.notifyDataAvailable(this);
        }
    }

    private boolean hasDemand() {
        try (AutoLock ignored = this.lock.lock();){
            boolean bl = this.dataDemand;
            return bl;
        }
    }

    private int dataSize() {
        try (AutoLock ignored = this.lock.lock();){
            int n = this.dataQueue.size();
            return n;
        }
    }

    public long getDataLength() {
        try (AutoLock ignored = this.lock.lock();){
            long l = this.dataQueue.stream().mapToLong(data -> data.frame().remaining()).sum();
            return l;
        }
    }

    private void onReset(ResetFrame frame, Callback callback) {
        int flowControlLength;
        try (AutoLock ignored = this.lock.lock();){
            this.remoteReset = true;
            this.failure = new EofException("reset");
            flowControlLength = this.drain();
        }
        this.close();
        boolean removed = this.session.removeStream(this);
        this.session.dataConsumed(this, flowControlLength);
        if (removed) {
            this.notifyReset(this, frame, callback);
        } else {
            callback.succeeded();
        }
    }

    private void onPush(PushPromiseFrame frame, Callback callback) {
        this.updateClose(true, CloseState.Event.AFTER_SEND);
        callback.succeeded();
    }

    private void onWindowUpdate(WindowUpdateFrame frame, Callback callback) {
        callback.succeeded();
    }

    private void onFailure(FailureFrame frame, Callback callback) {
        int flowControlLength;
        try (AutoLock ignored = this.lock.lock();){
            this.failure = frame.getFailure();
            flowControlLength = this.drain();
        }
        this.close();
        boolean removed = this.session.removeStream(this);
        this.session.dataConsumed(this, flowControlLength);
        if (removed) {
            this.notifyFailure(this, frame, callback);
        } else {
            callback.succeeded();
        }
    }

    private int drain() {
        Stream.Data data;
        assert (this.lock.isHeldByCurrentThread());
        int length = 0;
        while ((data = this.dataQueue.poll()) != null) {
            data.release();
            DataFrame frame = data.frame();
            length += frame.flowControlLength();
            if (!frame.isEndStream()) continue;
            this.dataQueue.offer(Stream.Data.eof(this.getId()));
            break;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Drained {} bytes for {}", (Object)length, (Object)this);
        }
        return length;
    }

    public boolean updateClose(boolean update, CloseState.Event event) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Update close for {} update={} event={}", new Object[]{this, update, event});
        }
        if (!update) {
            return false;
        }
        return switch (event) {
            default -> throw new IncompatibleClassChangeError();
            case CloseState.Event.RECEIVED -> this.updateCloseAfterReceived();
            case CloseState.Event.BEFORE_SEND -> this.updateCloseBeforeSend();
            case CloseState.Event.AFTER_SEND -> this.updateCloseAfterSend();
        };
    }

    /*
     * Unable to fully structure code
     */
    private boolean updateCloseAfterReceived() {
        block5: while (true) {
            current = this.closeState.get();
            switch (1.$SwitchMap$org$eclipse$jetty$http2$CloseState[current.ordinal()]) {
                case 1: {
                    if (!this.closeState.compareAndSet(current, CloseState.REMOTELY_CLOSED)) continue block5;
                    return false;
                }
                case 2: {
                    if (this.closeState.compareAndSet(current, CloseState.CLOSING)) ** break;
                    continue block5;
                    this.updateStreamCount(0, 1);
                    return false;
                }
                case 3: {
                    this.close();
                    return true;
                }
            }
            break;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private boolean updateCloseBeforeSend() {
        block4: while (true) {
            current = this.closeState.get();
            switch (1.$SwitchMap$org$eclipse$jetty$http2$CloseState[current.ordinal()]) {
                case 1: {
                    if (!this.closeState.compareAndSet(current, CloseState.LOCALLY_CLOSING)) continue block4;
                    return false;
                }
                case 4: {
                    if (this.closeState.compareAndSet(current, CloseState.CLOSING)) ** break;
                    continue block4;
                    this.updateStreamCount(0, 1);
                    return false;
                }
            }
            break;
        }
        return false;
    }

    private boolean updateCloseAfterSend() {
        block4: while (true) {
            CloseState current = this.closeState.get();
            switch (current) {
                case NOT_CLOSED: 
                case LOCALLY_CLOSING: {
                    if (!this.closeState.compareAndSet(current, CloseState.LOCALLY_CLOSED)) continue block4;
                    return false;
                }
                case REMOTELY_CLOSED: 
                case CLOSING: {
                    this.close();
                    return true;
                }
            }
            break;
        }
        return false;
    }

    public int getSendWindow() {
        return this.sendWindow.get();
    }

    public int getRecvWindow() {
        return this.recvWindow.get();
    }

    public int updateSendWindow(int delta) {
        return this.sendWindow.getAndAdd(delta);
    }

    public int updateRecvWindow(int delta) {
        return this.recvWindow.getAndAdd(delta);
    }

    @Override
    public void close() {
        CloseState oldState = this.closeState.getAndSet(CloseState.CLOSED);
        if (oldState != CloseState.CLOSED) {
            int deltaClosing = oldState == CloseState.CLOSING ? -1 : 0;
            this.updateStreamCount(-1, deltaClosing);
            this.onClose();
        }
    }

    public void onClose() {
        this.notifyClosed(this);
    }

    private void updateStreamCount(int deltaStream, int deltaClosing) {
        this.session.updateStreamCount(this.isLocal(), deltaStream, deltaClosing);
    }

    public void succeeded() {
        Callback callback = this.endWrite();
        if (callback != null) {
            callback.succeeded();
        }
    }

    public void failed(Throwable x) {
        Callback callback = this.endWrite();
        if (callback != null) {
            callback.failed(x);
        }
    }

    public Invocable.InvocationType getInvocationType() {
        try (AutoLock ignored = this.lock.lock();){
            Invocable.InvocationType invocationType = this.sendCallback != null ? this.sendCallback.getInvocationType() : super.getInvocationType();
            return invocationType;
        }
    }

    private Callback endWrite() {
        try (AutoLock ignored = this.lock.lock();){
            Callback callback = this.sendCallback;
            this.sendCallback = null;
            Callback callback2 = callback;
            return callback2;
        }
    }

    private void notifyNewStream(Stream stream) {
        Stream.Listener listener = this.listener;
        if (listener != null) {
            try {
                listener.onNewStream(stream);
            }
            catch (Throwable x) {
                LOG.info("Failure while notifying listener {}", (Object)listener, (Object)x);
            }
        }
    }

    protected void notifyHeaders(Stream stream, HeadersFrame frame) {
        Stream.Listener listener = stream.getListener();
        if (listener == null) {
            return;
        }
        try {
            listener.onHeaders(stream, frame);
        }
        catch (Throwable x) {
            LOG.info("Failure while notifying listener {}", (Object)listener, (Object)x);
        }
    }

    private void notifyDataAvailable(Stream stream) {
        Stream.Listener listener = Objects.requireNonNullElse(this.listener, Stream.Listener.AUTO_DISCARD);
        try {
            listener.onDataAvailable(stream);
        }
        catch (Throwable x) {
            LOG.info("Failure while notifying listener {}", (Object)listener, (Object)x);
        }
    }

    private void notifyReset(Stream stream, ResetFrame frame, Callback callback) {
        Stream.Listener listener = this.listener;
        if (listener != null) {
            try {
                listener.onReset(stream, frame, callback);
            }
            catch (Throwable x) {
                LOG.info("Failure while notifying listener {}", (Object)listener, (Object)x);
                callback.failed(x);
            }
        } else {
            callback.succeeded();
        }
    }

    private void notifyIdleTimeout(Stream stream, TimeoutException failure, Promise<Boolean> promise) {
        Stream.Listener listener = this.listener;
        if (listener != null) {
            try {
                listener.onIdleTimeout(stream, failure, promise);
            }
            catch (Throwable x) {
                LOG.info("Failure while notifying listener {}", (Object)listener, (Object)x);
                promise.failed(x);
            }
        } else {
            promise.succeeded((Object)true);
        }
    }

    private void notifyFailure(Stream stream, FailureFrame frame, Callback callback) {
        Stream.Listener listener = this.listener;
        if (listener != null) {
            try {
                listener.onFailure(stream, frame.getError(), frame.getReason(), frame.getFailure(), callback);
            }
            catch (Throwable x) {
                LOG.info("Failure while notifying listener {}", (Object)listener, (Object)x);
                callback.failed(x);
            }
        } else {
            callback.succeeded();
        }
    }

    private void notifyClosed(Stream stream) {
        Stream.Listener listener = this.listener;
        if (listener == null) {
            return;
        }
        try {
            listener.onClosed(stream);
        }
        catch (Throwable x) {
            LOG.info("Failure while notifying listener {}", (Object)listener, (Object)x);
        }
    }

    public String dump() {
        return Dumpable.dump((Dumpable)this);
    }

    public void dump(Appendable out, String indent) throws IOException {
        out.append(this.toString()).append(System.lineSeparator());
    }

    public String toString() {
        return String.format("%s#%d@%x{sendWindow=%s,recvWindow=%s,queue=%d,demand=%b,reset=%b/%b,%s,age=%d,attachment=%s}", this.getClass().getSimpleName(), this.getId(), this.session.hashCode(), this.sendWindow, this.recvWindow, this.dataSize(), this.hasDemand(), this.localReset, this.remoteReset, this.closeState, NanoTime.millisSince((long)this.creationNanoTime), this.attachment);
    }

    public static class FrameList {
        private final List<StreamFrame> frames;

        public FrameList(HeadersFrame headers) {
            Objects.requireNonNull(headers);
            this.frames = List.of(headers);
        }

        public FrameList(HeadersFrame headers, DataFrame data, HeadersFrame trailers) {
            Objects.requireNonNull(headers);
            ArrayList<StreamFrame> frames = new ArrayList<StreamFrame>(3);
            int streamId = headers.getStreamId();
            if (data != null && data.getStreamId() != streamId) {
                throw new IllegalArgumentException("Invalid stream ID for DATA frame " + String.valueOf(data));
            }
            if (trailers != null && trailers.getStreamId() != streamId) {
                throw new IllegalArgumentException("Invalid stream ID for HEADERS frame " + String.valueOf(trailers));
            }
            frames.add(headers);
            if (data != null) {
                frames.add(data);
            }
            if (trailers != null) {
                frames.add(trailers);
            }
            this.frames = Collections.unmodifiableList(frames);
        }

        public int getStreamId() {
            return this.frames.get(0).getStreamId();
        }

        public List<StreamFrame> getFrames() {
            return this.frames;
        }
    }
}

