/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.http2.server.internal;

import java.util.function.BiConsumer;
import org.eclipse.jetty.http2.HTTP2Channel;
import org.eclipse.jetty.http2.HTTP2Stream;
import org.eclipse.jetty.http2.HTTP2StreamEndPoint;
import org.eclipse.jetty.http2.frames.HeadersFrame;
import org.eclipse.jetty.io.Connection;
import org.eclipse.jetty.util.Callback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerHTTP2StreamEndPoint
extends HTTP2StreamEndPoint
implements HTTP2Channel.Server {
    private static final Logger LOG = LoggerFactory.getLogger(ServerHTTP2StreamEndPoint.class);

    public ServerHTTP2StreamEndPoint(HTTP2Stream stream) {
        super(stream);
    }

    public Runnable onDataAvailable() {
        this.processDataAvailable();
        return null;
    }

    public Runnable onTrailer(HeadersFrame frame) {
        return null;
    }

    public void onTimeout(Throwable failure, BiConsumer<Runnable, Boolean> consumer) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("idle timeout on {}: {}", (Object)this, (Object)failure);
        }
        boolean result = true;
        Connection connection = this.getConnection();
        if (connection != null) {
            result = connection.onIdleExpired();
        }
        Runnable r = null;
        if (result) {
            this.processFailure(failure);
            r = () -> this.close(failure);
        }
        consumer.accept(r, result);
    }

    public Runnable onFailure(Throwable failure, Callback callback) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("failure on {}: {}", (Object)this, (Object)failure);
        }
        this.processFailure(failure);
        this.close(failure);
        return () -> ((Callback)callback).succeeded();
    }

    public boolean isIdle() {
        return false;
    }
}

